// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53resolver.model.GetResolverRuleAssociationResponse
import aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociation
import aws.sdk.kotlin.services.route53resolver.model.Route53ResolverException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResolverRuleAssociationOperationDeserializer: HttpDeserialize<GetResolverRuleAssociationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetResolverRuleAssociationResponse {
        if (!response.status.isSuccess()) {
            throwGetResolverRuleAssociationError(context, response)
        }
        val builder = GetResolverRuleAssociationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResolverRuleAssociationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetResolverRuleAssociationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53ResolverException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Route53ResolverException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResolverRuleAssociationOperationBody(builder: GetResolverRuleAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOLVERRULEASSOCIATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResolverRuleAssociation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOLVERRULEASSOCIATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOLVERRULEASSOCIATION_DESCRIPTOR.index -> builder.resolverRuleAssociation = deserializeResolverRuleAssociationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
