// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.paginators

import aws.sdk.kotlin.services.route53resolver.Route53ResolverClient
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainListsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainListsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallDomainsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRuleGroupsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListFirewallRulesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverDnssecConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverDnssecConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverEndpointsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRuleAssociationsRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRuleAssociationsResponse
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest
import aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesResponse
import aws.sdk.kotlin.services.route53resolver.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.route53resolver.model.ListTagsForResourceResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListFirewallConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallConfigsResponse]
 */
fun Route53ResolverClient.listFirewallConfigsPaginated(initialRequest: ListFirewallConfigsRequest): Flow<ListFirewallConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallConfigsPaginated.listFirewallConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallConfigsResponse]
 */
fun Route53ResolverClient.listFirewallConfigsPaginated(block: ListFirewallConfigsRequest.Builder.() -> Unit): Flow<ListFirewallConfigsResponse> =
    listFirewallConfigsPaginated(ListFirewallConfigsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFirewallDomainListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallDomainListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainListsResponse]
 */
fun Route53ResolverClient.listFirewallDomainListsPaginated(initialRequest: ListFirewallDomainListsRequest): Flow<ListFirewallDomainListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallDomainListsPaginated.listFirewallDomainLists(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallDomainListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainListsResponse]
 */
fun Route53ResolverClient.listFirewallDomainListsPaginated(block: ListFirewallDomainListsRequest.Builder.() -> Unit): Flow<ListFirewallDomainListsResponse> =
    listFirewallDomainListsPaginated(ListFirewallDomainListsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFirewallDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainsResponse]
 */
fun Route53ResolverClient.listFirewallDomainsPaginated(initialRequest: ListFirewallDomainsRequest): Flow<ListFirewallDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallDomainsPaginated.listFirewallDomains(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallDomainsResponse]
 */
fun Route53ResolverClient.listFirewallDomainsPaginated(block: ListFirewallDomainsRequest.Builder.() -> Unit): Flow<ListFirewallDomainsResponse> =
    listFirewallDomainsPaginated(ListFirewallDomainsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFirewallRuleGroupAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallRuleGroupAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupAssociationsResponse]
 */
fun Route53ResolverClient.listFirewallRuleGroupAssociationsPaginated(initialRequest: ListFirewallRuleGroupAssociationsRequest): Flow<ListFirewallRuleGroupAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallRuleGroupAssociationsPaginated.listFirewallRuleGroupAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallRuleGroupAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupAssociationsResponse]
 */
fun Route53ResolverClient.listFirewallRuleGroupAssociationsPaginated(block: ListFirewallRuleGroupAssociationsRequest.Builder.() -> Unit): Flow<ListFirewallRuleGroupAssociationsResponse> =
    listFirewallRuleGroupAssociationsPaginated(ListFirewallRuleGroupAssociationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFirewallRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallRuleGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupsResponse]
 */
fun Route53ResolverClient.listFirewallRuleGroupsPaginated(initialRequest: ListFirewallRuleGroupsRequest): Flow<ListFirewallRuleGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallRuleGroupsPaginated.listFirewallRuleGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRuleGroupsResponse]
 */
fun Route53ResolverClient.listFirewallRuleGroupsPaginated(block: ListFirewallRuleGroupsRequest.Builder.() -> Unit): Flow<ListFirewallRuleGroupsResponse> =
    listFirewallRuleGroupsPaginated(ListFirewallRuleGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFirewallRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRulesResponse]
 */
fun Route53ResolverClient.listFirewallRulesPaginated(initialRequest: ListFirewallRulesRequest): Flow<ListFirewallRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallRulesPaginated.listFirewallRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallRulesResponse]
 */
fun Route53ResolverClient.listFirewallRulesPaginated(block: ListFirewallRulesRequest.Builder.() -> Unit): Flow<ListFirewallRulesResponse> =
    listFirewallRulesPaginated(ListFirewallRulesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverConfigsResponse]
 */
fun Route53ResolverClient.listResolverConfigsPaginated(initialRequest: ListResolverConfigsRequest): Flow<ListResolverConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverConfigsPaginated.listResolverConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverConfigsResponse]
 */
fun Route53ResolverClient.listResolverConfigsPaginated(block: ListResolverConfigsRequest.Builder.() -> Unit): Flow<ListResolverConfigsResponse> =
    listResolverConfigsPaginated(ListResolverConfigsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverDnssecConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverDnssecConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverDnssecConfigsResponse]
 */
fun Route53ResolverClient.listResolverDnssecConfigsPaginated(initialRequest: ListResolverDnssecConfigsRequest): Flow<ListResolverDnssecConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverDnssecConfigsPaginated.listResolverDnssecConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverDnssecConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverDnssecConfigsResponse]
 */
fun Route53ResolverClient.listResolverDnssecConfigsPaginated(block: ListResolverDnssecConfigsRequest.Builder.() -> Unit): Flow<ListResolverDnssecConfigsResponse> =
    listResolverDnssecConfigsPaginated(ListResolverDnssecConfigsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverEndpointIpAddressesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverEndpointIpAddressesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointIpAddressesResponse]
 */
fun Route53ResolverClient.listResolverEndpointIpAddressesPaginated(initialRequest: ListResolverEndpointIpAddressesRequest): Flow<ListResolverEndpointIpAddressesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverEndpointIpAddressesPaginated.listResolverEndpointIpAddresses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverEndpointIpAddressesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointIpAddressesResponse]
 */
fun Route53ResolverClient.listResolverEndpointIpAddressesPaginated(block: ListResolverEndpointIpAddressesRequest.Builder.() -> Unit): Flow<ListResolverEndpointIpAddressesResponse> =
    listResolverEndpointIpAddressesPaginated(ListResolverEndpointIpAddressesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointsResponse]
 */
fun Route53ResolverClient.listResolverEndpointsPaginated(initialRequest: ListResolverEndpointsRequest): Flow<ListResolverEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverEndpointsPaginated.listResolverEndpoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverEndpointsResponse]
 */
fun Route53ResolverClient.listResolverEndpointsPaginated(block: ListResolverEndpointsRequest.Builder.() -> Unit): Flow<ListResolverEndpointsResponse> =
    listResolverEndpointsPaginated(ListResolverEndpointsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverQueryLogConfigAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverQueryLogConfigAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigAssociationsResponse]
 */
fun Route53ResolverClient.listResolverQueryLogConfigAssociationsPaginated(initialRequest: ListResolverQueryLogConfigAssociationsRequest): Flow<ListResolverQueryLogConfigAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverQueryLogConfigAssociationsPaginated.listResolverQueryLogConfigAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverQueryLogConfigAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigAssociationsResponse]
 */
fun Route53ResolverClient.listResolverQueryLogConfigAssociationsPaginated(block: ListResolverQueryLogConfigAssociationsRequest.Builder.() -> Unit): Flow<ListResolverQueryLogConfigAssociationsResponse> =
    listResolverQueryLogConfigAssociationsPaginated(ListResolverQueryLogConfigAssociationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverQueryLogConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverQueryLogConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigsResponse]
 */
fun Route53ResolverClient.listResolverQueryLogConfigsPaginated(initialRequest: ListResolverQueryLogConfigsRequest): Flow<ListResolverQueryLogConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverQueryLogConfigsPaginated.listResolverQueryLogConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverQueryLogConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverQueryLogConfigsResponse]
 */
fun Route53ResolverClient.listResolverQueryLogConfigsPaginated(block: ListResolverQueryLogConfigsRequest.Builder.() -> Unit): Flow<ListResolverQueryLogConfigsResponse> =
    listResolverQueryLogConfigsPaginated(ListResolverQueryLogConfigsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverRuleAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverRuleAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRuleAssociationsResponse]
 */
fun Route53ResolverClient.listResolverRuleAssociationsPaginated(initialRequest: ListResolverRuleAssociationsRequest): Flow<ListResolverRuleAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverRuleAssociationsPaginated.listResolverRuleAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverRuleAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRuleAssociationsResponse]
 */
fun Route53ResolverClient.listResolverRuleAssociationsPaginated(block: ListResolverRuleAssociationsRequest.Builder.() -> Unit): Flow<ListResolverRuleAssociationsResponse> =
    listResolverRuleAssociationsPaginated(ListResolverRuleAssociationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResolverRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolverRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRulesResponse]
 */
fun Route53ResolverClient.listResolverRulesPaginated(initialRequest: ListResolverRulesRequest): Flow<ListResolverRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolverRulesPaginated.listResolverRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResolverRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolverRulesResponse]
 */
fun Route53ResolverClient.listResolverRulesPaginated(block: ListResolverRulesRequest.Builder.() -> Unit): Flow<ListResolverRulesResponse> =
    listResolverRulesPaginated(ListResolverRulesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun Route53ResolverClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun Route53ResolverClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())
