// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



class UpdateFirewallDomainsRequest private constructor(builder: Builder) {
    /**
     * A list of domains to use in the update operation.
     *
     * Each domain specification in your domain list must satisfy the following requirements:
     * + It can optionally start with `*` (asterisk).
     * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
     * + It must be from 1-255 characters in length.
     */
    val domains: List<String>? = builder.domains
    /**
     * The ID of the domain list whose domains you want to update.
     */
    val firewallDomainListId: kotlin.String? = builder.firewallDomainListId
    /**
     * What you want DNS Firewall to do with the domains that you are providing:
     * + `ADD` - Add the domains to the ones that are already in the domain list.
     * + `REMOVE` - Search the domain list for the domains and remove them from the list.
     * + `REPLACE` - Update the domain list to exactly match the list that you are providing.
     */
    val operation: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainUpdateOperation? = builder.operation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallDomainsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFirewallDomainsRequest(")
        append("domains=$domains,")
        append("firewallDomainListId=$firewallDomainListId,")
        append("operation=$operation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domains?.hashCode() ?: 0
        result = 31 * result + (firewallDomainListId?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFirewallDomainsRequest

        if (domains != other.domains) return false
        if (firewallDomainListId != other.firewallDomainListId) return false
        if (operation != other.operation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallDomainsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of domains to use in the update operation.
         *
         * Each domain specification in your domain list must satisfy the following requirements:
         * + It can optionally start with `*` (asterisk).
         * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
         * + It must be from 1-255 characters in length.
         */
        var domains: List<String>? = null
        /**
         * The ID of the domain list whose domains you want to update.
         */
        var firewallDomainListId: kotlin.String? = null
        /**
         * What you want DNS Firewall to do with the domains that you are providing:
         * + `ADD` - Add the domains to the ones that are already in the domain list.
         * + `REMOVE` - Search the domain list for the domains and remove them from the list.
         * + `REPLACE` - Update the domain list to exactly match the list that you are providing.
         */
        var operation: aws.sdk.kotlin.services.route53resolver.model.FirewallDomainUpdateOperation? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallDomainsRequest) : this() {
            this.domains = x.domains
            this.firewallDomainListId = x.firewallDomainListId
            this.operation = x.operation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.UpdateFirewallDomainsRequest = UpdateFirewallDomainsRequest(this)
    }
}
