// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In an [UpdateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html) request, information about the changes that you want to make.
 */
class ResolverRuleConfig private constructor(builder: Builder) {
    /**
     * The new name for the Resolver rule. The name that you specify appears in the Resolver dashboard in the Route 53 console.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ID of the new outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in `TargetIps`.
     */
    val resolverEndpointId: kotlin.String? = builder.resolverEndpointId
    /**
     * For DNS queries that originate in your VPC, the new IP addresses that you want to route outbound DNS queries to.
     */
    val targetIps: List<TargetAddress>? = builder.targetIps

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverRuleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverRuleConfig(")
        append("name=$name,")
        append("resolverEndpointId=$resolverEndpointId,")
        append("targetIps=$targetIps)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (resolverEndpointId?.hashCode() ?: 0)
        result = 31 * result + (targetIps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverRuleConfig

        if (name != other.name) return false
        if (resolverEndpointId != other.resolverEndpointId) return false
        if (targetIps != other.targetIps) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverRuleConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The new name for the Resolver rule. The name that you specify appears in the Resolver dashboard in the Route 53 console.
         */
        var name: kotlin.String? = null
        /**
         * The ID of the new outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in `TargetIps`.
         */
        var resolverEndpointId: kotlin.String? = null
        /**
         * For DNS queries that originate in your VPC, the new IP addresses that you want to route outbound DNS queries to.
         */
        var targetIps: List<TargetAddress>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverRuleConfig) : this() {
            this.name = x.name
            this.resolverEndpointId = x.resolverEndpointId
            this.targetIps = x.targetIps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverRuleConfig = ResolverRuleConfig(this)
    }
}
