// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In the response to an [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html), [DisassociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html), or [ListResolverRuleAssociations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html) request, provides information about an association between a Resolver rule and a VPC. The association determines which DNS queries that originate in the VPC are forwarded to your network.
 */
class ResolverRuleAssociation private constructor(builder: Builder) {
    /**
     * The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html) request.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of an association between a Resolver rule and a VPC.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ID of the Resolver rule that you associated with the VPC that is specified by `VPCId`.
     */
    val resolverRuleId: kotlin.String? = builder.resolverRuleId
    /**
     * A code that specifies the current status of the association between a Resolver rule and a VPC.
     */
    val status: aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociationStatus? = builder.status
    /**
     * A detailed description of the status of the association between a Resolver rule and a VPC.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The ID of the VPC that you associated the Resolver rule with.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolverRuleAssociation(")
        append("id=$id,")
        append("name=$name,")
        append("resolverRuleId=$resolverRuleId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resolverRuleId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolverRuleAssociation

        if (id != other.id) return false
        if (name != other.name) return false
        if (resolverRuleId != other.resolverRuleId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html) request.
         */
        var id: kotlin.String? = null
        /**
         * The name of an association between a Resolver rule and a VPC.
         */
        var name: kotlin.String? = null
        /**
         * The ID of the Resolver rule that you associated with the VPC that is specified by `VPCId`.
         */
        var resolverRuleId: kotlin.String? = null
        /**
         * A code that specifies the current status of the association between a Resolver rule and a VPC.
         */
        var status: aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociationStatus? = null
        /**
         * A detailed description of the status of the association between a Resolver rule and a VPC.
         */
        var statusMessage: kotlin.String? = null
        /**
         * The ID of the VPC that you associated the Resolver rule with.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociation) : this() {
            this.id = x.id
            this.name = x.name
            this.resolverRuleId = x.resolverRuleId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ResolverRuleAssociation = ResolverRuleAssociation(this)
    }
}
