// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



class ListResolverRulesRequest private constructor(builder: Builder) {
    /**
     * An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.
     *
     * If you submit a second or subsequent `ListResolverRules` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of Resolver rules that you want to return in the response to a `ListResolverRules` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 Resolver rules.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListResolverRules` request, omit this value.
     *
     * If you have more than `MaxResults` Resolver rules, you can submit another `ListResolverRules` request to get the next group of Resolver rules. In the next request, specify the value of `NextToken` from the previous response.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResolverRulesRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResolverRulesRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.
         *
         * If you submit a second or subsequent `ListResolverRules` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
         */
        var filters: List<Filter>? = null
        /**
         * The maximum number of Resolver rules that you want to return in the response to a `ListResolverRules` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 Resolver rules.
         */
        var maxResults: kotlin.Int? = null
        /**
         * For the first `ListResolverRules` request, omit this value.
         *
         * If you have more than `MaxResults` Resolver rules, you can submit another `ListResolverRules` request to get the next group of Resolver rules. In the next request, specify the value of `NextToken` from the previous response.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ListResolverRulesRequest = ListResolverRulesRequest(this)
    }
}
