// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



class ListResolverQueryLogConfigsRequest private constructor(builder: Builder) {
    /**
     * An optional specification to return a subset of query logging configurations.
     *
     * If you submit a second or subsequent `ListResolverQueryLogConfigs` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of query logging configurations that you want to return in the response to a `ListResolverQueryLogConfigs` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 query logging configurations.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListResolverQueryLogConfigs` request, omit this value.
     *
     * If there are more than `MaxResults` query logging configurations that match the values that you specify for `Filters`, you can submit another `ListResolverQueryLogConfigs` request to get the next group of configurations. In the next request, specify the value of `NextToken` from the previous response.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The element that you want Resolver to sort query logging configurations by.
     *
     * If you submit a second or subsequent `ListResolverQueryLogConfigs` request and specify the `NextToken` parameter, you must use the same value for `SortBy`, if any, as in the previous request.
     *
     * Valid values include the following elements:
     * + `Arn`: The ARN of the query logging configuration
     * + `AssociationCount`: The number of VPCs that are associated with the specified configuration
     * + `CreationTime`: The date and time that Resolver returned when the configuration was created
     * + `CreatorRequestId`: The value that was specified for `CreatorRequestId` when the configuration was created
     * + `DestinationArn`: The location that logs are sent to
     * + `Id`: The ID of the configuration
     * + `Name`: The name of the configuration
     * + `OwnerId`: The Amazon Web Services account number of the account that created the configuration
     * + `ShareStatus`: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
     * + `Status`: The current status of the configuration. Valid values include the following:
     *    + `CREATING`: Resolver is creating the query logging configuration.
     *    + `CREATED`: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
     *    + `DELETING`: Resolver is deleting this query logging configuration.
     *    + `FAILED`: Resolver either couldn't create or couldn't delete the query logging configuration. Here are two common causes:
     *       + The specified destination (for example, an Amazon S3 bucket) was deleted.
     *       + Permissions don't allow sending logs to the destination.
     */
    val sortBy: kotlin.String? = builder.sortBy
    /**
     * If you specified a value for `SortBy`, the order that you want query logging configurations to be listed in, `ASCENDING` or `DESCENDING`.
     *
     * If you submit a second or subsequent `ListResolverQueryLogConfigs` request and specify the `NextToken` parameter, you must use the same value for `SortOrder`, if any, as in the previous request.
     */
    val sortOrder: aws.sdk.kotlin.services.route53resolver.model.SortOrder? = builder.sortOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResolverQueryLogConfigsRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResolverQueryLogConfigsRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An optional specification to return a subset of query logging configurations.
         *
         * If you submit a second or subsequent `ListResolverQueryLogConfigs` request and specify the `NextToken` parameter, you must use the same values for `Filters`, if any, as in the previous request.
         */
        var filters: List<Filter>? = null
        /**
         * The maximum number of query logging configurations that you want to return in the response to a `ListResolverQueryLogConfigs` request. If you don't specify a value for `MaxResults`, Resolver returns up to 100 query logging configurations.
         */
        var maxResults: kotlin.Int? = null
        /**
         * For the first `ListResolverQueryLogConfigs` request, omit this value.
         *
         * If there are more than `MaxResults` query logging configurations that match the values that you specify for `Filters`, you can submit another `ListResolverQueryLogConfigs` request to get the next group of configurations. In the next request, specify the value of `NextToken` from the previous response.
         */
        var nextToken: kotlin.String? = null
        /**
         * The element that you want Resolver to sort query logging configurations by.
         *
         * If you submit a second or subsequent `ListResolverQueryLogConfigs` request and specify the `NextToken` parameter, you must use the same value for `SortBy`, if any, as in the previous request.
         *
         * Valid values include the following elements:
         * + `Arn`: The ARN of the query logging configuration
         * + `AssociationCount`: The number of VPCs that are associated with the specified configuration
         * + `CreationTime`: The date and time that Resolver returned when the configuration was created
         * + `CreatorRequestId`: The value that was specified for `CreatorRequestId` when the configuration was created
         * + `DestinationArn`: The location that logs are sent to
         * + `Id`: The ID of the configuration
         * + `Name`: The name of the configuration
         * + `OwnerId`: The Amazon Web Services account number of the account that created the configuration
         * + `ShareStatus`: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
         * + `Status`: The current status of the configuration. Valid values include the following:
         *    + `CREATING`: Resolver is creating the query logging configuration.
         *    + `CREATED`: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.
         *    + `DELETING`: Resolver is deleting this query logging configuration.
         *    + `FAILED`: Resolver either couldn't create or couldn't delete the query logging configuration. Here are two common causes:
         *       + The specified destination (for example, an Amazon S3 bucket) was deleted.
         *       + Permissions don't allow sending logs to the destination.
         */
        var sortBy: kotlin.String? = null
        /**
         * If you specified a value for `SortBy`, the order that you want query logging configurations to be listed in, `ASCENDING` or `DESCENDING`.
         *
         * If you submit a second or subsequent `ListResolverQueryLogConfigs` request and specify the `NextToken` parameter, you must use the same value for `SortOrder`, if any, as in the previous request.
         */
        var sortOrder: aws.sdk.kotlin.services.route53resolver.model.SortOrder? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.ListResolverQueryLogConfigsRequest = ListResolverQueryLogConfigsRequest(this)
    }
}
