// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * In the response to a [GetResolverEndpoint](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html) request, information about the IP addresses that the Resolver endpoint uses for DNS queries.
 */
class IpAddressResponse private constructor(builder: Builder) {
    /**
     * The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    val creationTime: kotlin.String? = builder.creationTime
    /**
     * One IP address that the Resolver endpoint uses for DNS queries.
     */
    val ip: kotlin.String? = builder.ip
    /**
     * The ID of one IP address.
     */
    val ipId: kotlin.String? = builder.ipId
    /**
     * The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * A status code that gives the current status of the request.
     */
    val status: aws.sdk.kotlin.services.route53resolver.model.IpAddressStatus? = builder.status
    /**
     * A message that provides additional information about the status of the request.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The ID of one subnet.
     */
    val subnetId: kotlin.String? = builder.subnetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpAddressResponse(")
        append("creationTime=$creationTime,")
        append("ip=$ip,")
        append("ipId=$ipId,")
        append("modificationTime=$modificationTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (ip?.hashCode() ?: 0)
        result = 31 * result + (ipId?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpAddressResponse

        if (creationTime != other.creationTime) return false
        if (ip != other.ip) return false
        if (ipId != other.ipId) return false
        if (modificationTime != other.modificationTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        var creationTime: kotlin.String? = null
        /**
         * One IP address that the Resolver endpoint uses for DNS queries.
         */
        var ip: kotlin.String? = null
        /**
         * The ID of one IP address.
         */
        var ipId: kotlin.String? = null
        /**
         * The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        var modificationTime: kotlin.String? = null
        /**
         * A status code that gives the current status of the request.
         */
        var status: aws.sdk.kotlin.services.route53resolver.model.IpAddressStatus? = null
        /**
         * A message that provides additional information about the status of the request.
         */
        var statusMessage: kotlin.String? = null
        /**
         * The ID of one subnet.
         */
        var subnetId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse) : this() {
            this.creationTime = x.creationTime
            this.ip = x.ip
            this.ipId = x.ipId
            this.modificationTime = x.modificationTime
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.IpAddressResponse = IpAddressResponse(this)
    }
}
