// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * High-level information for a firewall rule group. A firewall rule group is a collection of rules that DNS Firewall uses to filter DNS network traffic for a VPC. To retrieve the rules for the rule group, call ListFirewallRules.
 */
class FirewallRuleGroup private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the rule group.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The ID of the rule group.
     */
    val id: kotlin.String? = builder.id
    /**
     * The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * The name of the rule group.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The number of rules in the rule group.
     */
    val ruleCount: kotlin.Int? = builder.ruleCount
    /**
     * Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
     */
    val shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = builder.shareStatus
    /**
     * The status of the domain list.
     */
    val status: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupStatus? = builder.status
    /**
     * Additional information about the status of the rule group, if available.
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallRuleGroup(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("id=$id,")
        append("modificationTime=$modificationTime,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("ruleCount=$ruleCount,")
        append("shareStatus=$shareStatus,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (ruleCount ?: 0)
        result = 31 * result + (shareStatus?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallRuleGroup

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (id != other.id) return false
        if (modificationTime != other.modificationTime) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (ruleCount != other.ruleCount) return false
        if (shareStatus != other.shareStatus) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN (Amazon Resource Name) of the rule group.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        var creationTime: kotlin.String? = null
        /**
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * The ID of the rule group.
         */
        var id: kotlin.String? = null
        /**
         * The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        var modificationTime: kotlin.String? = null
        /**
         * The name of the rule group.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you.
         */
        var ownerId: kotlin.String? = null
        /**
         * The number of rules in the rule group.
         */
        var ruleCount: kotlin.Int? = null
        /**
         * Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).
         */
        var shareStatus: aws.sdk.kotlin.services.route53resolver.model.ShareStatus? = null
        /**
         * The status of the domain list.
         */
        var status: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroupStatus? = null
        /**
         * Additional information about the status of the rule group, if available.
         */
        var statusMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroup) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.id = x.id
            this.modificationTime = x.modificationTime
            this.name = x.name
            this.ownerId = x.ownerId
            this.ruleCount = x.ruleCount
            this.shareStatus = x.shareStatus
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.FirewallRuleGroup = FirewallRuleGroup(this)
    }
}
