// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



/**
 * A single firewall rule in a rule group.
 */
class FirewallRule private constructor(builder: Builder) {
    /**
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:
     * + `ALLOW` - Permit the request to go through.
     * + `ALERT` - Permit the request to go through but send an alert to the logs.
     * + `BLOCK` - Disallow the request. If this is specified, additional handling details are provided in the rule's `BlockResponse` setting.
     */
    val action: aws.sdk.kotlin.services.route53resolver.model.Action? = builder.action
    /**
     * The DNS record's type. This determines the format of the record value that you provided in `BlockOverrideDomain`. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     */
    val blockOverrideDnsType: aws.sdk.kotlin.services.route53resolver.model.BlockOverrideDnsType? = builder.blockOverrideDnsType
    /**
     * The custom DNS record to send back in response to the query. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     */
    val blockOverrideDomain: kotlin.String? = builder.blockOverrideDomain
    /**
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
     */
    val blockOverrideTtl: kotlin.Int? = builder.blockOverrideTtl
    /**
     * The way that you want DNS Firewall to block the request. Used for the rule action setting `BLOCK`.
     * + `NODATA` - Respond indicating that the query was successful, but no response is available for it.
     * + `NXDOMAIN` - Respond indicating that the domain name that's in the query doesn't exist.
     * + `OVERRIDE` - Provide a custom override in the response. This option requires custom handling details in the rule's `BlockOverride*` settings.
     */
    val blockResponse: aws.sdk.kotlin.services.route53resolver.model.BlockResponse? = builder.blockResponse
    /**
     * The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    val creationTime: kotlin.String? = builder.creationTime
    /**
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of executing the operation twice. This can be any unique string, for example, a timestamp.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The ID of the domain list that's used in the rule.
     */
    val firewallDomainListId: kotlin.String? = builder.firewallDomainListId
    /**
     * The unique identifier of the firewall rule group of the rule.
     */
    val firewallRuleGroupId: kotlin.String? = builder.firewallRuleGroupId
    /**
     * The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
     */
    val modificationTime: kotlin.String? = builder.modificationTime
    /**
     * The name of the rule.
     */
    val name: kotlin.String? = builder.name
    /**
     * The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    val priority: kotlin.Int? = builder.priority

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.FirewallRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallRule(")
        append("action=$action,")
        append("blockOverrideDnsType=$blockOverrideDnsType,")
        append("blockOverrideDomain=$blockOverrideDomain,")
        append("blockOverrideTtl=$blockOverrideTtl,")
        append("blockResponse=$blockResponse,")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("firewallDomainListId=$firewallDomainListId,")
        append("firewallRuleGroupId=$firewallRuleGroupId,")
        append("modificationTime=$modificationTime,")
        append("name=$name,")
        append("priority=$priority)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (blockOverrideDnsType?.hashCode() ?: 0)
        result = 31 * result + (blockOverrideDomain?.hashCode() ?: 0)
        result = 31 * result + (blockOverrideTtl ?: 0)
        result = 31 * result + (blockResponse?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (firewallDomainListId?.hashCode() ?: 0)
        result = 31 * result + (firewallRuleGroupId?.hashCode() ?: 0)
        result = 31 * result + (modificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallRule

        if (action != other.action) return false
        if (blockOverrideDnsType != other.blockOverrideDnsType) return false
        if (blockOverrideDomain != other.blockOverrideDomain) return false
        if (blockOverrideTtl != other.blockOverrideTtl) return false
        if (blockResponse != other.blockResponse) return false
        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (firewallDomainListId != other.firewallDomainListId) return false
        if (firewallRuleGroupId != other.firewallRuleGroupId) return false
        if (modificationTime != other.modificationTime) return false
        if (name != other.name) return false
        if (priority != other.priority) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.FirewallRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:
         * + `ALLOW` - Permit the request to go through.
         * + `ALERT` - Permit the request to go through but send an alert to the logs.
         * + `BLOCK` - Disallow the request. If this is specified, additional handling details are provided in the rule's `BlockResponse` setting.
         */
        var action: aws.sdk.kotlin.services.route53resolver.model.Action? = null
        /**
         * The DNS record's type. This determines the format of the record value that you provided in `BlockOverrideDomain`. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         */
        var blockOverrideDnsType: aws.sdk.kotlin.services.route53resolver.model.BlockOverrideDnsType? = null
        /**
         * The custom DNS record to send back in response to the query. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         */
        var blockOverrideDomain: kotlin.String? = null
        /**
         * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action `BLOCK` with a `BlockResponse` setting of `OVERRIDE`.
         */
        var blockOverrideTtl: kotlin.Int? = null
        /**
         * The way that you want DNS Firewall to block the request. Used for the rule action setting `BLOCK`.
         * + `NODATA` - Respond indicating that the query was successful, but no response is available for it.
         * + `NXDOMAIN` - Respond indicating that the domain name that's in the query doesn't exist.
         * + `OVERRIDE` - Provide a custom override in the response. This option requires custom handling details in the rule's `BlockOverride*` settings.
         */
        var blockResponse: aws.sdk.kotlin.services.route53resolver.model.BlockResponse? = null
        /**
         * The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
         */
        var creationTime: kotlin.String? = null
        /**
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of executing the operation twice. This can be any unique string, for example, a timestamp.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * The ID of the domain list that's used in the rule.
         */
        var firewallDomainListId: kotlin.String? = null
        /**
         * The unique identifier of the firewall rule group of the rule.
         */
        var firewallRuleGroupId: kotlin.String? = null
        /**
         * The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
         */
        var modificationTime: kotlin.String? = null
        /**
         * The name of the rule.
         */
        var name: kotlin.String? = null
        /**
         * The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         */
        var priority: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.FirewallRule) : this() {
            this.action = x.action
            this.blockOverrideDnsType = x.blockOverrideDnsType
            this.blockOverrideDomain = x.blockOverrideDomain
            this.blockOverrideTtl = x.blockOverrideTtl
            this.blockResponse = x.blockResponse
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.firewallDomainListId = x.firewallDomainListId
            this.firewallRuleGroupId = x.firewallRuleGroupId
            this.modificationTime = x.modificationTime
            this.name = x.name
            this.priority = x.priority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.FirewallRule = FirewallRule(this)
    }
}
