// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



class CreateResolverRuleRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * DNS queries for this domain name are forwarded to the IP addresses that you specify in `TargetIps`. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in `TargetIps`.
     */
    val resolverEndpointId: kotlin.String? = builder.resolverEndpointId
    /**
     * When you want to forward DNS queries for specified domain name to resolvers on your network, specify `FORWARD`.
     *
     * When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify `SYSTEM`.
     *
     * For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify `FORWARD` for `RuleType`. To then have Resolver process queries for apex.example.com, you create a rule and specify `SYSTEM` for `RuleType`.
     *
     * Currently, only Resolver can create rules that have a value of `RECURSIVE` for `RuleType`.
     */
    val ruleType: aws.sdk.kotlin.services.route53resolver.model.RuleTypeOption? = builder.ruleType
    /**
     * A list of the tag keys and values that you want to associate with the endpoint.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.
     *
     * `TargetIps` is available only when the value of `Rule type` is `FORWARD`.
     */
    val targetIps: List<TargetAddress>? = builder.targetIps

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.CreateResolverRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResolverRuleRequest(")
        append("creatorRequestId=$creatorRequestId,")
        append("domainName=$domainName,")
        append("name=$name,")
        append("resolverEndpointId=$resolverEndpointId,")
        append("ruleType=$ruleType,")
        append("tags=$tags,")
        append("targetIps=$targetIps)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creatorRequestId?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resolverEndpointId?.hashCode() ?: 0)
        result = 31 * result + (ruleType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetIps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResolverRuleRequest

        if (creatorRequestId != other.creatorRequestId) return false
        if (domainName != other.domainName) return false
        if (name != other.name) return false
        if (resolverEndpointId != other.resolverEndpointId) return false
        if (ruleType != other.ruleType) return false
        if (tags != other.tags) return false
        if (targetIps != other.targetIps) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.CreateResolverRuleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * DNS queries for this domain name are forwarded to the IP addresses that you specify in `TargetIps`. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).
         */
        var domainName: kotlin.String? = null
        /**
         * A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
         */
        var name: kotlin.String? = null
        /**
         * The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in `TargetIps`.
         */
        var resolverEndpointId: kotlin.String? = null
        /**
         * When you want to forward DNS queries for specified domain name to resolvers on your network, specify `FORWARD`.
         *
         * When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify `SYSTEM`.
         *
         * For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify `FORWARD` for `RuleType`. To then have Resolver process queries for apex.example.com, you create a rule and specify `SYSTEM` for `RuleType`.
         *
         * Currently, only Resolver can create rules that have a value of `RECURSIVE` for `RuleType`.
         */
        var ruleType: aws.sdk.kotlin.services.route53resolver.model.RuleTypeOption? = null
        /**
         * A list of the tag keys and values that you want to associate with the endpoint.
         */
        var tags: List<Tag>? = null
        /**
         * The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.
         *
         * `TargetIps` is available only when the value of `Rule type` is `FORWARD`.
         */
        var targetIps: List<TargetAddress>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.CreateResolverRuleRequest) : this() {
            this.creatorRequestId = x.creatorRequestId
            this.domainName = x.domainName
            this.name = x.name
            this.resolverEndpointId = x.resolverEndpointId
            this.ruleType = x.ruleType
            this.tags = x.tags
            this.targetIps = x.targetIps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.CreateResolverRuleRequest = CreateResolverRuleRequest(this)
    }
}
