// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver.model



class CreateResolverEndpointRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Specify the applicable value:
     * + `INBOUND`: Resolver forwards DNS queries to the DNS service for a VPC from your network
     * + `OUTBOUND`: Resolver forwards DNS queries from the DNS service for a VPC to your network
     */
    val direction: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointDirection? = builder.direction
    /**
     * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
     */
    val ipAddresses: List<IpAddressRequest>? = builder.ipAddresses
    /**
     * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of the tag keys and values that you want to associate with the endpoint.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResolverEndpointRequest(")
        append("creatorRequestId=$creatorRequestId,")
        append("direction=$direction,")
        append("ipAddresses=$ipAddresses,")
        append("name=$name,")
        append("securityGroupIds=$securityGroupIds,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creatorRequestId?.hashCode() ?: 0
        result = 31 * result + (direction?.hashCode() ?: 0)
        result = 31 * result + (ipAddresses?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResolverEndpointRequest

        if (creatorRequestId != other.creatorRequestId) return false
        if (direction != other.direction) return false
        if (ipAddresses != other.ipAddresses) return false
        if (name != other.name) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string, for example, a date/time stamp.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * Specify the applicable value:
         * + `INBOUND`: Resolver forwards DNS queries to the DNS service for a VPC from your network
         * + `OUTBOUND`: Resolver forwards DNS queries from the DNS service for a VPC to your network
         */
        var direction: aws.sdk.kotlin.services.route53resolver.model.ResolverEndpointDirection? = null
        /**
         * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         */
        var ipAddresses: List<IpAddressRequest>? = null
        /**
         * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
         */
        var name: kotlin.String? = null
        /**
         * The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
         */
        var securityGroupIds: List<String>? = null
        /**
         * A list of the tag keys and values that you want to associate with the endpoint.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest) : this() {
            this.creatorRequestId = x.creatorRequestId
            this.direction = x.direction
            this.ipAddresses = x.ipAddresses
            this.name = x.name
            this.securityGroupIds = x.securityGroupIds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53resolver.model.CreateResolverEndpointRequest = CreateResolverEndpointRequest(this)
    }
}
