// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53resolver

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.route53resolver.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.route53resolver.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * When you create a VPC using Amazon VPC, you automatically get DNS resolution within the VPC from Route 53 Resolver. By default, Resolver answers DNS queries for VPC domain names such as domain names for EC2 instances or Elastic Load Balancing load balancers. Resolver performs recursive lookups against public name servers for all other domain names.
 *
 * You can also configure DNS resolution between your VPC and your network over a Direct Connect or VPN connection:
 *
 * **Forward DNS queries from resolvers on your network to Route 53 Resolver**
 *
 * DNS resolvers on your network can forward DNS queries to Resolver in a specified VPC. This allows your DNS resolvers to easily resolve domain names for Amazon Web Services resources such as EC2 instances or records in a Route 53 private hosted zone. For more information, see [How DNS Resolvers on Your Network Forward DNS Queries to Route 53 Resolver](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-network-to-vpc) in the *Amazon Route 53 Developer Guide*.
 *
 * **Conditionally forward queries from a VPC to resolvers on your network**
 *
 * You can configure Resolver to forward queries that it receives from EC2 instances in your VPCs to DNS resolvers on your network. To forward selected queries, you create Resolver rules that specify the domain names for the DNS queries that you want to forward (such as example.com), and the IP addresses of the DNS resolvers on your network that you want to forward the queries to. If a query matches multiple rules (example.com, acme.example.com), Resolver chooses the rule with the most specific match (acme.example.com) and forwards the query to the IP addresses that you specified in that rule. For more information, see [How Route 53 Resolver Forwards DNS Queries from Your VPCs to Your Network](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-vpc-to-network) in the *Amazon Route 53 Developer Guide*.
 *
 * Like Amazon VPC, Resolver is Regional. In each Region where you have VPCs, you can choose whether to forward queries from your VPCs to your network (outbound queries), from your network to your VPCs (inbound queries), or both.
 */
interface Route53ResolverClient : SdkClient {

    override val serviceName: String
        get() = "Route53Resolver"
    /**
     * Route53ResolverClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): Route53ResolverClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRoute53ResolverClient(config)
        }

        operator fun invoke(config: Config): Route53ResolverClient = DefaultRoute53ResolverClient(config)

        /**
         * Construct a [Route53ResolverClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Route53ResolverClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRoute53ResolverClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.
     */
    suspend fun associateFirewallRuleGroup(input: AssociateFirewallRuleGroupRequest): AssociateFirewallRuleGroupResponse

    /**
     * Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.
     */
    suspend fun associateFirewallRuleGroup(block: AssociateFirewallRuleGroupRequest.Builder.() -> Unit) = associateFirewallRuleGroup(AssociateFirewallRuleGroupRequest.Builder().apply(block).build())

    /**
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one `AssociateResolverEndpointIpAddress` request for each IP address.
     *
     * To remove an IP address from an endpoint, see [DisassociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
     */
    suspend fun associateResolverEndpointIpAddress(input: AssociateResolverEndpointIpAddressRequest): AssociateResolverEndpointIpAddressResponse

    /**
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one `AssociateResolverEndpointIpAddress` request for each IP address.
     *
     * To remove an IP address from an endpoint, see [DisassociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
     */
    suspend fun associateResolverEndpointIpAddress(block: AssociateResolverEndpointIpAddressRequest.Builder.() -> Unit) = associateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest.Builder().apply(block).build())

    /**
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one `AssociateResolverQueryLogConfig` request for each VPC.
     *
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     *
     * To remove a VPC from a query logging configuration, see [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     */
    suspend fun associateResolverQueryLogConfig(input: AssociateResolverQueryLogConfigRequest): AssociateResolverQueryLogConfigResponse

    /**
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one `AssociateResolverQueryLogConfig` request for each VPC.
     *
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     *
     * To remove a VPC from a query logging configuration, see [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     */
    suspend fun associateResolverQueryLogConfig(block: AssociateResolverQueryLogConfigRequest.Builder.() -> Unit) = associateResolverQueryLogConfig(AssociateResolverQueryLogConfigRequest.Builder().apply(block).build())

    /**
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
     */
    suspend fun associateResolverRule(input: AssociateResolverRuleRequest): AssociateResolverRuleResponse

    /**
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see [CreateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
     */
    suspend fun associateResolverRule(block: AssociateResolverRuleRequest.Builder.() -> Unit) = associateResolverRule(AssociateResolverRuleRequest.Builder().apply(block).build())

    /**
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using ImportFirewallDomains, or with domain strings, using UpdateFirewallDomains.
     */
    suspend fun createFirewallDomainList(input: CreateFirewallDomainListRequest): CreateFirewallDomainListResponse

    /**
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using ImportFirewallDomains, or with domain strings, using UpdateFirewallDomains.
     */
    suspend fun createFirewallDomainList(block: CreateFirewallDomainListRequest.Builder.() -> Unit) = createFirewallDomainList(CreateFirewallDomainListRequest.Builder().apply(block).build())

    /**
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     */
    suspend fun createFirewallRule(input: CreateFirewallRuleRequest): CreateFirewallRuleResponse

    /**
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     */
    suspend fun createFirewallRule(block: CreateFirewallRuleRequest.Builder.() -> Unit) = createFirewallRule(CreateFirewallRuleRequest.Builder().apply(block).build())

    /**
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.
     */
    suspend fun createFirewallRuleGroup(input: CreateFirewallRuleGroupRequest): CreateFirewallRuleGroupResponse

    /**
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.
     */
    suspend fun createFirewallRuleGroup(block: CreateFirewallRuleGroupRequest.Builder.() -> Unit) = createFirewallRuleGroup(CreateFirewallRuleGroupRequest.Builder().apply(block).build())

    /**
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * + An *inbound Resolver endpoint* forwards DNS queries to the DNS service for a VPC from your network.
     * + An *outbound Resolver endpoint* forwards DNS queries from the DNS service for a VPC to your network.
     */
    suspend fun createResolverEndpoint(input: CreateResolverEndpointRequest): CreateResolverEndpointResponse

    /**
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * + An *inbound Resolver endpoint* forwards DNS queries to the DNS service for a VPC from your network.
     * + An *outbound Resolver endpoint* forwards DNS queries from the DNS service for a VPC to your network.
     */
    suspend fun createResolverEndpoint(block: CreateResolverEndpointRequest.Builder.() -> Unit) = createResolverEndpoint(CreateResolverEndpointRequest.Builder().apply(block).build())

    /**
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.
     *
     * To specify which VPCs you want to log queries for, you use `AssociateResolverQueryLogConfig`. For more information, see [AssociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
     *
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.
     */
    suspend fun createResolverQueryLogConfig(input: CreateResolverQueryLogConfigRequest): CreateResolverQueryLogConfigResponse

    /**
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.
     *
     * To specify which VPCs you want to log queries for, you use `AssociateResolverQueryLogConfig`. For more information, see [AssociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
     *
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.
     */
    suspend fun createResolverQueryLogConfig(block: CreateResolverQueryLogConfigRequest.Builder.() -> Unit) = createResolverQueryLogConfig(CreateResolverQueryLogConfigRequest.Builder().apply(block).build())

    /**
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     */
    suspend fun createResolverRule(input: CreateResolverRuleRequest): CreateResolverRuleResponse

    /**
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     */
    suspend fun createResolverRule(block: CreateResolverRuleRequest.Builder.() -> Unit) = createResolverRule(CreateResolverRuleRequest.Builder().apply(block).build())

    /**
     * Deletes the specified domain list.
     */
    suspend fun deleteFirewallDomainList(input: DeleteFirewallDomainListRequest): DeleteFirewallDomainListResponse

    /**
     * Deletes the specified domain list.
     */
    suspend fun deleteFirewallDomainList(block: DeleteFirewallDomainListRequest.Builder.() -> Unit) = deleteFirewallDomainList(DeleteFirewallDomainListRequest.Builder().apply(block).build())

    /**
     * Deletes the specified firewall rule.
     */
    suspend fun deleteFirewallRule(input: DeleteFirewallRuleRequest): DeleteFirewallRuleResponse

    /**
     * Deletes the specified firewall rule.
     */
    suspend fun deleteFirewallRule(block: DeleteFirewallRuleRequest.Builder.() -> Unit) = deleteFirewallRule(DeleteFirewallRuleRequest.Builder().apply(block).build())

    /**
     * Deletes the specified firewall rule group.
     */
    suspend fun deleteFirewallRuleGroup(input: DeleteFirewallRuleGroupRequest): DeleteFirewallRuleGroupResponse

    /**
     * Deletes the specified firewall rule group.
     */
    suspend fun deleteFirewallRuleGroup(block: DeleteFirewallRuleGroupRequest.Builder.() -> Unit) = deleteFirewallRuleGroup(DeleteFirewallRuleGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:
     * + **Inbound**: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * + **Outbound**: DNS queries from a VPC are no longer routed to your network.
     */
    suspend fun deleteResolverEndpoint(input: DeleteResolverEndpointRequest): DeleteResolverEndpointResponse

    /**
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:
     * + **Inbound**: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * + **Outbound**: DNS queries from a VPC are no longer routed to your network.
     */
    suspend fun deleteResolverEndpoint(block: DeleteResolverEndpointRequest.Builder.() -> Unit) = deleteResolverEndpoint(DeleteResolverEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     *
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.
     */
    suspend fun deleteResolverQueryLogConfig(input: DeleteResolverQueryLogConfigRequest): DeleteResolverQueryLogConfigResponse

    /**
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See [DisassociateResolverQueryLogConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
     *
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.
     */
    suspend fun deleteResolverQueryLogConfig(block: DeleteResolverQueryLogConfigRequest.Builder.() -> Unit) = deleteResolverQueryLogConfig(DeleteResolverQueryLogConfigRequest.Builder().apply(block).build())

    /**
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see [DisassociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
     */
    suspend fun deleteResolverRule(input: DeleteResolverRuleRequest): DeleteResolverRuleResponse

    /**
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see [DisassociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
     */
    suspend fun deleteResolverRule(block: DeleteResolverRuleRequest.Builder.() -> Unit) = deleteResolverRule(DeleteResolverRuleRequest.Builder().apply(block).build())

    /**
     * Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.
     */
    suspend fun disassociateFirewallRuleGroup(input: DisassociateFirewallRuleGroupRequest): DisassociateFirewallRuleGroupResponse

    /**
     * Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.
     */
    suspend fun disassociateFirewallRuleGroup(block: DisassociateFirewallRuleGroupRequest.Builder.() -> Unit) = disassociateFirewallRuleGroup(DisassociateFirewallRuleGroupRequest.Builder().apply(block).build())

    /**
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one `DisassociateResolverEndpointIpAddress` request for each IP address.
     *
     * To add an IP address to an endpoint, see [AssociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
     */
    suspend fun disassociateResolverEndpointIpAddress(input: DisassociateResolverEndpointIpAddressRequest): DisassociateResolverEndpointIpAddressResponse

    /**
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one `DisassociateResolverEndpointIpAddress` request for each IP address.
     *
     * To add an IP address to an endpoint, see [AssociateResolverEndpointIpAddress](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
     */
    suspend fun disassociateResolverEndpointIpAddress(block: DisassociateResolverEndpointIpAddressRequest.Builder.() -> Unit) = disassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest.Builder().apply(block).build())

    /**
     * Disassociates a VPC from a query logging configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:
     * + The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * + You can stop sharing the configuration.
     */
    suspend fun disassociateResolverQueryLogConfig(input: DisassociateResolverQueryLogConfigRequest): DisassociateResolverQueryLogConfigResponse

    /**
     * Disassociates a VPC from a query logging configuration.
     *
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:
     * + The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * + You can stop sharing the configuration.
     */
    suspend fun disassociateResolverQueryLogConfig(block: DisassociateResolverQueryLogConfigRequest.Builder.() -> Unit) = disassociateResolverQueryLogConfig(DisassociateResolverQueryLogConfigRequest.Builder().apply(block).build())

    /**
     * Removes the association between a specified Resolver rule and a specified VPC.
     *
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule.
     */
    suspend fun disassociateResolverRule(input: DisassociateResolverRuleRequest): DisassociateResolverRuleResponse

    /**
     * Removes the association between a specified Resolver rule and a specified VPC.
     *
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule.
     */
    suspend fun disassociateResolverRule(block: DisassociateResolverRuleRequest.Builder.() -> Unit) = disassociateResolverRule(DisassociateResolverRuleRequest.Builder().apply(block).build())

    /**
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    suspend fun getFirewallConfig(input: GetFirewallConfigRequest): GetFirewallConfigResponse

    /**
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    suspend fun getFirewallConfig(block: GetFirewallConfigRequest.Builder.() -> Unit) = getFirewallConfig(GetFirewallConfigRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified firewall domain list.
     */
    suspend fun getFirewallDomainList(input: GetFirewallDomainListRequest): GetFirewallDomainListResponse

    /**
     * Retrieves the specified firewall domain list.
     */
    suspend fun getFirewallDomainList(block: GetFirewallDomainListRequest.Builder.() -> Unit) = getFirewallDomainList(GetFirewallDomainListRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified firewall rule group.
     */
    suspend fun getFirewallRuleGroup(input: GetFirewallRuleGroupRequest): GetFirewallRuleGroupResponse

    /**
     * Retrieves the specified firewall rule group.
     */
    suspend fun getFirewallRuleGroup(block: GetFirewallRuleGroupRequest.Builder.() -> Unit) = getFirewallRuleGroup(GetFirewallRuleGroupRequest.Builder().apply(block).build())

    /**
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     */
    suspend fun getFirewallRuleGroupAssociation(input: GetFirewallRuleGroupAssociationRequest): GetFirewallRuleGroupAssociationResponse

    /**
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     */
    suspend fun getFirewallRuleGroupAssociation(block: GetFirewallRuleGroupAssociationRequest.Builder.() -> Unit) = getFirewallRuleGroupAssociation(GetFirewallRuleGroupAssociationRequest.Builder().apply(block).build())

    /**
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    suspend fun getFirewallRuleGroupPolicy(input: GetFirewallRuleGroupPolicyRequest): GetFirewallRuleGroupPolicyResponse

    /**
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    suspend fun getFirewallRuleGroupPolicy(block: GetFirewallRuleGroupPolicyRequest.Builder.() -> Unit) = getFirewallRuleGroupPolicy(GetFirewallRuleGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    suspend fun getResolverConfig(input: GetResolverConfigRequest): GetResolverConfigResponse

    /**
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    suspend fun getResolverConfig(block: GetResolverConfigRequest.Builder.() -> Unit) = getResolverConfig(GetResolverConfigRequest.Builder().apply(block).build())

    /**
     * Gets DNSSEC validation information for a specified resource.
     */
    suspend fun getResolverDnssecConfig(input: GetResolverDnssecConfigRequest): GetResolverDnssecConfigResponse

    /**
     * Gets DNSSEC validation information for a specified resource.
     */
    suspend fun getResolverDnssecConfig(block: GetResolverDnssecConfigRequest.Builder.() -> Unit) = getResolverDnssecConfig(GetResolverDnssecConfigRequest.Builder().apply(block).build())

    /**
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.
     */
    suspend fun getResolverEndpoint(input: GetResolverEndpointRequest): GetResolverEndpointResponse

    /**
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.
     */
    suspend fun getResolverEndpoint(block: GetResolverEndpointRequest.Builder.() -> Unit) = getResolverEndpoint(GetResolverEndpointRequest.Builder().apply(block).build())

    /**
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
     */
    suspend fun getResolverQueryLogConfig(input: GetResolverQueryLogConfigRequest): GetResolverQueryLogConfigResponse

    /**
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
     */
    suspend fun getResolverQueryLogConfig(block: GetResolverQueryLogConfigRequest.Builder.() -> Unit) = getResolverQueryLogConfig(GetResolverQueryLogConfigRequest.Builder().apply(block).build())

    /**
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.
     */
    suspend fun getResolverQueryLogConfigAssociation(input: GetResolverQueryLogConfigAssociationRequest): GetResolverQueryLogConfigAssociationResponse

    /**
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.
     */
    suspend fun getResolverQueryLogConfigAssociation(block: GetResolverQueryLogConfigAssociationRequest.Builder.() -> Unit) = getResolverQueryLogConfigAssociation(GetResolverQueryLogConfigAssociationRequest.Builder().apply(block).build())

    /**
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.
     */
    suspend fun getResolverQueryLogConfigPolicy(input: GetResolverQueryLogConfigPolicyRequest): GetResolverQueryLogConfigPolicyResponse

    /**
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.
     */
    suspend fun getResolverQueryLogConfigPolicy(block: GetResolverQueryLogConfigPolicyRequest.Builder.() -> Unit) = getResolverQueryLogConfigPolicy(GetResolverQueryLogConfigPolicyRequest.Builder().apply(block).build())

    /**
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.
     */
    suspend fun getResolverRule(input: GetResolverRuleRequest): GetResolverRuleResponse

    /**
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.
     */
    suspend fun getResolverRule(block: GetResolverRuleRequest.Builder.() -> Unit) = getResolverRule(GetResolverRuleRequest.Builder().apply(block).build())

    /**
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
     */
    suspend fun getResolverRuleAssociation(input: GetResolverRuleAssociationRequest): GetResolverRuleAssociationResponse

    /**
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using [AssociateResolverRule](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
     */
    suspend fun getResolverRuleAssociation(block: GetResolverRuleAssociationRequest.Builder.() -> Unit) = getResolverRuleAssociation(GetResolverRuleAssociationRequest.Builder().apply(block).build())

    /**
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.
     */
    suspend fun getResolverRulePolicy(input: GetResolverRulePolicyRequest): GetResolverRulePolicyResponse

    /**
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.
     */
    suspend fun getResolverRulePolicy(block: GetResolverRulePolicyRequest.Builder.() -> Unit) = getResolverRulePolicy(GetResolverRulePolicyRequest.Builder().apply(block).build())

    /**
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     *
     * Each domain specification in your domain list must satisfy the following requirements:
     * + It can optionally start with `*` (asterisk).
     * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
     * + It must be from 1-255 characters in length.
     */
    suspend fun importFirewallDomains(input: ImportFirewallDomainsRequest): ImportFirewallDomainsResponse

    /**
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     *
     * Each domain specification in your domain list must satisfy the following requirements:
     * + It can optionally start with `*` (asterisk).
     * + With the exception of the optional starting asterisk, it must only contain the following characters: `A-Z`, `a-z`, `0-9`, `-` (hyphen).
     * + It must be from 1-255 characters in length.
     */
    suspend fun importFirewallDomains(block: ImportFirewallDomainsRequest.Builder.() -> Unit) = importFirewallDomains(ImportFirewallDomainsRequest.Builder().apply(block).build())

    /**
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.
     *
     * A single call might return only a partial list of the configurations. For information, see `MaxResults`.
     */
    suspend fun listFirewallConfigs(input: ListFirewallConfigsRequest = ListFirewallConfigsRequest {}): ListFirewallConfigsResponse

    /**
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.
     *
     * A single call might return only a partial list of the configurations. For information, see `MaxResults`.
     */
    suspend fun listFirewallConfigs(block: ListFirewallConfigsRequest.Builder.() -> Unit) = listFirewallConfigs(ListFirewallConfigsRequest.Builder().apply(block).build())

    /**
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling ListFirewallDomains.
     *
     * A single call to this list operation might return only a partial list of the domain lists. For information, see `MaxResults`.
     */
    suspend fun listFirewallDomainLists(input: ListFirewallDomainListsRequest = ListFirewallDomainListsRequest {}): ListFirewallDomainListsResponse

    /**
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling ListFirewallDomains.
     *
     * A single call to this list operation might return only a partial list of the domain lists. For information, see `MaxResults`.
     */
    suspend fun listFirewallDomainLists(block: ListFirewallDomainListsRequest.Builder.() -> Unit) = listFirewallDomainLists(ListFirewallDomainListsRequest.Builder().apply(block).build())

    /**
     * Retrieves the domains that you have defined for the specified firewall domain list.
     *
     * A single call might return only a partial list of the domains. For information, see `MaxResults`.
     */
    suspend fun listFirewallDomains(input: ListFirewallDomainsRequest): ListFirewallDomainsResponse

    /**
     * Retrieves the domains that you have defined for the specified firewall domain list.
     *
     * A single call might return only a partial list of the domains. For information, see `MaxResults`.
     */
    suspend fun listFirewallDomains(block: ListFirewallDomainsRequest.Builder.() -> Unit) = listFirewallDomains(ListFirewallDomainsRequest.Builder().apply(block).build())

    /**
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.
     *
     * A single call might return only a partial list of the associations. For information, see `MaxResults`.
     */
    suspend fun listFirewallRuleGroupAssociations(input: ListFirewallRuleGroupAssociationsRequest = ListFirewallRuleGroupAssociationsRequest {}): ListFirewallRuleGroupAssociationsResponse

    /**
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.
     *
     * A single call might return only a partial list of the associations. For information, see `MaxResults`.
     */
    suspend fun listFirewallRuleGroupAssociations(block: ListFirewallRuleGroupAssociationsRequest.Builder.() -> Unit) = listFirewallRuleGroupAssociations(ListFirewallRuleGroupAssociationsRequest.Builder().apply(block).build())

    /**
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     *
     * A single call might return only a partial list of the rule groups. For information, see `MaxResults`.
     */
    suspend fun listFirewallRuleGroups(input: ListFirewallRuleGroupsRequest = ListFirewallRuleGroupsRequest {}): ListFirewallRuleGroupsResponse

    /**
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     *
     * A single call might return only a partial list of the rule groups. For information, see `MaxResults`.
     */
    suspend fun listFirewallRuleGroups(block: ListFirewallRuleGroupsRequest.Builder.() -> Unit) = listFirewallRuleGroups(ListFirewallRuleGroupsRequest.Builder().apply(block).build())

    /**
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.
     *
     * A single call might return only a partial list of the rules. For information, see `MaxResults`.
     */
    suspend fun listFirewallRules(input: ListFirewallRulesRequest): ListFirewallRulesResponse

    /**
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.
     *
     * A single call might return only a partial list of the rules. For information, see `MaxResults`.
     */
    suspend fun listFirewallRules(block: ListFirewallRulesRequest.Builder.() -> Unit) = listFirewallRules(ListFirewallRulesRequest.Builder().apply(block).build())

    /**
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.
     */
    suspend fun listResolverConfigs(input: ListResolverConfigsRequest = ListResolverConfigsRequest {}): ListResolverConfigsResponse

    /**
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.
     */
    suspend fun listResolverConfigs(block: ListResolverConfigsRequest.Builder.() -> Unit) = listResolverConfigs(ListResolverConfigsRequest.Builder().apply(block).build())

    /**
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     */
    suspend fun listResolverDnssecConfigs(input: ListResolverDnssecConfigsRequest = ListResolverDnssecConfigsRequest {}): ListResolverDnssecConfigsResponse

    /**
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     */
    suspend fun listResolverDnssecConfigs(block: ListResolverDnssecConfigsRequest.Builder.() -> Unit) = listResolverDnssecConfigs(ListResolverDnssecConfigsRequest.Builder().apply(block).build())

    /**
     * Gets the IP addresses for a specified Resolver endpoint.
     */
    suspend fun listResolverEndpointIpAddresses(input: ListResolverEndpointIpAddressesRequest): ListResolverEndpointIpAddressesResponse

    /**
     * Gets the IP addresses for a specified Resolver endpoint.
     */
    suspend fun listResolverEndpointIpAddresses(block: ListResolverEndpointIpAddressesRequest.Builder.() -> Unit) = listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest.Builder().apply(block).build())

    /**
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     */
    suspend fun listResolverEndpoints(input: ListResolverEndpointsRequest = ListResolverEndpointsRequest {}): ListResolverEndpointsResponse

    /**
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     */
    suspend fun listResolverEndpoints(block: ListResolverEndpointsRequest.Builder.() -> Unit) = listResolverEndpoints(ListResolverEndpointsRequest.Builder().apply(block).build())

    /**
     * Lists information about associations between Amazon VPCs and query logging configurations.
     */
    suspend fun listResolverQueryLogConfigAssociations(input: ListResolverQueryLogConfigAssociationsRequest = ListResolverQueryLogConfigAssociationsRequest {}): ListResolverQueryLogConfigAssociationsResponse

    /**
     * Lists information about associations between Amazon VPCs and query logging configurations.
     */
    suspend fun listResolverQueryLogConfigAssociations(block: ListResolverQueryLogConfigAssociationsRequest.Builder.() -> Unit) = listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsRequest.Builder().apply(block).build())

    /**
     * Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     */
    suspend fun listResolverQueryLogConfigs(input: ListResolverQueryLogConfigsRequest = ListResolverQueryLogConfigsRequest {}): ListResolverQueryLogConfigsResponse

    /**
     * Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     */
    suspend fun listResolverQueryLogConfigs(block: ListResolverQueryLogConfigsRequest.Builder.() -> Unit) = listResolverQueryLogConfigs(ListResolverQueryLogConfigsRequest.Builder().apply(block).build())

    /**
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.
     */
    suspend fun listResolverRuleAssociations(input: ListResolverRuleAssociationsRequest = ListResolverRuleAssociationsRequest {}): ListResolverRuleAssociationsResponse

    /**
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.
     */
    suspend fun listResolverRuleAssociations(block: ListResolverRuleAssociationsRequest.Builder.() -> Unit) = listResolverRuleAssociations(ListResolverRuleAssociationsRequest.Builder().apply(block).build())

    /**
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     */
    suspend fun listResolverRules(input: ListResolverRulesRequest = ListResolverRulesRequest {}): ListResolverRulesResponse

    /**
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     */
    suspend fun listResolverRules(block: ListResolverRulesRequest.Builder.() -> Unit) = listResolverRules(ListResolverRulesRequest.Builder().apply(block).build())

    /**
     * Lists the tags that you associated with the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags that you associated with the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    suspend fun putFirewallRuleGroupPolicy(input: PutFirewallRuleGroupPolicyRequest): PutFirewallRuleGroupPolicyResponse

    /**
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM).
     */
    suspend fun putFirewallRuleGroupPolicy(block: PutFirewallRuleGroupPolicyRequest.Builder.() -> Unit) = putFirewallRuleGroupPolicy(PutFirewallRuleGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
     */
    suspend fun putResolverQueryLogConfigPolicy(input: PutResolverQueryLogConfigPolicyRequest): PutResolverQueryLogConfigPolicyResponse

    /**
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
     */
    suspend fun putResolverQueryLogConfigPolicy(block: PutResolverQueryLogConfigPolicyRequest.Builder.() -> Unit) = putResolverQueryLogConfigPolicy(PutResolverQueryLogConfigPolicyRequest.Builder().apply(block).build())

    /**
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.
     */
    suspend fun putResolverRulePolicy(input: PutResolverRulePolicyRequest): PutResolverRulePolicyResponse

    /**
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.
     */
    suspend fun putResolverRulePolicy(block: PutResolverRulePolicyRequest.Builder.() -> Unit) = putResolverRulePolicy(PutResolverRulePolicyRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to a specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds one or more tags to a specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from a specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from a specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    suspend fun updateFirewallConfig(input: UpdateFirewallConfigRequest): UpdateFirewallConfigResponse

    /**
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
     */
    suspend fun updateFirewallConfig(block: UpdateFirewallConfigRequest.Builder.() -> Unit) = updateFirewallConfig(UpdateFirewallConfigRequest.Builder().apply(block).build())

    /**
     * Updates the firewall domain list from an array of domain specifications.
     */
    suspend fun updateFirewallDomains(input: UpdateFirewallDomainsRequest): UpdateFirewallDomainsResponse

    /**
     * Updates the firewall domain list from an array of domain specifications.
     */
    suspend fun updateFirewallDomains(block: UpdateFirewallDomainsRequest.Builder.() -> Unit) = updateFirewallDomains(UpdateFirewallDomainsRequest.Builder().apply(block).build())

    /**
     * Updates the specified firewall rule.
     */
    suspend fun updateFirewallRule(input: UpdateFirewallRuleRequest): UpdateFirewallRuleResponse

    /**
     * Updates the specified firewall rule.
     */
    suspend fun updateFirewallRule(block: UpdateFirewallRuleRequest.Builder.() -> Unit) = updateFirewallRule(UpdateFirewallRuleRequest.Builder().apply(block).build())

    /**
     * Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.
     */
    suspend fun updateFirewallRuleGroupAssociation(input: UpdateFirewallRuleGroupAssociationRequest): UpdateFirewallRuleGroupAssociationResponse

    /**
     * Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.
     */
    suspend fun updateFirewallRuleGroupAssociation(block: UpdateFirewallRuleGroupAssociationRequest.Builder.() -> Unit) = updateFirewallRuleGroupAssociation(UpdateFirewallRuleGroupAssociationRequest.Builder().apply(block).build())

    /**
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    suspend fun updateResolverConfig(input: UpdateResolverConfigRequest): UpdateResolverConfigResponse

    /**
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.
     */
    suspend fun updateResolverConfig(block: UpdateResolverConfigRequest.Builder.() -> Unit) = updateResolverConfig(UpdateResolverConfigRequest.Builder().apply(block).build())

    /**
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.
     */
    suspend fun updateResolverDnssecConfig(input: UpdateResolverDnssecConfigRequest): UpdateResolverDnssecConfigResponse

    /**
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.
     */
    suspend fun updateResolverDnssecConfig(block: UpdateResolverDnssecConfigRequest.Builder.() -> Unit) = updateResolverDnssecConfig(UpdateResolverDnssecConfigRequest.Builder().apply(block).build())

    /**
     * Updates the name of an inbound or an outbound Resolver endpoint.
     */
    suspend fun updateResolverEndpoint(input: UpdateResolverEndpointRequest): UpdateResolverEndpointResponse

    /**
     * Updates the name of an inbound or an outbound Resolver endpoint.
     */
    suspend fun updateResolverEndpoint(block: UpdateResolverEndpointRequest.Builder.() -> Unit) = updateResolverEndpoint(UpdateResolverEndpointRequest.Builder().apply(block).build())

    /**
     * Updates settings for a specified Resolver rule. `ResolverRuleId` is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.
     */
    suspend fun updateResolverRule(input: UpdateResolverRuleRequest): UpdateResolverRuleResponse

    /**
     * Updates settings for a specified Resolver rule. `ResolverRuleId` is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.
     */
    suspend fun updateResolverRule(block: UpdateResolverRuleRequest.Builder.() -> Unit) = updateResolverRule(UpdateResolverRuleRequest.Builder().apply(block).build())
}
