// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness.serde

import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.Message
import aws.sdk.kotlin.services.route53recoveryreadiness.model.Readiness
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ResourceResult
import aws.sdk.kotlin.services.route53recoveryreadiness.model.Route53RecoveryReadinessException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetReadinessCheckStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetReadinessCheckStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetReadinessCheckStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetReadinessCheckStatusError(context, call, payload)
        }
        val builder = GetReadinessCheckStatusResponse.Builder()

        if (payload != null) {
            deserializeGetReadinessCheckStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetReadinessCheckStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Route53RecoveryReadinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> Route53RecoveryReadinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReadinessCheckStatusOperationBody(builder: GetReadinessCheckStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("messages"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val READINESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("readiness"))
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("resources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(READINESS_DESCRIPTOR)
        field(RESOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGES_DESCRIPTOR.index -> builder.messages =
                    deserializer.deserializeList(MESSAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<Message>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMessageDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                READINESS_DESCRIPTOR.index -> builder.readiness = deserializeString().let { Readiness.fromValue(it) }
                RESOURCES_DESCRIPTOR.index -> builder.resources =
                    deserializer.deserializeList(RESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
