// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness.paginators

import aws.sdk.kotlin.services.route53recoveryreadiness.Route53RecoveryReadinessClient
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CellOutput
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCellsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCellsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListReadinessChecksRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListReadinessChecksResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListResourceSetsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListResourceSetsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesOutput
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ReadinessCheckOutput
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ReadinessCheckSummary
import aws.sdk.kotlin.services.route53recoveryreadiness.model.RecoveryGroupOutput
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ResourceResult
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ResourceSetOutput
import aws.sdk.kotlin.services.route53recoveryreadiness.model.RuleResult
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetCellReadinessSummaryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCellReadinessSummaryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCellReadinessSummaryResponse]
 */
public fun Route53RecoveryReadinessClient.getCellReadinessSummaryPaginated(initialRequest: GetCellReadinessSummaryRequest): Flow<GetCellReadinessSummaryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCellReadinessSummaryPaginated.getCellReadinessSummary(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCellReadinessSummaryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCellReadinessSummaryResponse]
 */
public fun Route53RecoveryReadinessClient.getCellReadinessSummaryPaginated(block: GetCellReadinessSummaryRequest.Builder.() -> Unit): Flow<GetCellReadinessSummaryResponse> =
    getCellReadinessSummaryPaginated(GetCellReadinessSummaryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getCellReadinessSummaryPaginated]
 * to access the nested member [ReadinessCheckSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReadinessCheckSummary]
 */
@JvmName("getCellReadinessSummaryResponseReadinessCheckSummary")
public fun Flow<GetCellReadinessSummaryResponse>.readinessChecks(): Flow<ReadinessCheckSummary> =
    transform() { response ->
        response.readinessChecks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetReadinessCheckResourceStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetReadinessCheckResourceStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReadinessCheckResourceStatusResponse]
 */
public fun Route53RecoveryReadinessClient.getReadinessCheckResourceStatusPaginated(initialRequest: GetReadinessCheckResourceStatusRequest): Flow<GetReadinessCheckResourceStatusResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getReadinessCheckResourceStatusPaginated.getReadinessCheckResourceStatus(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetReadinessCheckResourceStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReadinessCheckResourceStatusResponse]
 */
public fun Route53RecoveryReadinessClient.getReadinessCheckResourceStatusPaginated(block: GetReadinessCheckResourceStatusRequest.Builder.() -> Unit): Flow<GetReadinessCheckResourceStatusResponse> =
    getReadinessCheckResourceStatusPaginated(GetReadinessCheckResourceStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getReadinessCheckResourceStatusPaginated]
 * to access the nested member [RuleResult]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleResult]
 */
@JvmName("getReadinessCheckResourceStatusResponseRuleResult")
public fun Flow<GetReadinessCheckResourceStatusResponse>.rules(): Flow<RuleResult> =
    transform() { response ->
        response.rules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetReadinessCheckStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetReadinessCheckStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReadinessCheckStatusResponse]
 */
public fun Route53RecoveryReadinessClient.getReadinessCheckStatusPaginated(initialRequest: GetReadinessCheckStatusRequest): Flow<GetReadinessCheckStatusResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getReadinessCheckStatusPaginated.getReadinessCheckStatus(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetReadinessCheckStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReadinessCheckStatusResponse]
 */
public fun Route53RecoveryReadinessClient.getReadinessCheckStatusPaginated(block: GetReadinessCheckStatusRequest.Builder.() -> Unit): Flow<GetReadinessCheckStatusResponse> =
    getReadinessCheckStatusPaginated(GetReadinessCheckStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getReadinessCheckStatusPaginated]
 * to access the nested member [ResourceResult]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceResult]
 */
@JvmName("getReadinessCheckStatusResponseResourceResult")
public fun Flow<GetReadinessCheckStatusResponse>.resources(): Flow<ResourceResult> =
    transform() { response ->
        response.resources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetRecoveryGroupReadinessSummaryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetRecoveryGroupReadinessSummaryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRecoveryGroupReadinessSummaryResponse]
 */
public fun Route53RecoveryReadinessClient.getRecoveryGroupReadinessSummaryPaginated(initialRequest: GetRecoveryGroupReadinessSummaryRequest): Flow<GetRecoveryGroupReadinessSummaryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getRecoveryGroupReadinessSummaryPaginated.getRecoveryGroupReadinessSummary(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetRecoveryGroupReadinessSummaryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRecoveryGroupReadinessSummaryResponse]
 */
public fun Route53RecoveryReadinessClient.getRecoveryGroupReadinessSummaryPaginated(block: GetRecoveryGroupReadinessSummaryRequest.Builder.() -> Unit): Flow<GetRecoveryGroupReadinessSummaryResponse> =
    getRecoveryGroupReadinessSummaryPaginated(GetRecoveryGroupReadinessSummaryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getRecoveryGroupReadinessSummaryPaginated]
 * to access the nested member [ReadinessCheckSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReadinessCheckSummary]
 */
@JvmName("getRecoveryGroupReadinessSummaryResponseReadinessCheckSummary")
public fun Flow<GetRecoveryGroupReadinessSummaryResponse>.readinessChecks(): Flow<ReadinessCheckSummary> =
    transform() { response ->
        response.readinessChecks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCellsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCellsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCellsResponse]
 */
public fun Route53RecoveryReadinessClient.listCellsPaginated(initialRequest: ListCellsRequest = ListCellsRequest { }): Flow<ListCellsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCellsPaginated.listCells(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCellsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCellsResponse]
 */
public fun Route53RecoveryReadinessClient.listCellsPaginated(block: ListCellsRequest.Builder.() -> Unit): Flow<ListCellsResponse> =
    listCellsPaginated(ListCellsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCellsPaginated]
 * to access the nested member [CellOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CellOutput]
 */
@JvmName("listCellsResponseCellOutput")
public fun Flow<ListCellsResponse>.cells(): Flow<CellOutput> =
    transform() { response ->
        response.cells?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCrossAccountAuthorizationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCrossAccountAuthorizationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCrossAccountAuthorizationsResponse]
 */
public fun Route53RecoveryReadinessClient.listCrossAccountAuthorizationsPaginated(initialRequest: ListCrossAccountAuthorizationsRequest = ListCrossAccountAuthorizationsRequest { }): Flow<ListCrossAccountAuthorizationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCrossAccountAuthorizationsPaginated.listCrossAccountAuthorizations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCrossAccountAuthorizationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCrossAccountAuthorizationsResponse]
 */
public fun Route53RecoveryReadinessClient.listCrossAccountAuthorizationsPaginated(block: ListCrossAccountAuthorizationsRequest.Builder.() -> Unit): Flow<ListCrossAccountAuthorizationsResponse> =
    listCrossAccountAuthorizationsPaginated(ListCrossAccountAuthorizationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCrossAccountAuthorizationsPaginated]
 * to access the nested member [CrossAccountAuthorization]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CrossAccountAuthorization]
 */
@JvmName("listCrossAccountAuthorizationsResponseCrossAccountAuthorization")
public fun Flow<ListCrossAccountAuthorizationsResponse>.crossAccountAuthorizations(): Flow<String> =
    transform() { response ->
        response.crossAccountAuthorizations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReadinessChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReadinessChecksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReadinessChecksResponse]
 */
public fun Route53RecoveryReadinessClient.listReadinessChecksPaginated(initialRequest: ListReadinessChecksRequest = ListReadinessChecksRequest { }): Flow<ListReadinessChecksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReadinessChecksPaginated.listReadinessChecks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReadinessChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReadinessChecksResponse]
 */
public fun Route53RecoveryReadinessClient.listReadinessChecksPaginated(block: ListReadinessChecksRequest.Builder.() -> Unit): Flow<ListReadinessChecksResponse> =
    listReadinessChecksPaginated(ListReadinessChecksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReadinessChecksPaginated]
 * to access the nested member [ReadinessCheckOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReadinessCheckOutput]
 */
@JvmName("listReadinessChecksResponseReadinessCheckOutput")
public fun Flow<ListReadinessChecksResponse>.readinessChecks(): Flow<ReadinessCheckOutput> =
    transform() { response ->
        response.readinessChecks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecoveryGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecoveryGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryGroupsResponse]
 */
public fun Route53RecoveryReadinessClient.listRecoveryGroupsPaginated(initialRequest: ListRecoveryGroupsRequest = ListRecoveryGroupsRequest { }): Flow<ListRecoveryGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecoveryGroupsPaginated.listRecoveryGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRecoveryGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryGroupsResponse]
 */
public fun Route53RecoveryReadinessClient.listRecoveryGroupsPaginated(block: ListRecoveryGroupsRequest.Builder.() -> Unit): Flow<ListRecoveryGroupsResponse> =
    listRecoveryGroupsPaginated(ListRecoveryGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecoveryGroupsPaginated]
 * to access the nested member [RecoveryGroupOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecoveryGroupOutput]
 */
@JvmName("listRecoveryGroupsResponseRecoveryGroupOutput")
public fun Flow<ListRecoveryGroupsResponse>.recoveryGroups(): Flow<RecoveryGroupOutput> =
    transform() { response ->
        response.recoveryGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceSetsResponse]
 */
public fun Route53RecoveryReadinessClient.listResourceSetsPaginated(initialRequest: ListResourceSetsRequest = ListResourceSetsRequest { }): Flow<ListResourceSetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceSetsPaginated.listResourceSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceSetsResponse]
 */
public fun Route53RecoveryReadinessClient.listResourceSetsPaginated(block: ListResourceSetsRequest.Builder.() -> Unit): Flow<ListResourceSetsResponse> =
    listResourceSetsPaginated(ListResourceSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceSetsPaginated]
 * to access the nested member [ResourceSetOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceSetOutput]
 */
@JvmName("listResourceSetsResponseResourceSetOutput")
public fun Flow<ListResourceSetsResponse>.resourceSets(): Flow<ResourceSetOutput> =
    transform() { response ->
        response.resourceSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun Route53RecoveryReadinessClient.listRulesPaginated(initialRequest: ListRulesRequest = ListRulesRequest { }): Flow<ListRulesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRulesPaginated.listRules(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun Route53RecoveryReadinessClient.listRulesPaginated(block: ListRulesRequest.Builder.() -> Unit): Flow<ListRulesResponse> =
    listRulesPaginated(ListRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRulesPaginated]
 * to access the nested member [ListRulesOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesOutput]
 */
@JvmName("listRulesResponseListRulesOutput")
public fun Flow<ListRulesResponse>.rules(): Flow<ListRulesOutput> =
    transform() { response ->
        response.rules?.forEach {
            emit(it)
        }
    }
