// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.route53recoveryreadiness.auth.DefaultRoute53RecoveryReadinessAuthSchemeProvider
import aws.sdk.kotlin.services.route53recoveryreadiness.auth.Route53RecoveryReadinessAuthSchemeProvider
import aws.sdk.kotlin.services.route53recoveryreadiness.endpoints.DefaultRoute53RecoveryReadinessEndpointProvider
import aws.sdk.kotlin.services.route53recoveryreadiness.endpoints.Route53RecoveryReadinessEndpointParameters
import aws.sdk.kotlin.services.route53recoveryreadiness.endpoints.Route53RecoveryReadinessEndpointProvider
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateResourceSetResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteResourceSetResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetArchitectureRecommendationsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetArchitectureRecommendationsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetResourceSetResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCellsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCellsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListReadinessChecksRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListReadinessChecksResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListResourceSetsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListResourceSetsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListTagsForResourcesRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListTagsForResourcesResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.TagResourceRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.TagResourceResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UntagResourceRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UntagResourceResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateResourceSetResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Route53 Recovery Readiness"
public const val SdkVersion: String = "1.5.35"
public const val ServiceApiVersion: String = "2019-12-02"

/**
 * Recovery readiness
 */
public interface Route53RecoveryReadinessClient : SdkClient {
    /**
     * Route53RecoveryReadinessClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Route53RecoveryReadinessClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Route53RecoveryReadiness",
                "ROUTE53_RECOVERY_READINESS",
                "route53_recovery_readiness",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Route53RecoveryReadinessClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Route53RecoveryReadinessClient = DefaultRoute53RecoveryReadinessClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: Route53RecoveryReadinessEndpointProvider = builder.endpointProvider ?: DefaultRoute53RecoveryReadinessEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: Route53RecoveryReadinessAuthSchemeProvider = builder.authSchemeProvider ?: DefaultRoute53RecoveryReadinessAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Route53 Recovery Readiness"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: Route53RecoveryReadinessEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: Route53RecoveryReadinessAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a cell in an account.
     */
    public suspend fun createCell(input: CreateCellRequest): CreateCellResponse

    /**
     * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
     */
    public suspend fun createCrossAccountAuthorization(input: CreateCrossAccountAuthorizationRequest): CreateCrossAccountAuthorizationResponse

    /**
     * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.
     */
    public suspend fun createReadinessCheck(input: CreateReadinessCheckRequest): CreateReadinessCheckResponse

    /**
     * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.
     */
    public suspend fun createRecoveryGroup(input: CreateRecoveryGroupRequest): CreateRecoveryGroupResponse

    /**
     * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.
     */
    public suspend fun createResourceSet(input: CreateResourceSetRequest): CreateResourceSetResponse

    /**
     * Delete a cell. When successful, the response code is 204, with no response body.
     */
    public suspend fun deleteCell(input: DeleteCellRequest): DeleteCellResponse

    /**
     * Deletes cross account readiness authorization.
     */
    public suspend fun deleteCrossAccountAuthorization(input: DeleteCrossAccountAuthorizationRequest): DeleteCrossAccountAuthorizationResponse

    /**
     * Deletes a readiness check.
     */
    public suspend fun deleteReadinessCheck(input: DeleteReadinessCheckRequest): DeleteReadinessCheckResponse

    /**
     * Deletes a recovery group.
     */
    public suspend fun deleteRecoveryGroup(input: DeleteRecoveryGroupRequest): DeleteRecoveryGroupResponse

    /**
     * Deletes a resource set.
     */
    public suspend fun deleteResourceSet(input: DeleteResourceSetRequest): DeleteResourceSetResponse

    /**
     * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.
     */
    public suspend fun getArchitectureRecommendations(input: GetArchitectureRecommendationsRequest): GetArchitectureRecommendationsResponse

    /**
     * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.
     */
    public suspend fun getCell(input: GetCellRequest): GetCellResponse

    /**
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.
     */
    public suspend fun getCellReadinessSummary(input: GetCellReadinessSummaryRequest): GetCellReadinessSummaryResponse

    /**
     * Gets details about a readiness check.
     */
    public suspend fun getReadinessCheck(input: GetReadinessCheckRequest): GetReadinessCheckResponse

    /**
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
     */
    public suspend fun getReadinessCheckResourceStatus(input: GetReadinessCheckResourceStatusRequest): GetReadinessCheckResourceStatusResponse

    /**
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
     */
    public suspend fun getReadinessCheckStatus(input: GetReadinessCheckStatusRequest): GetReadinessCheckStatusResponse

    /**
     * Gets details about a recovery group, including a list of the cells that are included in it.
     */
    public suspend fun getRecoveryGroup(input: GetRecoveryGroupRequest): GetRecoveryGroupResponse

    /**
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.
     */
    public suspend fun getRecoveryGroupReadinessSummary(input: GetRecoveryGroupReadinessSummaryRequest): GetRecoveryGroupReadinessSummaryResponse

    /**
     * Displays the details about a resource set, including a list of the resources in the set.
     */
    public suspend fun getResourceSet(input: GetResourceSetRequest): GetResourceSetResponse

    /**
     * Lists the cells for an account.
     */
    public suspend fun listCells(input: ListCellsRequest = ListCellsRequest { }): ListCellsResponse

    /**
     * Lists the cross-account readiness authorizations that are in place for an account.
     */
    public suspend fun listCrossAccountAuthorizations(input: ListCrossAccountAuthorizationsRequest = ListCrossAccountAuthorizationsRequest { }): ListCrossAccountAuthorizationsResponse

    /**
     * Lists the readiness checks for an account.
     */
    public suspend fun listReadinessChecks(input: ListReadinessChecksRequest = ListReadinessChecksRequest { }): ListReadinessChecksResponse

    /**
     * Lists the recovery groups in an account.
     */
    public suspend fun listRecoveryGroups(input: ListRecoveryGroupsRequest = ListRecoveryGroupsRequest { }): ListRecoveryGroupsResponse

    /**
     * Lists the resource sets in an account.
     */
    public suspend fun listResourceSets(input: ListResourceSetsRequest = ListResourceSetsRequest { }): ListResourceSetsResponse

    /**
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     */
    public suspend fun listRules(input: ListRulesRequest = ListRulesRequest { }): ListRulesResponse

    /**
     * Lists the tags for a resource.
     */
    public suspend fun listTagsForResources(input: ListTagsForResourcesRequest): ListTagsForResourcesResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a cell to replace the list of nested cells with a new list of nested cells.
     */
    public suspend fun updateCell(input: UpdateCellRequest): UpdateCellResponse

    /**
     * Updates a readiness check.
     */
    public suspend fun updateReadinessCheck(input: UpdateReadinessCheckRequest): UpdateReadinessCheckResponse

    /**
     * Updates a recovery group.
     */
    public suspend fun updateRecoveryGroup(input: UpdateRecoveryGroupRequest): UpdateRecoveryGroupResponse

    /**
     * Updates a resource set.
     */
    public suspend fun updateResourceSet(input: UpdateResourceSetRequest): UpdateResourceSetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Route53RecoveryReadinessClient.withConfig(block: Route53RecoveryReadinessClient.Config.Builder.() -> Unit): Route53RecoveryReadinessClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRoute53RecoveryReadinessClient(newConfig)
}

/**
 * Creates a cell in an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.createCell(crossinline block: CreateCellRequest.Builder.() -> Unit): CreateCellResponse = createCell(CreateCellRequest.Builder().apply(block).build())

/**
 * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
 */
public suspend inline fun Route53RecoveryReadinessClient.createCrossAccountAuthorization(crossinline block: CreateCrossAccountAuthorizationRequest.Builder.() -> Unit): CreateCrossAccountAuthorizationResponse = createCrossAccountAuthorization(CreateCrossAccountAuthorizationRequest.Builder().apply(block).build())

/**
 * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.createReadinessCheck(crossinline block: CreateReadinessCheckRequest.Builder.() -> Unit): CreateReadinessCheckResponse = createReadinessCheck(CreateReadinessCheckRequest.Builder().apply(block).build())

/**
 * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.
 */
public suspend inline fun Route53RecoveryReadinessClient.createRecoveryGroup(crossinline block: CreateRecoveryGroupRequest.Builder.() -> Unit): CreateRecoveryGroupResponse = createRecoveryGroup(CreateRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.
 */
public suspend inline fun Route53RecoveryReadinessClient.createResourceSet(crossinline block: CreateResourceSetRequest.Builder.() -> Unit): CreateResourceSetResponse = createResourceSet(CreateResourceSetRequest.Builder().apply(block).build())

/**
 * Delete a cell. When successful, the response code is 204, with no response body.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteCell(crossinline block: DeleteCellRequest.Builder.() -> Unit): DeleteCellResponse = deleteCell(DeleteCellRequest.Builder().apply(block).build())

/**
 * Deletes cross account readiness authorization.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteCrossAccountAuthorization(crossinline block: DeleteCrossAccountAuthorizationRequest.Builder.() -> Unit): DeleteCrossAccountAuthorizationResponse = deleteCrossAccountAuthorization(DeleteCrossAccountAuthorizationRequest.Builder().apply(block).build())

/**
 * Deletes a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteReadinessCheck(crossinline block: DeleteReadinessCheckRequest.Builder.() -> Unit): DeleteReadinessCheckResponse = deleteReadinessCheck(DeleteReadinessCheckRequest.Builder().apply(block).build())

/**
 * Deletes a recovery group.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteRecoveryGroup(crossinline block: DeleteRecoveryGroupRequest.Builder.() -> Unit): DeleteRecoveryGroupResponse = deleteRecoveryGroup(DeleteRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Deletes a resource set.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteResourceSet(crossinline block: DeleteResourceSetRequest.Builder.() -> Unit): DeleteResourceSetResponse = deleteResourceSet(DeleteResourceSetRequest.Builder().apply(block).build())

/**
 * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.
 */
public suspend inline fun Route53RecoveryReadinessClient.getArchitectureRecommendations(crossinline block: GetArchitectureRecommendationsRequest.Builder.() -> Unit): GetArchitectureRecommendationsResponse = getArchitectureRecommendations(GetArchitectureRecommendationsRequest.Builder().apply(block).build())

/**
 * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.
 */
public suspend inline fun Route53RecoveryReadinessClient.getCell(crossinline block: GetCellRequest.Builder.() -> Unit): GetCellResponse = getCell(GetCellRequest.Builder().apply(block).build())

/**
 * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.
 */
public suspend inline fun Route53RecoveryReadinessClient.getCellReadinessSummary(crossinline block: GetCellReadinessSummaryRequest.Builder.() -> Unit): GetCellReadinessSummaryResponse = getCellReadinessSummary(GetCellReadinessSummaryRequest.Builder().apply(block).build())

/**
 * Gets details about a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.getReadinessCheck(crossinline block: GetReadinessCheckRequest.Builder.() -> Unit): GetReadinessCheckResponse = getReadinessCheck(GetReadinessCheckRequest.Builder().apply(block).build())

/**
 * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
 */
public suspend inline fun Route53RecoveryReadinessClient.getReadinessCheckResourceStatus(crossinline block: GetReadinessCheckResourceStatusRequest.Builder.() -> Unit): GetReadinessCheckResourceStatusResponse = getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusRequest.Builder().apply(block).build())

/**
 * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
 */
public suspend inline fun Route53RecoveryReadinessClient.getReadinessCheckStatus(crossinline block: GetReadinessCheckStatusRequest.Builder.() -> Unit): GetReadinessCheckStatusResponse = getReadinessCheckStatus(GetReadinessCheckStatusRequest.Builder().apply(block).build())

/**
 * Gets details about a recovery group, including a list of the cells that are included in it.
 */
public suspend inline fun Route53RecoveryReadinessClient.getRecoveryGroup(crossinline block: GetRecoveryGroupRequest.Builder.() -> Unit): GetRecoveryGroupResponse = getRecoveryGroup(GetRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.
 */
public suspend inline fun Route53RecoveryReadinessClient.getRecoveryGroupReadinessSummary(crossinline block: GetRecoveryGroupReadinessSummaryRequest.Builder.() -> Unit): GetRecoveryGroupReadinessSummaryResponse = getRecoveryGroupReadinessSummary(GetRecoveryGroupReadinessSummaryRequest.Builder().apply(block).build())

/**
 * Displays the details about a resource set, including a list of the resources in the set.
 */
public suspend inline fun Route53RecoveryReadinessClient.getResourceSet(crossinline block: GetResourceSetRequest.Builder.() -> Unit): GetResourceSetResponse = getResourceSet(GetResourceSetRequest.Builder().apply(block).build())

/**
 * Lists the cells for an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listCells(crossinline block: ListCellsRequest.Builder.() -> Unit): ListCellsResponse = listCells(ListCellsRequest.Builder().apply(block).build())

/**
 * Lists the cross-account readiness authorizations that are in place for an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listCrossAccountAuthorizations(crossinline block: ListCrossAccountAuthorizationsRequest.Builder.() -> Unit): ListCrossAccountAuthorizationsResponse = listCrossAccountAuthorizations(ListCrossAccountAuthorizationsRequest.Builder().apply(block).build())

/**
 * Lists the readiness checks for an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listReadinessChecks(crossinline block: ListReadinessChecksRequest.Builder.() -> Unit): ListReadinessChecksResponse = listReadinessChecks(ListReadinessChecksRequest.Builder().apply(block).build())

/**
 * Lists the recovery groups in an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listRecoveryGroups(crossinline block: ListRecoveryGroupsRequest.Builder.() -> Unit): ListRecoveryGroupsResponse = listRecoveryGroups(ListRecoveryGroupsRequest.Builder().apply(block).build())

/**
 * Lists the resource sets in an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listResourceSets(crossinline block: ListResourceSetsRequest.Builder.() -> Unit): ListResourceSetsResponse = listResourceSets(ListResourceSetsRequest.Builder().apply(block).build())

/**
 * Lists all readiness rules, or lists the readiness rules for a specific resource type.
 */
public suspend inline fun Route53RecoveryReadinessClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * Lists the tags for a resource.
 */
public suspend inline fun Route53RecoveryReadinessClient.listTagsForResources(crossinline block: ListTagsForResourcesRequest.Builder.() -> Unit): ListTagsForResourcesResponse = listTagsForResources(ListTagsForResourcesRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun Route53RecoveryReadinessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun Route53RecoveryReadinessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a cell to replace the list of nested cells with a new list of nested cells.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateCell(crossinline block: UpdateCellRequest.Builder.() -> Unit): UpdateCellResponse = updateCell(UpdateCellRequest.Builder().apply(block).build())

/**
 * Updates a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateReadinessCheck(crossinline block: UpdateReadinessCheckRequest.Builder.() -> Unit): UpdateReadinessCheckResponse = updateReadinessCheck(UpdateReadinessCheckRequest.Builder().apply(block).build())

/**
 * Updates a recovery group.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateRecoveryGroup(crossinline block: UpdateRecoveryGroupRequest.Builder.() -> Unit): UpdateRecoveryGroupResponse = updateRecoveryGroup(UpdateRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Updates a resource set.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateResourceSet(crossinline block: UpdateResourceSetRequest.Builder.() -> Unit): UpdateResourceSetResponse = updateResourceSet(UpdateResourceSetRequest.Builder().apply(block).build())
