// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A component for DNS/routing control readiness checks and architecture checks.
 */
public class DnsTargetResource private constructor(builder: Builder) {
    /**
     * The domain name that acts as an ingress point to a portion of the customer application.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
     */
    public val hostedZoneArn: kotlin.String? = builder.hostedZoneArn
    /**
     * The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
     */
    public val recordSetId: kotlin.String? = builder.recordSetId
    /**
     * The type of DNS record of the target resource.
     */
    public val recordType: kotlin.String? = builder.recordType
    /**
     * The target resource of the DNS target resource.
     */
    public val targetResource: aws.sdk.kotlin.services.route53recoveryreadiness.model.TargetResource? = builder.targetResource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoveryreadiness.model.DnsTargetResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DnsTargetResource(")
        append("domainName=$domainName,")
        append("hostedZoneArn=$hostedZoneArn,")
        append("recordSetId=$recordSetId,")
        append("recordType=$recordType,")
        append("targetResource=$targetResource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (hostedZoneArn?.hashCode() ?: 0)
        result = 31 * result + (recordSetId?.hashCode() ?: 0)
        result = 31 * result + (recordType?.hashCode() ?: 0)
        result = 31 * result + (targetResource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DnsTargetResource

        if (domainName != other.domainName) return false
        if (hostedZoneArn != other.hostedZoneArn) return false
        if (recordSetId != other.recordSetId) return false
        if (recordType != other.recordType) return false
        if (targetResource != other.targetResource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoveryreadiness.model.DnsTargetResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The domain name that acts as an ingress point to a portion of the customer application.
         */
        public var domainName: kotlin.String? = null
        /**
         * The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
         */
        public var hostedZoneArn: kotlin.String? = null
        /**
         * The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
         */
        public var recordSetId: kotlin.String? = null
        /**
         * The type of DNS record of the target resource.
         */
        public var recordType: kotlin.String? = null
        /**
         * The target resource of the DNS target resource.
         */
        public var targetResource: aws.sdk.kotlin.services.route53recoveryreadiness.model.TargetResource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoveryreadiness.model.DnsTargetResource) : this() {
            this.domainName = x.domainName
            this.hostedZoneArn = x.hostedZoneArn
            this.recordSetId = x.recordSetId
            this.recordType = x.recordType
            this.targetResource = x.targetResource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoveryreadiness.model.DnsTargetResource = DnsTargetResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53recoveryreadiness.model.TargetResource] inside the given [block]
         */
        public fun targetResource(block: aws.sdk.kotlin.services.route53recoveryreadiness.model.TargetResource.Builder.() -> kotlin.Unit) {
            this.targetResource = aws.sdk.kotlin.services.route53recoveryreadiness.model.TargetResource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
