// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness.transform

import aws.sdk.kotlin.services.route53recoveryreadiness.model.Resource
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateResourceSetRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateResourceSetOperationSerializer: HttpSerialize<UpdateResourceSetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateResourceSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "resourcesets",
                "${input.resourceSetName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateResourceSetOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateResourceSetOperationBody(context: ExecutionContext, input: UpdateResourceSetRequest): ByteArray {
    val serializer = JsonSerializer()
    val RESOURCESETTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceSetType"))
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("resources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCESETTYPE_DESCRIPTOR)
        field(RESOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.resourceSetType?.let { field(RESOURCESETTYPE_DESCRIPTOR, it) }
        if (input.resources != null) {
            listField(RESOURCES_DESCRIPTOR) {
                for (el0 in input.resources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourceDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
