// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53recoveryreadiness.model.Route53RecoveryReadinessException
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateCellResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateCellOperationDeserializer: HttpDeserialize<UpdateCellResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateCellResponse {
        if (!response.status.isSuccess()) {
            throwUpdateCellError(context, response)
        }
        val builder = UpdateCellResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateCellOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateCellError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53RecoveryReadinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Route53RecoveryReadinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateCellOperationBody(builder: UpdateCellResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CELLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cellArn"))
    val CELLNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cellName"))
    val CELLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cells"))
    val PARENTREADINESSSCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parentReadinessScopes"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CELLARN_DESCRIPTOR)
        field(CELLNAME_DESCRIPTOR)
        field(CELLS_DESCRIPTOR)
        field(PARENTREADINESSSCOPES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CELLARN_DESCRIPTOR.index -> builder.cellArn = deserializeString()
                CELLNAME_DESCRIPTOR.index -> builder.cellName = deserializeString()
                CELLS_DESCRIPTOR.index -> builder.cells =
                    deserializer.deserializeList(CELLS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARENTREADINESSSCOPES_DESCRIPTOR.index -> builder.parentReadinessScopes =
                    deserializer.deserializeList(PARENTREADINESSSCOPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
