// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.route53recoveryreadiness.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.route53recoveryreadiness.model.*
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.CreateResourceSetResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.DeleteResourceSetResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetArchitectureRecommendationsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetArchitectureRecommendationsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.GetResourceSetResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCellsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCellsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListReadinessChecksRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListReadinessChecksResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListResourceSetsRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListResourceSetsResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListRulesResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListTagsForResourcesRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.ListTagsForResourcesResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.TagResourceRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.TagResourceResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UntagResourceRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UntagResourceResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateCellRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateCellResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateReadinessCheckRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateReadinessCheckResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateRecoveryGroupRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateRecoveryGroupResponse
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateResourceSetRequest
import aws.sdk.kotlin.services.route53recoveryreadiness.model.UpdateResourceSetResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Recovery readiness
 */
public interface Route53RecoveryReadinessClient : SdkClient {

    override val serviceName: String
        get() = "Route53 Recovery Readiness"
    /**
     * Route53RecoveryReadinessClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Route53RecoveryReadinessClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRoute53RecoveryReadinessClient(config)
        }

        public operator fun invoke(config: Config): Route53RecoveryReadinessClient = DefaultRoute53RecoveryReadinessClient(config)

        /**
         * Construct a [Route53RecoveryReadinessClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Route53RecoveryReadinessClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRoute53RecoveryReadinessClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a cell in an account.
     */
    public suspend fun createCell(input: CreateCellRequest): CreateCellResponse

    /**
     * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
     */
    public suspend fun createCrossAccountAuthorization(input: CreateCrossAccountAuthorizationRequest): CreateCrossAccountAuthorizationResponse

    /**
     * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.
     */
    public suspend fun createReadinessCheck(input: CreateReadinessCheckRequest): CreateReadinessCheckResponse

    /**
     * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.
     */
    public suspend fun createRecoveryGroup(input: CreateRecoveryGroupRequest): CreateRecoveryGroupResponse

    /**
     * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.
     */
    public suspend fun createResourceSet(input: CreateResourceSetRequest): CreateResourceSetResponse

    /**
     * Delete a cell. When successful, the response code is 204, with no response body.
     */
    public suspend fun deleteCell(input: DeleteCellRequest): DeleteCellResponse

    /**
     * Deletes cross account readiness authorization.
     */
    public suspend fun deleteCrossAccountAuthorization(input: DeleteCrossAccountAuthorizationRequest): DeleteCrossAccountAuthorizationResponse

    /**
     * Deletes a readiness check.
     */
    public suspend fun deleteReadinessCheck(input: DeleteReadinessCheckRequest): DeleteReadinessCheckResponse

    /**
     * Deletes a recovery group.
     */
    public suspend fun deleteRecoveryGroup(input: DeleteRecoveryGroupRequest): DeleteRecoveryGroupResponse

    /**
     * Deletes a resource set.
     */
    public suspend fun deleteResourceSet(input: DeleteResourceSetRequest): DeleteResourceSetResponse

    /**
     * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.
     */
    public suspend fun getArchitectureRecommendations(input: GetArchitectureRecommendationsRequest): GetArchitectureRecommendationsResponse

    /**
     * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.
     */
    public suspend fun getCell(input: GetCellRequest): GetCellResponse

    /**
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.
     */
    public suspend fun getCellReadinessSummary(input: GetCellReadinessSummaryRequest): GetCellReadinessSummaryResponse

    /**
     * Gets details about a readiness check.
     */
    public suspend fun getReadinessCheck(input: GetReadinessCheckRequest): GetReadinessCheckResponse

    /**
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
     */
    public suspend fun getReadinessCheckResourceStatus(input: GetReadinessCheckResourceStatusRequest): GetReadinessCheckResourceStatusResponse

    /**
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
     */
    public suspend fun getReadinessCheckStatus(input: GetReadinessCheckStatusRequest): GetReadinessCheckStatusResponse

    /**
     * Gets details about a recovery group, including a list of the cells that are included in it.
     */
    public suspend fun getRecoveryGroup(input: GetRecoveryGroupRequest): GetRecoveryGroupResponse

    /**
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.
     */
    public suspend fun getRecoveryGroupReadinessSummary(input: GetRecoveryGroupReadinessSummaryRequest): GetRecoveryGroupReadinessSummaryResponse

    /**
     * Displays the details about a resource set, including a list of the resources in the set.
     */
    public suspend fun getResourceSet(input: GetResourceSetRequest): GetResourceSetResponse

    /**
     * Lists the cells for an account.
     */
    public suspend fun listCells(input: ListCellsRequest = ListCellsRequest {}): ListCellsResponse

    /**
     * Lists the cross-account readiness authorizations that are in place for an account.
     */
    public suspend fun listCrossAccountAuthorizations(input: ListCrossAccountAuthorizationsRequest = ListCrossAccountAuthorizationsRequest {}): ListCrossAccountAuthorizationsResponse

    /**
     * Lists the readiness checks for an account.
     */
    public suspend fun listReadinessChecks(input: ListReadinessChecksRequest = ListReadinessChecksRequest {}): ListReadinessChecksResponse

    /**
     * Lists the recovery groups in an account.
     */
    public suspend fun listRecoveryGroups(input: ListRecoveryGroupsRequest = ListRecoveryGroupsRequest {}): ListRecoveryGroupsResponse

    /**
     * Lists the resource sets in an account.
     */
    public suspend fun listResourceSets(input: ListResourceSetsRequest = ListResourceSetsRequest {}): ListResourceSetsResponse

    /**
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     */
    public suspend fun listRules(input: ListRulesRequest = ListRulesRequest {}): ListRulesResponse

    /**
     * Lists the tags for a resource.
     */
    public suspend fun listTagsForResources(input: ListTagsForResourcesRequest): ListTagsForResourcesResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a cell to replace the list of nested cells with a new list of nested cells.
     */
    public suspend fun updateCell(input: UpdateCellRequest): UpdateCellResponse

    /**
     * Updates a readiness check.
     */
    public suspend fun updateReadinessCheck(input: UpdateReadinessCheckRequest): UpdateReadinessCheckResponse

    /**
     * Updates a recovery group.
     */
    public suspend fun updateRecoveryGroup(input: UpdateRecoveryGroupRequest): UpdateRecoveryGroupResponse

    /**
     * Updates a resource set.
     */
    public suspend fun updateResourceSet(input: UpdateResourceSetRequest): UpdateResourceSetResponse
}

/**
 * Creates a cell in an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.createCell(crossinline block: CreateCellRequest.Builder.() -> Unit): CreateCellResponse = createCell(CreateCellRequest.Builder().apply(block).build())

/**
 * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
 */
public suspend inline fun Route53RecoveryReadinessClient.createCrossAccountAuthorization(crossinline block: CreateCrossAccountAuthorizationRequest.Builder.() -> Unit): CreateCrossAccountAuthorizationResponse = createCrossAccountAuthorization(CreateCrossAccountAuthorizationRequest.Builder().apply(block).build())

/**
 * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.createReadinessCheck(crossinline block: CreateReadinessCheckRequest.Builder.() -> Unit): CreateReadinessCheckResponse = createReadinessCheck(CreateReadinessCheckRequest.Builder().apply(block).build())

/**
 * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.
 */
public suspend inline fun Route53RecoveryReadinessClient.createRecoveryGroup(crossinline block: CreateRecoveryGroupRequest.Builder.() -> Unit): CreateRecoveryGroupResponse = createRecoveryGroup(CreateRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.
 */
public suspend inline fun Route53RecoveryReadinessClient.createResourceSet(crossinline block: CreateResourceSetRequest.Builder.() -> Unit): CreateResourceSetResponse = createResourceSet(CreateResourceSetRequest.Builder().apply(block).build())

/**
 * Delete a cell. When successful, the response code is 204, with no response body.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteCell(crossinline block: DeleteCellRequest.Builder.() -> Unit): DeleteCellResponse = deleteCell(DeleteCellRequest.Builder().apply(block).build())

/**
 * Deletes cross account readiness authorization.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteCrossAccountAuthorization(crossinline block: DeleteCrossAccountAuthorizationRequest.Builder.() -> Unit): DeleteCrossAccountAuthorizationResponse = deleteCrossAccountAuthorization(DeleteCrossAccountAuthorizationRequest.Builder().apply(block).build())

/**
 * Deletes a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteReadinessCheck(crossinline block: DeleteReadinessCheckRequest.Builder.() -> Unit): DeleteReadinessCheckResponse = deleteReadinessCheck(DeleteReadinessCheckRequest.Builder().apply(block).build())

/**
 * Deletes a recovery group.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteRecoveryGroup(crossinline block: DeleteRecoveryGroupRequest.Builder.() -> Unit): DeleteRecoveryGroupResponse = deleteRecoveryGroup(DeleteRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Deletes a resource set.
 */
public suspend inline fun Route53RecoveryReadinessClient.deleteResourceSet(crossinline block: DeleteResourceSetRequest.Builder.() -> Unit): DeleteResourceSetResponse = deleteResourceSet(DeleteResourceSetRequest.Builder().apply(block).build())

/**
 * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.
 */
public suspend inline fun Route53RecoveryReadinessClient.getArchitectureRecommendations(crossinline block: GetArchitectureRecommendationsRequest.Builder.() -> Unit): GetArchitectureRecommendationsResponse = getArchitectureRecommendations(GetArchitectureRecommendationsRequest.Builder().apply(block).build())

/**
 * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.
 */
public suspend inline fun Route53RecoveryReadinessClient.getCell(crossinline block: GetCellRequest.Builder.() -> Unit): GetCellResponse = getCell(GetCellRequest.Builder().apply(block).build())

/**
 * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.
 */
public suspend inline fun Route53RecoveryReadinessClient.getCellReadinessSummary(crossinline block: GetCellReadinessSummaryRequest.Builder.() -> Unit): GetCellReadinessSummaryResponse = getCellReadinessSummary(GetCellReadinessSummaryRequest.Builder().apply(block).build())

/**
 * Gets details about a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.getReadinessCheck(crossinline block: GetReadinessCheckRequest.Builder.() -> Unit): GetReadinessCheckResponse = getReadinessCheck(GetReadinessCheckRequest.Builder().apply(block).build())

/**
 * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
 */
public suspend inline fun Route53RecoveryReadinessClient.getReadinessCheckResourceStatus(crossinline block: GetReadinessCheckResourceStatusRequest.Builder.() -> Unit): GetReadinessCheckResourceStatusResponse = getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusRequest.Builder().apply(block).build())

/**
 * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
 */
public suspend inline fun Route53RecoveryReadinessClient.getReadinessCheckStatus(crossinline block: GetReadinessCheckStatusRequest.Builder.() -> Unit): GetReadinessCheckStatusResponse = getReadinessCheckStatus(GetReadinessCheckStatusRequest.Builder().apply(block).build())

/**
 * Gets details about a recovery group, including a list of the cells that are included in it.
 */
public suspend inline fun Route53RecoveryReadinessClient.getRecoveryGroup(crossinline block: GetRecoveryGroupRequest.Builder.() -> Unit): GetRecoveryGroupResponse = getRecoveryGroup(GetRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.
 */
public suspend inline fun Route53RecoveryReadinessClient.getRecoveryGroupReadinessSummary(crossinline block: GetRecoveryGroupReadinessSummaryRequest.Builder.() -> Unit): GetRecoveryGroupReadinessSummaryResponse = getRecoveryGroupReadinessSummary(GetRecoveryGroupReadinessSummaryRequest.Builder().apply(block).build())

/**
 * Displays the details about a resource set, including a list of the resources in the set.
 */
public suspend inline fun Route53RecoveryReadinessClient.getResourceSet(crossinline block: GetResourceSetRequest.Builder.() -> Unit): GetResourceSetResponse = getResourceSet(GetResourceSetRequest.Builder().apply(block).build())

/**
 * Lists the cells for an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listCells(crossinline block: ListCellsRequest.Builder.() -> Unit): ListCellsResponse = listCells(ListCellsRequest.Builder().apply(block).build())

/**
 * Lists the cross-account readiness authorizations that are in place for an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listCrossAccountAuthorizations(crossinline block: ListCrossAccountAuthorizationsRequest.Builder.() -> Unit): ListCrossAccountAuthorizationsResponse = listCrossAccountAuthorizations(ListCrossAccountAuthorizationsRequest.Builder().apply(block).build())

/**
 * Lists the readiness checks for an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listReadinessChecks(crossinline block: ListReadinessChecksRequest.Builder.() -> Unit): ListReadinessChecksResponse = listReadinessChecks(ListReadinessChecksRequest.Builder().apply(block).build())

/**
 * Lists the recovery groups in an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listRecoveryGroups(crossinline block: ListRecoveryGroupsRequest.Builder.() -> Unit): ListRecoveryGroupsResponse = listRecoveryGroups(ListRecoveryGroupsRequest.Builder().apply(block).build())

/**
 * Lists the resource sets in an account.
 */
public suspend inline fun Route53RecoveryReadinessClient.listResourceSets(crossinline block: ListResourceSetsRequest.Builder.() -> Unit): ListResourceSetsResponse = listResourceSets(ListResourceSetsRequest.Builder().apply(block).build())

/**
 * Lists all readiness rules, or lists the readiness rules for a specific resource type.
 */
public suspend inline fun Route53RecoveryReadinessClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * Lists the tags for a resource.
 */
public suspend inline fun Route53RecoveryReadinessClient.listTagsForResources(crossinline block: ListTagsForResourcesRequest.Builder.() -> Unit): ListTagsForResourcesResponse = listTagsForResources(ListTagsForResourcesRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun Route53RecoveryReadinessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun Route53RecoveryReadinessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a cell to replace the list of nested cells with a new list of nested cells.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateCell(crossinline block: UpdateCellRequest.Builder.() -> Unit): UpdateCellResponse = updateCell(UpdateCellRequest.Builder().apply(block).build())

/**
 * Updates a readiness check.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateReadinessCheck(crossinline block: UpdateReadinessCheckRequest.Builder.() -> Unit): UpdateReadinessCheckResponse = updateReadinessCheck(UpdateReadinessCheckRequest.Builder().apply(block).build())

/**
 * Updates a recovery group.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateRecoveryGroup(crossinline block: UpdateRecoveryGroupRequest.Builder.() -> Unit): UpdateRecoveryGroupResponse = updateRecoveryGroup(UpdateRecoveryGroupRequest.Builder().apply(block).build())

/**
 * Updates a resource set.
 */
public suspend inline fun Route53RecoveryReadinessClient.updateResourceSet(crossinline block: UpdateResourceSetRequest.Builder.() -> Unit): UpdateResourceSetResponse = updateResourceSet(UpdateResourceSetRequest.Builder().apply(block).build())
