// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoveryreadiness

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.route53recoveryreadiness.model.*
import aws.sdk.kotlin.services.route53recoveryreadiness.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Route53 Recovery Readiness"
public const val ServiceApiVersion: String = "2019-12-02"
public const val SdkVersion: String = "0.17.3-beta"

internal class DefaultRoute53RecoveryReadinessClient(override val config: Route53RecoveryReadinessClient.Config) : Route53RecoveryReadinessClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a cell in an account.
     */
    override suspend fun createCell(input: CreateCellRequest): CreateCellResponse {
        val op = SdkHttpOperation.build<CreateCellRequest, CreateCellResponse> {
            serializer = CreateCellOperationSerializer()
            deserializer = CreateCellOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCell"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
     */
    override suspend fun createCrossAccountAuthorization(input: CreateCrossAccountAuthorizationRequest): CreateCrossAccountAuthorizationResponse {
        val op = SdkHttpOperation.build<CreateCrossAccountAuthorizationRequest, CreateCrossAccountAuthorizationResponse> {
            serializer = CreateCrossAccountAuthorizationOperationSerializer()
            deserializer = CreateCrossAccountAuthorizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCrossAccountAuthorization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.
     */
    override suspend fun createReadinessCheck(input: CreateReadinessCheckRequest): CreateReadinessCheckResponse {
        val op = SdkHttpOperation.build<CreateReadinessCheckRequest, CreateReadinessCheckResponse> {
            serializer = CreateReadinessCheckOperationSerializer()
            deserializer = CreateReadinessCheckOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReadinessCheck"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.
     */
    override suspend fun createRecoveryGroup(input: CreateRecoveryGroupRequest): CreateRecoveryGroupResponse {
        val op = SdkHttpOperation.build<CreateRecoveryGroupRequest, CreateRecoveryGroupResponse> {
            serializer = CreateRecoveryGroupOperationSerializer()
            deserializer = CreateRecoveryGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRecoveryGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.
     */
    override suspend fun createResourceSet(input: CreateResourceSetRequest): CreateResourceSetResponse {
        val op = SdkHttpOperation.build<CreateResourceSetRequest, CreateResourceSetResponse> {
            serializer = CreateResourceSetOperationSerializer()
            deserializer = CreateResourceSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResourceSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a cell. When successful, the response code is 204, with no response body.
     */
    override suspend fun deleteCell(input: DeleteCellRequest): DeleteCellResponse {
        val op = SdkHttpOperation.build<DeleteCellRequest, DeleteCellResponse> {
            serializer = DeleteCellOperationSerializer()
            deserializer = DeleteCellOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteCell"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes cross account readiness authorization.
     */
    override suspend fun deleteCrossAccountAuthorization(input: DeleteCrossAccountAuthorizationRequest): DeleteCrossAccountAuthorizationResponse {
        val op = SdkHttpOperation.build<DeleteCrossAccountAuthorizationRequest, DeleteCrossAccountAuthorizationResponse> {
            serializer = DeleteCrossAccountAuthorizationOperationSerializer()
            deserializer = DeleteCrossAccountAuthorizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCrossAccountAuthorization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a readiness check.
     */
    override suspend fun deleteReadinessCheck(input: DeleteReadinessCheckRequest): DeleteReadinessCheckResponse {
        val op = SdkHttpOperation.build<DeleteReadinessCheckRequest, DeleteReadinessCheckResponse> {
            serializer = DeleteReadinessCheckOperationSerializer()
            deserializer = DeleteReadinessCheckOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteReadinessCheck"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a recovery group.
     */
    override suspend fun deleteRecoveryGroup(input: DeleteRecoveryGroupRequest): DeleteRecoveryGroupResponse {
        val op = SdkHttpOperation.build<DeleteRecoveryGroupRequest, DeleteRecoveryGroupResponse> {
            serializer = DeleteRecoveryGroupOperationSerializer()
            deserializer = DeleteRecoveryGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteRecoveryGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a resource set.
     */
    override suspend fun deleteResourceSet(input: DeleteResourceSetRequest): DeleteResourceSetResponse {
        val op = SdkHttpOperation.build<DeleteResourceSetRequest, DeleteResourceSetResponse> {
            serializer = DeleteResourceSetOperationSerializer()
            deserializer = DeleteResourceSetOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteResourceSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.
     */
    override suspend fun getArchitectureRecommendations(input: GetArchitectureRecommendationsRequest): GetArchitectureRecommendationsResponse {
        val op = SdkHttpOperation.build<GetArchitectureRecommendationsRequest, GetArchitectureRecommendationsResponse> {
            serializer = GetArchitectureRecommendationsOperationSerializer()
            deserializer = GetArchitectureRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetArchitectureRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.
     */
    override suspend fun getCell(input: GetCellRequest): GetCellResponse {
        val op = SdkHttpOperation.build<GetCellRequest, GetCellResponse> {
            serializer = GetCellOperationSerializer()
            deserializer = GetCellOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCell"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.
     */
    override suspend fun getCellReadinessSummary(input: GetCellReadinessSummaryRequest): GetCellReadinessSummaryResponse {
        val op = SdkHttpOperation.build<GetCellReadinessSummaryRequest, GetCellReadinessSummaryResponse> {
            serializer = GetCellReadinessSummaryOperationSerializer()
            deserializer = GetCellReadinessSummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCellReadinessSummary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a readiness check.
     */
    override suspend fun getReadinessCheck(input: GetReadinessCheckRequest): GetReadinessCheckResponse {
        val op = SdkHttpOperation.build<GetReadinessCheckRequest, GetReadinessCheckResponse> {
            serializer = GetReadinessCheckOperationSerializer()
            deserializer = GetReadinessCheckOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReadinessCheck"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
     */
    override suspend fun getReadinessCheckResourceStatus(input: GetReadinessCheckResourceStatusRequest): GetReadinessCheckResourceStatusResponse {
        val op = SdkHttpOperation.build<GetReadinessCheckResourceStatusRequest, GetReadinessCheckResourceStatusResponse> {
            serializer = GetReadinessCheckResourceStatusOperationSerializer()
            deserializer = GetReadinessCheckResourceStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReadinessCheckResourceStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
     */
    override suspend fun getReadinessCheckStatus(input: GetReadinessCheckStatusRequest): GetReadinessCheckStatusResponse {
        val op = SdkHttpOperation.build<GetReadinessCheckStatusRequest, GetReadinessCheckStatusResponse> {
            serializer = GetReadinessCheckStatusOperationSerializer()
            deserializer = GetReadinessCheckStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReadinessCheckStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a recovery group, including a list of the cells that are included in it.
     */
    override suspend fun getRecoveryGroup(input: GetRecoveryGroupRequest): GetRecoveryGroupResponse {
        val op = SdkHttpOperation.build<GetRecoveryGroupRequest, GetRecoveryGroupResponse> {
            serializer = GetRecoveryGroupOperationSerializer()
            deserializer = GetRecoveryGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecoveryGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.
     */
    override suspend fun getRecoveryGroupReadinessSummary(input: GetRecoveryGroupReadinessSummaryRequest): GetRecoveryGroupReadinessSummaryResponse {
        val op = SdkHttpOperation.build<GetRecoveryGroupReadinessSummaryRequest, GetRecoveryGroupReadinessSummaryResponse> {
            serializer = GetRecoveryGroupReadinessSummaryOperationSerializer()
            deserializer = GetRecoveryGroupReadinessSummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecoveryGroupReadinessSummary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays the details about a resource set, including a list of the resources in the set.
     */
    override suspend fun getResourceSet(input: GetResourceSetRequest): GetResourceSetResponse {
        val op = SdkHttpOperation.build<GetResourceSetRequest, GetResourceSetResponse> {
            serializer = GetResourceSetOperationSerializer()
            deserializer = GetResourceSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourceSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the cells for an account.
     */
    override suspend fun listCells(input: ListCellsRequest): ListCellsResponse {
        val op = SdkHttpOperation.build<ListCellsRequest, ListCellsResponse> {
            serializer = ListCellsOperationSerializer()
            deserializer = ListCellsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCells"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the cross-account readiness authorizations that are in place for an account.
     */
    override suspend fun listCrossAccountAuthorizations(input: ListCrossAccountAuthorizationsRequest): ListCrossAccountAuthorizationsResponse {
        val op = SdkHttpOperation.build<ListCrossAccountAuthorizationsRequest, ListCrossAccountAuthorizationsResponse> {
            serializer = ListCrossAccountAuthorizationsOperationSerializer()
            deserializer = ListCrossAccountAuthorizationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCrossAccountAuthorizations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the readiness checks for an account.
     */
    override suspend fun listReadinessChecks(input: ListReadinessChecksRequest): ListReadinessChecksResponse {
        val op = SdkHttpOperation.build<ListReadinessChecksRequest, ListReadinessChecksResponse> {
            serializer = ListReadinessChecksOperationSerializer()
            deserializer = ListReadinessChecksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReadinessChecks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the recovery groups in an account.
     */
    override suspend fun listRecoveryGroups(input: ListRecoveryGroupsRequest): ListRecoveryGroupsResponse {
        val op = SdkHttpOperation.build<ListRecoveryGroupsRequest, ListRecoveryGroupsResponse> {
            serializer = ListRecoveryGroupsOperationSerializer()
            deserializer = ListRecoveryGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecoveryGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resource sets in an account.
     */
    override suspend fun listResourceSets(input: ListResourceSetsRequest): ListResourceSetsResponse {
        val op = SdkHttpOperation.build<ListResourceSetsRequest, ListResourceSetsResponse> {
            serializer = ListResourceSetsOperationSerializer()
            deserializer = ListResourceSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResourceSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     */
    override suspend fun listRules(input: ListRulesRequest): ListRulesResponse {
        val op = SdkHttpOperation.build<ListRulesRequest, ListRulesResponse> {
            serializer = ListRulesOperationSerializer()
            deserializer = ListRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for a resource.
     */
    override suspend fun listTagsForResources(input: ListTagsForResourcesRequest): ListTagsForResourcesResponse {
        val op = SdkHttpOperation.build<ListTagsForResourcesRequest, ListTagsForResourcesResponse> {
            serializer = ListTagsForResourcesOperationSerializer()
            deserializer = ListTagsForResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a cell to replace the list of nested cells with a new list of nested cells.
     */
    override suspend fun updateCell(input: UpdateCellRequest): UpdateCellResponse {
        val op = SdkHttpOperation.build<UpdateCellRequest, UpdateCellResponse> {
            serializer = UpdateCellOperationSerializer()
            deserializer = UpdateCellOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCell"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a readiness check.
     */
    override suspend fun updateReadinessCheck(input: UpdateReadinessCheckRequest): UpdateReadinessCheckResponse {
        val op = SdkHttpOperation.build<UpdateReadinessCheckRequest, UpdateReadinessCheckResponse> {
            serializer = UpdateReadinessCheckOperationSerializer()
            deserializer = UpdateReadinessCheckOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateReadinessCheck"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a recovery group.
     */
    override suspend fun updateRecoveryGroup(input: UpdateRecoveryGroupRequest): UpdateRecoveryGroupResponse {
        val op = SdkHttpOperation.build<UpdateRecoveryGroupRequest, UpdateRecoveryGroupResponse> {
            serializer = UpdateRecoveryGroupOperationSerializer()
            deserializer = UpdateRecoveryGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRecoveryGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a resource set.
     */
    override suspend fun updateResourceSet(input: UpdateResourceSetRequest): UpdateResourceSetResponse {
        val op = SdkHttpOperation.build<UpdateResourceSetRequest, UpdateResourceSetResponse> {
            serializer = UpdateResourceSetOperationSerializer()
            deserializer = UpdateResourceSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResourceSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-readiness"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "route53-recovery-readiness")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
