// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.paginators

import aws.sdk.kotlin.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Cluster
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ControlPanel
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RoutingControl
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Rule
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAssociatedRoute53HealthChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedRoute53HealthChecksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedRoute53HealthChecksResponse]
 */
public fun Route53RecoveryControlConfigClient.listAssociatedRoute53HealthChecksPaginated(initialRequest: ListAssociatedRoute53HealthChecksRequest): Flow<ListAssociatedRoute53HealthChecksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedRoute53HealthChecksPaginated.listAssociatedRoute53HealthChecks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedRoute53HealthChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedRoute53HealthChecksResponse]
 */
public fun Route53RecoveryControlConfigClient.listAssociatedRoute53HealthChecksPaginated(block: ListAssociatedRoute53HealthChecksRequest.Builder.() -> Unit): Flow<ListAssociatedRoute53HealthChecksResponse> =
    listAssociatedRoute53HealthChecksPaginated(ListAssociatedRoute53HealthChecksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssociatedRoute53HealthChecksPaginated]
 * to access the nested member [StringMax36PatternS]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StringMax36PatternS]
 */
@JvmName("listAssociatedRoute53HealthChecksResponseStringMax36PatternS")
public fun Flow<ListAssociatedRoute53HealthChecksResponse>.healthCheckIds(): Flow<String> =
    transform() { response ->
        response.healthCheckIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun Route53RecoveryControlConfigClient.listClustersPaginated(initialRequest: ListClustersRequest = ListClustersRequest { }): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun Route53RecoveryControlConfigClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [Cluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Cluster]
 */
@JvmName("listClustersResponseCluster")
public fun Flow<ListClustersResponse>.clusters(): Flow<Cluster> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListControlPanelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListControlPanelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlPanelsResponse]
 */
public fun Route53RecoveryControlConfigClient.listControlPanelsPaginated(initialRequest: ListControlPanelsRequest = ListControlPanelsRequest { }): Flow<ListControlPanelsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listControlPanelsPaginated.listControlPanels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListControlPanelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlPanelsResponse]
 */
public fun Route53RecoveryControlConfigClient.listControlPanelsPaginated(block: ListControlPanelsRequest.Builder.() -> Unit): Flow<ListControlPanelsResponse> =
    listControlPanelsPaginated(ListControlPanelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listControlPanelsPaginated]
 * to access the nested member [ControlPanel]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ControlPanel]
 */
@JvmName("listControlPanelsResponseControlPanel")
public fun Flow<ListControlPanelsResponse>.controlPanels(): Flow<ControlPanel> =
    transform() { response ->
        response.controlPanels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRoutingControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoutingControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingControlsResponse]
 */
public fun Route53RecoveryControlConfigClient.listRoutingControlsPaginated(initialRequest: ListRoutingControlsRequest): Flow<ListRoutingControlsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoutingControlsPaginated.listRoutingControls(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRoutingControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingControlsResponse]
 */
public fun Route53RecoveryControlConfigClient.listRoutingControlsPaginated(block: ListRoutingControlsRequest.Builder.() -> Unit): Flow<ListRoutingControlsResponse> =
    listRoutingControlsPaginated(ListRoutingControlsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRoutingControlsPaginated]
 * to access the nested member [RoutingControl]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RoutingControl]
 */
@JvmName("listRoutingControlsResponseRoutingControl")
public fun Flow<ListRoutingControlsResponse>.routingControls(): Flow<RoutingControl> =
    transform() { response ->
        response.routingControls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSafetyRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSafetyRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSafetyRulesResponse]
 */
public fun Route53RecoveryControlConfigClient.listSafetyRulesPaginated(initialRequest: ListSafetyRulesRequest): Flow<ListSafetyRulesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSafetyRulesPaginated.listSafetyRules(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSafetyRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSafetyRulesResponse]
 */
public fun Route53RecoveryControlConfigClient.listSafetyRulesPaginated(block: ListSafetyRulesRequest.Builder.() -> Unit): Flow<ListSafetyRulesResponse> =
    listSafetyRulesPaginated(ListSafetyRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSafetyRulesPaginated]
 * to access the nested member [Rule]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Rule]
 */
@JvmName("listSafetyRulesResponseRule")
public fun Flow<ListSafetyRulesResponse>.safetyRules(): Flow<Rule> =
    transform() { response ->
        response.safetyRules?.forEach {
            emit(it)
        }
    }
