// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A safety rule. A safety rule can be an assertion rule or a gating rule.
 */
public class Rule private constructor(builder: Builder) {
    /**
     * An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control state is not accepted. For example, the criteria might be that at least one routing control state is On after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     */
    public val assertion: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule? = builder.assertion
    /**
     * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     *
     * For example, if you specify one gating routing control and you set the Type in the rule configuration to OR, that indicates that you must set the gating routing control to On for the rule to evaluate as true; that is, for the gating control "switch" to be "On". When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
     */
    public val gating: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule? = builder.gating

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("assertion=$assertion,")
        append("gating=$gating")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assertion?.hashCode() ?: 0
        result = 31 * result + (gating?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (assertion != other.assertion) return false
        if (gating != other.gating) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Rule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control state is not accepted. For example, the criteria might be that at least one routing control state is On after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         */
        public var assertion: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule? = null
        /**
         * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
         *
         * For example, if you specify one gating routing control and you set the Type in the rule configuration to OR, that indicates that you must set the gating routing control to On for the rule to evaluate as true; that is, for the gating control "switch" to be "On". When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
         */
        public var gating: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Rule) : this() {
            this.assertion = x.assertion
            this.gating = x.gating
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Rule = Rule(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule] inside the given [block]
         */
        public fun assertion(block: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule.Builder.() -> kotlin.Unit) {
            this.assertion = aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule] inside the given [block]
         */
        public fun gating(block: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule.Builder.() -> kotlin.Unit) {
            this.gating = aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
