// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.
 */
public class RoutingControl private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the control panel that includes the routing control.
     */
    public val controlPanelArn: kotlin.String? = builder.controlPanelArn
    /**
     * The name of the routing control.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID of the routing control owner.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The Amazon Resource Name (ARN) of the routing control.
     */
    public val routingControlArn: kotlin.String? = builder.routingControlArn
    /**
     * The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     */
    public val status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RoutingControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingControl(")
        append("controlPanelArn=$controlPanelArn,")
        append("name=$name,")
        append("owner=$owner,")
        append("routingControlArn=$routingControlArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlPanelArn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (routingControlArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingControl

        if (controlPanelArn != other.controlPanelArn) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (routingControlArn != other.routingControlArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RoutingControl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the control panel that includes the routing control.
         */
        public var controlPanelArn: kotlin.String? = null
        /**
         * The name of the routing control.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the routing control owner.
         */
        public var owner: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the routing control.
         */
        public var routingControlArn: kotlin.String? = null
        /**
         * The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
         */
        public var status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RoutingControl) : this() {
            this.controlPanelArn = x.controlPanelArn
            this.name = x.name
            this.owner = x.owner
            this.routingControlArn = x.routingControlArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RoutingControl = RoutingControl(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
