// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
 *
 * For example, if you specify one gating routing control and you set the Type in the rule configuration to OR, that indicates that you must set the gating routing control to On for the rule to evaluate as true; that is, for the gating control "switch" to be "On". When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
 */
public class GatingRule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the control panel.
     */
    public val controlPanelArn: kotlin.String? = builder.controlPanelArn
    /**
     * An array of gating routing control Amazon Resource Names (ARNs). For a simple "on/off" switch, specify the ARN for one routing control. The gating routing controls are evaluated by the rule configuration that you specify to determine if the target routing control states can be changed.
     */
    public val gatingControls: List<String>? = builder.gatingControls
    /**
     * The name for the gating rule. You can use any non-white space character in the name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID of the gating rule owner.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The criteria that you set for gating routing controls that designate how many of the routing control states must be ON to allow you to update target routing control states.
     */
    public val ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = builder.ruleConfig
    /**
     * The Amazon Resource Name (ARN) of the gating rule.
     */
    public val safetyRuleArn: kotlin.String? = builder.safetyRuleArn
    /**
     * The deployment status of a gating rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     */
    public val status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = builder.status
    /**
     * An array of target routing control Amazon Resource Names (ARNs) for which the states can only be updated if the rule configuration that you specify evaluates to true for the gating routing control. As a simple example, if you have a single gating control, it acts as an overall "on/off" switch for a set of target routing controls. You can use this to manually override automated failover, for example.
     */
    public val targetControls: List<String>? = builder.targetControls
    /**
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
     */
    public val waitPeriodMs: kotlin.Int? = builder.waitPeriodMs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatingRule(")
        append("controlPanelArn=$controlPanelArn,")
        append("gatingControls=$gatingControls,")
        append("name=$name,")
        append("owner=$owner,")
        append("ruleConfig=$ruleConfig,")
        append("safetyRuleArn=$safetyRuleArn,")
        append("status=$status,")
        append("targetControls=$targetControls,")
        append("waitPeriodMs=$waitPeriodMs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlPanelArn?.hashCode() ?: 0
        result = 31 * result + (gatingControls?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (ruleConfig?.hashCode() ?: 0)
        result = 31 * result + (safetyRuleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetControls?.hashCode() ?: 0)
        result = 31 * result + (waitPeriodMs ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatingRule

        if (controlPanelArn != other.controlPanelArn) return false
        if (gatingControls != other.gatingControls) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (ruleConfig != other.ruleConfig) return false
        if (safetyRuleArn != other.safetyRuleArn) return false
        if (status != other.status) return false
        if (targetControls != other.targetControls) return false
        if (waitPeriodMs != other.waitPeriodMs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the control panel.
         */
        public var controlPanelArn: kotlin.String? = null
        /**
         * An array of gating routing control Amazon Resource Names (ARNs). For a simple "on/off" switch, specify the ARN for one routing control. The gating routing controls are evaluated by the rule configuration that you specify to determine if the target routing control states can be changed.
         */
        public var gatingControls: List<String>? = null
        /**
         * The name for the gating rule. You can use any non-white space character in the name.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the gating rule owner.
         */
        public var owner: kotlin.String? = null
        /**
         * The criteria that you set for gating routing controls that designate how many of the routing control states must be ON to allow you to update target routing control states.
         */
        public var ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the gating rule.
         */
        public var safetyRuleArn: kotlin.String? = null
        /**
         * The deployment status of a gating rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
         */
        public var status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = null
        /**
         * An array of target routing control Amazon Resource Names (ARNs) for which the states can only be updated if the rule configuration that you specify evaluates to true for the gating routing control. As a simple example, if you have a single gating control, it acts as an overall "on/off" switch for a set of target routing controls. You can use this to manually override automated failover, for example.
         */
        public var targetControls: List<String>? = null
        /**
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
         */
        public var waitPeriodMs: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule) : this() {
            this.controlPanelArn = x.controlPanelArn
            this.gatingControls = x.gatingControls
            this.name = x.name
            this.owner = x.owner
            this.ruleConfig = x.ruleConfig
            this.safetyRuleArn = x.safetyRuleArn
            this.status = x.status
            this.targetControls = x.targetControls
            this.waitPeriodMs = x.waitPeriodMs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule = GatingRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig] inside the given [block]
         */
        public fun ruleConfig(block: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.Builder.() -> kotlin.Unit) {
            this.ruleConfig = aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
