// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.route53recoverycontrolconfig.auth.DefaultRoute53RecoveryControlConfigAuthSchemeProvider
import aws.sdk.kotlin.services.route53recoverycontrolconfig.auth.Route53RecoveryControlConfigAuthSchemeProvider
import aws.sdk.kotlin.services.route53recoverycontrolconfig.endpoints.DefaultRoute53RecoveryControlConfigEndpointProvider
import aws.sdk.kotlin.services.route53recoverycontrolconfig.endpoints.Route53RecoveryControlConfigEndpointParameters
import aws.sdk.kotlin.services.route53recoverycontrolconfig.endpoints.Route53RecoveryControlConfigEndpointProvider
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateClusterRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateClusterResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteClusterRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteClusterResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeClusterRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeClusterResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.TagResourceRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.TagResourceResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UntagResourceRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UntagResourceResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Route53 Recovery Control Config"
public const val SdkVersion: String = "1.3.92"
public const val ServiceApiVersion: String = "2020-11-02"

/**
 * Recovery Control Configuration API Reference for Amazon Route 53 Application Recovery Controller
 */
public interface Route53RecoveryControlConfigClient : SdkClient {
    /**
     * Route53RecoveryControlConfigClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Route53RecoveryControlConfigClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Route53RecoveryControlConfig",
                "ROUTE53_RECOVERY_CONTROL_CONFIG",
                "route53_recovery_control_config",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Route53RecoveryControlConfigClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Route53RecoveryControlConfigClient = DefaultRoute53RecoveryControlConfigClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: Route53RecoveryControlConfigEndpointProvider = builder.endpointProvider ?: DefaultRoute53RecoveryControlConfigEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: Route53RecoveryControlConfigAuthSchemeProvider = builder.authSchemeProvider ?: DefaultRoute53RecoveryControlConfigAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Route53 Recovery Control Config"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: Route53RecoveryControlConfigEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: Route53RecoveryControlConfigAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the cluster data plane.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.
     */
    public suspend fun createControlPanel(input: CreateControlPanelRequest): CreateControlPanelResponse

    /**
     * Creates a new routing control.
     *
     * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.
     *
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    public suspend fun createRoutingControl(input: CreateRoutingControlRequest): CreateRoutingControlResponse

    /**
     * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
     *
     * There are two types of safety rules: assertion rules and gating rules.
     *
     * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria is met. For example, the criteria might be that at least one routing control state is On after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     *
     * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple gating routing controls.
     *
     * For more information, see [Safety rules](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
     */
    public suspend fun createSafetyRule(input: CreateSafetyRuleRequest = CreateSafetyRuleRequest { }): CreateSafetyRuleResponse

    /**
     * Delete a cluster.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a control panel.
     */
    public suspend fun deleteControlPanel(input: DeleteControlPanelRequest): DeleteControlPanelResponse

    /**
     * Deletes a routing control.
     */
    public suspend fun deleteRoutingControl(input: DeleteRoutingControlRequest): DeleteRoutingControlResponse

    /**
     * Deletes a safety rule.
     *
     * />
     */
    public suspend fun deleteSafetyRule(input: DeleteSafetyRuleRequest): DeleteSafetyRuleResponse

    /**
     * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Displays details about a control panel.
     */
    public suspend fun describeControlPanel(input: DescribeControlPanelRequest): DescribeControlPanelResponse

    /**
     * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     *
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    public suspend fun describeRoutingControl(input: DescribeRoutingControlRequest): DescribeRoutingControlResponse

    /**
     * Returns information about a safety rule.
     */
    public suspend fun describeSafetyRule(input: DescribeSafetyRuleRequest): DescribeSafetyRuleResponse

    /**
     * Get information about the resource policy for a cluster.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     */
    public suspend fun listAssociatedRoute53HealthChecks(input: ListAssociatedRoute53HealthChecksRequest): ListAssociatedRoute53HealthChecksResponse

    /**
     * Returns an array of all the clusters in an account.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest { }): ListClustersResponse

    /**
     * Returns an array of control panels in an account or in a cluster.
     */
    public suspend fun listControlPanels(input: ListControlPanelsRequest = ListControlPanelsRequest { }): ListControlPanelsResponse

    /**
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     */
    public suspend fun listRoutingControls(input: ListRoutingControlsRequest): ListRoutingControlsResponse

    /**
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.
     */
    public suspend fun listSafetyRules(input: ListSafetyRulesRequest): ListSafetyRulesResponse

    /**
     * Lists the tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.
     */
    public suspend fun updateControlPanel(input: UpdateControlPanelRequest): UpdateControlPanelResponse

    /**
     * Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    public suspend fun updateRoutingControl(input: UpdateRoutingControlRequest): UpdateRoutingControlResponse

    /**
     * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new one.
     */
    public suspend fun updateSafetyRule(input: UpdateSafetyRuleRequest = UpdateSafetyRuleRequest { }): UpdateSafetyRuleResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Route53RecoveryControlConfigClient.withConfig(block: Route53RecoveryControlConfigClient.Config.Builder.() -> Unit): Route53RecoveryControlConfigClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRoute53RecoveryControlConfigClient(newConfig)
}

/**
 * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the cluster data plane.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createControlPanel(crossinline block: CreateControlPanelRequest.Builder.() -> Unit): CreateControlPanelResponse = createControlPanel(CreateControlPanelRequest.Builder().apply(block).build())

/**
 * Creates a new routing control.
 *
 * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.
 *
 * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createRoutingControl(crossinline block: CreateRoutingControlRequest.Builder.() -> Unit): CreateRoutingControlResponse = createRoutingControl(CreateRoutingControlRequest.Builder().apply(block).build())

/**
 * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
 *
 * There are two types of safety rules: assertion rules and gating rules.
 *
 * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria is met. For example, the criteria might be that at least one routing control state is On after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
 *
 * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple gating routing controls.
 *
 * For more information, see [Safety rules](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createSafetyRule(crossinline block: CreateSafetyRuleRequest.Builder.() -> Unit): CreateSafetyRuleResponse = createSafetyRule(CreateSafetyRuleRequest.Builder().apply(block).build())

/**
 * Delete a cluster.
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes a control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteControlPanel(crossinline block: DeleteControlPanelRequest.Builder.() -> Unit): DeleteControlPanelResponse = deleteControlPanel(DeleteControlPanelRequest.Builder().apply(block).build())

/**
 * Deletes a routing control.
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteRoutingControl(crossinline block: DeleteRoutingControlRequest.Builder.() -> Unit): DeleteRoutingControlResponse = deleteRoutingControl(DeleteRoutingControlRequest.Builder().apply(block).build())

/**
 * Deletes a safety rule.
 *
 * />
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteSafetyRule(crossinline block: DeleteSafetyRuleRequest.Builder.() -> Unit): DeleteSafetyRuleResponse = deleteSafetyRule(DeleteSafetyRuleRequest.Builder().apply(block).build())

/**
 * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Displays details about a control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeControlPanel(crossinline block: DescribeControlPanelRequest.Builder.() -> Unit): DescribeControlPanelResponse = describeControlPanel(DescribeControlPanelRequest.Builder().apply(block).build())

/**
 * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
 *
 * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeRoutingControl(crossinline block: DescribeRoutingControlRequest.Builder.() -> Unit): DescribeRoutingControlResponse = describeRoutingControl(DescribeRoutingControlRequest.Builder().apply(block).build())

/**
 * Returns information about a safety rule.
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeSafetyRule(crossinline block: DescribeSafetyRuleRequest.Builder.() -> Unit): DescribeSafetyRuleResponse = describeSafetyRule(DescribeSafetyRuleRequest.Builder().apply(block).build())

/**
 * Get information about the resource policy for a cluster.
 */
public suspend inline fun Route53RecoveryControlConfigClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listAssociatedRoute53HealthChecks(crossinline block: ListAssociatedRoute53HealthChecksRequest.Builder.() -> Unit): ListAssociatedRoute53HealthChecksResponse = listAssociatedRoute53HealthChecks(ListAssociatedRoute53HealthChecksRequest.Builder().apply(block).build())

/**
 * Returns an array of all the clusters in an account.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Returns an array of control panels in an account or in a cluster.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listControlPanels(crossinline block: ListControlPanelsRequest.Builder.() -> Unit): ListControlPanelsResponse = listControlPanels(ListControlPanelsRequest.Builder().apply(block).build())

/**
 * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listRoutingControls(crossinline block: ListRoutingControlsRequest.Builder.() -> Unit): ListRoutingControlsResponse = listRoutingControls(ListRoutingControlsRequest.Builder().apply(block).build())

/**
 * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listSafetyRules(crossinline block: ListSafetyRulesRequest.Builder.() -> Unit): ListSafetyRulesResponse = listSafetyRules(ListSafetyRulesRequest.Builder().apply(block).build())

/**
 * Lists the tags for a resource.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun Route53RecoveryControlConfigClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun Route53RecoveryControlConfigClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.updateControlPanel(crossinline block: UpdateControlPanelRequest.Builder.() -> Unit): UpdateControlPanelResponse = updateControlPanel(UpdateControlPanelRequest.Builder().apply(block).build())

/**
 * Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
 */
public suspend inline fun Route53RecoveryControlConfigClient.updateRoutingControl(crossinline block: UpdateRoutingControlRequest.Builder.() -> Unit): UpdateRoutingControlResponse = updateRoutingControl(UpdateRoutingControlRequest.Builder().apply(block).build())

/**
 * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new one.
 */
public suspend inline fun Route53RecoveryControlConfigClient.updateSafetyRule(crossinline block: UpdateSafetyRuleRequest.Builder.() -> Unit): UpdateSafetyRuleResponse = updateSafetyRule(UpdateSafetyRuleRequest.Builder().apply(block).build())
