// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.transform

import aws.sdk.kotlin.services.rolesanywhere.model.GetSubjectResponse
import aws.sdk.kotlin.services.rolesanywhere.model.RolesAnywhereException
import aws.sdk.kotlin.services.rolesanywhere.model.SubjectDetail
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSubjectOperationDeserializer: HttpDeserialize<GetSubjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSubjectResponse {
        if (!response.status.isSuccess()) {
            throwGetSubjectError(context, response)
        }
        val builder = GetSubjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSubjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSubjectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RolesAnywhereException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RolesAnywhereException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSubjectOperationBody(builder: GetSubjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUBJECT_DESCRIPTOR.index -> builder.subject = deserializeSubjectDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
