// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.model



/**
 * The state of a notification setting.
 *
 * A notification setting includes information such as event name, threshold, status of the notification setting, and the channel to notify.
 */
public class NotificationSettingDetail private constructor(builder: Builder) {
    /**
     * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health Dashboard to notify for an event.
     *
     * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
     */
    public val channel: aws.sdk.kotlin.services.rolesanywhere.model.NotificationChannel? = builder.channel
    /**
     * The principal that configured the notification setting. For default settings configured by IAM Roles Anywhere, the value is `rolesanywhere.amazonaws.com`, and for customized notifications settings, it is the respective account ID.
     */
    public val configuredBy: kotlin.String? = builder.configuredBy
    /**
     * Indicates whether the notification setting is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The event to which this notification setting is applied.
     */
    public val event: aws.sdk.kotlin.services.rolesanywhere.model.NotificationEvent? = builder.event
    /**
     * The number of days before a notification event.
     */
    public val threshold: kotlin.Int? = builder.threshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rolesanywhere.model.NotificationSettingDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationSettingDetail(")
        append("channel=$channel,")
        append("configuredBy=$configuredBy,")
        append("enabled=$enabled,")
        append("event=$event,")
        append("threshold=$threshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel?.hashCode() ?: 0
        result = 31 * result + (configuredBy?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (event?.hashCode() ?: 0)
        result = 31 * result + (threshold ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationSettingDetail

        if (channel != other.channel) return false
        if (configuredBy != other.configuredBy) return false
        if (enabled != other.enabled) return false
        if (event != other.event) return false
        if (threshold != other.threshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rolesanywhere.model.NotificationSettingDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health Dashboard to notify for an event.
         *
         * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
         */
        public var channel: aws.sdk.kotlin.services.rolesanywhere.model.NotificationChannel? = null
        /**
         * The principal that configured the notification setting. For default settings configured by IAM Roles Anywhere, the value is `rolesanywhere.amazonaws.com`, and for customized notifications settings, it is the respective account ID.
         */
        public var configuredBy: kotlin.String? = null
        /**
         * Indicates whether the notification setting is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The event to which this notification setting is applied.
         */
        public var event: aws.sdk.kotlin.services.rolesanywhere.model.NotificationEvent? = null
        /**
         * The number of days before a notification event.
         */
        public var threshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rolesanywhere.model.NotificationSettingDetail) : this() {
            this.channel = x.channel
            this.configuredBy = x.configuredBy
            this.enabled = x.enabled
            this.event = x.event
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rolesanywhere.model.NotificationSettingDetail = NotificationSettingDetail(this)
    }
}
