// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.model



/**
 * Customizable notification settings that will be applied to notification events. IAM Roles Anywhere consumes these settings while notifying across multiple channels - CloudWatch metrics, EventBridge, and Health Dashboard.
 */
public class NotificationSetting private constructor(builder: Builder) {
    /**
     * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health Dashboard to notify for an event.
     *
     * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
     */
    public val channel: aws.sdk.kotlin.services.rolesanywhere.model.NotificationChannel? = builder.channel
    /**
     * Indicates whether the notification setting is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The event to which this notification setting is applied.
     */
    public val event: aws.sdk.kotlin.services.rolesanywhere.model.NotificationEvent? = builder.event
    /**
     * The number of days before a notification event. This value is required for a notification setting that is enabled.
     */
    public val threshold: kotlin.Int? = builder.threshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rolesanywhere.model.NotificationSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationSetting(")
        append("channel=$channel,")
        append("enabled=$enabled,")
        append("event=$event,")
        append("threshold=$threshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (event?.hashCode() ?: 0)
        result = 31 * result + (threshold ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationSetting

        if (channel != other.channel) return false
        if (enabled != other.enabled) return false
        if (event != other.event) return false
        if (threshold != other.threshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rolesanywhere.model.NotificationSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health Dashboard to notify for an event.
         *
         * In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
         */
        public var channel: aws.sdk.kotlin.services.rolesanywhere.model.NotificationChannel? = null
        /**
         * Indicates whether the notification setting is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The event to which this notification setting is applied.
         */
        public var event: aws.sdk.kotlin.services.rolesanywhere.model.NotificationEvent? = null
        /**
         * The number of days before a notification event. This value is required for a notification setting that is enabled.
         */
        public var threshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rolesanywhere.model.NotificationSetting) : this() {
            this.channel = x.channel
            this.enabled = x.enabled
            this.event = x.event
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rolesanywhere.model.NotificationSetting = NotificationSetting(this)
    }
}
