// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.rolesanywhere.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.rolesanywhere.endpoints.EndpointParameters
import aws.sdk.kotlin.services.rolesanywhere.endpoints.EndpointProvider
import aws.sdk.kotlin.services.rolesanywhere.model.CreateProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.CreateProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.CreateTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.CreateTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DisableCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DisableCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DisableProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DisableProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DisableTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DisableTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.EnableCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.EnableCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.EnableProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.EnableProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.EnableTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.EnableTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetSubjectRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetSubjectResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ImportCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ImportCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListCrlsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListCrlsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListProfilesRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListProfilesResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListSubjectsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListSubjectsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListTrustAnchorsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListTrustAnchorsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.PutNotificationSettingsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.PutNotificationSettingsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ResetNotificationSettingsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ResetNotificationSettingsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.TagResourceRequest
import aws.sdk.kotlin.services.rolesanywhere.model.TagResourceResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UntagResourceRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UntagResourceResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateTrustAnchorResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "RolesAnywhere"
public const val SdkVersion: String = "0.30.0-beta"

/**
 * Identity and Access Management Roles Anywhere provides a secure way for your workloads such as servers, containers, and applications that run outside of Amazon Web Services to obtain temporary Amazon Web Services credentials. Your workloads can use the same IAM policies and roles you have for native Amazon Web Services applications to access Amazon Web Services resources. Using IAM Roles Anywhere eliminates the need to manage long-term credentials for workloads running outside of Amazon Web Services.
 *
 *  To use IAM Roles Anywhere, your workloads must use X.509 certificates issued by their certificate authority (CA). You register the CA with IAM Roles Anywhere as a trust anchor to establish trust between your public key infrastructure (PKI) and IAM Roles Anywhere. If you don't manage your own PKI system, you can use Private Certificate Authority to create a CA and then use that to establish trust with IAM Roles Anywhere.
 *
 * This guide describes the IAM Roles Anywhere operations that you can call programmatically. For more information about IAM Roles Anywhere, see the [IAM Roles Anywhere User Guide](https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html).
 */
public interface RolesAnywhereClient : SdkClient {
    /**
     * RolesAnywhereClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, RolesAnywhereClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, RolesAnywhereClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): RolesAnywhereClient = DefaultRolesAnywhereClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "RolesAnywhere"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a *profile*, a list of the roles that Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.
     *
     * **Required permissions: **`rolesanywhere:CreateProfile`.
     */
    public suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Creates a trust anchor to establish trust between IAM Roles Anywhere and your certificate authority (CA). You can define a trust anchor as a reference to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads can authenticate with the trust anchor using certificates issued by the CA in exchange for temporary Amazon Web Services credentials.
     *
     * **Required permissions: **`rolesanywhere:CreateTrustAnchor`.
     */
    public suspend fun createTrustAnchor(input: CreateTrustAnchorRequest): CreateTrustAnchorResponse

    /**
     * Deletes a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:DeleteCrl`.
     */
    public suspend fun deleteCrl(input: DeleteCrlRequest): DeleteCrlResponse

    /**
     * Deletes a profile.
     *
     * **Required permissions: **`rolesanywhere:DeleteProfile`.
     */
    public suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Deletes a trust anchor.
     *
     * **Required permissions: **`rolesanywhere:DeleteTrustAnchor`.
     */
    public suspend fun deleteTrustAnchor(input: DeleteTrustAnchorRequest): DeleteTrustAnchorResponse

    /**
     * Disables a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:DisableCrl`.
     */
    public suspend fun disableCrl(input: DisableCrlRequest): DisableCrlResponse

    /**
     * Disables a profile. When disabled, temporary credential requests with this profile fail.
     *
     * **Required permissions: **`rolesanywhere:DisableProfile`.
     */
    public suspend fun disableProfile(input: DisableProfileRequest): DisableProfileResponse

    /**
     * Disables a trust anchor. When disabled, temporary credential requests specifying this trust anchor are unauthorized.
     *
     * **Required permissions: **`rolesanywhere:DisableTrustAnchor`.
     */
    public suspend fun disableTrustAnchor(input: DisableTrustAnchorRequest): DisableTrustAnchorResponse

    /**
     * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.
     *
     * **Required permissions: **`rolesanywhere:EnableCrl`.
     */
    public suspend fun enableCrl(input: EnableCrlRequest): EnableCrlResponse

    /**
     * Enables temporary credential requests for a profile.
     *
     * **Required permissions: **`rolesanywhere:EnableProfile`.
     */
    public suspend fun enableProfile(input: EnableProfileRequest): EnableProfileResponse

    /**
     * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
     *
     * **Required permissions: **`rolesanywhere:EnableTrustAnchor`.
     */
    public suspend fun enableTrustAnchor(input: EnableTrustAnchorRequest): EnableTrustAnchorResponse

    /**
     * Gets a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:GetCrl`.
     */
    public suspend fun getCrl(input: GetCrlRequest): GetCrlResponse

    /**
     * Gets a profile.
     *
     * **Required permissions: **`rolesanywhere:GetProfile`.
     */
    public suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Gets a *subject*, which associates a certificate identity with authentication attempts. The subject stores auditing information such as the status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication.
     *
     * **Required permissions: **`rolesanywhere:GetSubject`.
     */
    public suspend fun getSubject(input: GetSubjectRequest): GetSubjectResponse

    /**
     * Gets a trust anchor.
     *
     * **Required permissions: **`rolesanywhere:GetTrustAnchor`.
     */
    public suspend fun getTrustAnchor(input: GetTrustAnchorRequest): GetTrustAnchorResponse

    /**
     * Imports the certificate revocation list (CRL). A CRL is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the CRL before issuing credentials.
     *
     * **Required permissions: **`rolesanywhere:ImportCrl`.
     */
    public suspend fun importCrl(input: ImportCrlRequest): ImportCrlResponse

    /**
     * Lists all certificate revocation lists (CRL) in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListCrls`.
     */
    public suspend fun listCrls(input: ListCrlsRequest = ListCrlsRequest {}): ListCrlsResponse

    /**
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListProfiles`.
     */
    public suspend fun listProfiles(input: ListProfilesRequest = ListProfilesRequest {}): ListProfilesResponse

    /**
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListSubjects`.
     */
    public suspend fun listSubjects(input: ListSubjectsRequest = ListSubjectsRequest {}): ListSubjectsResponse

    /**
     * Lists the tags attached to the resource.
     *
     * **Required permissions: **`rolesanywhere:ListTagsForResource`.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListTrustAnchors`.
     */
    public suspend fun listTrustAnchors(input: ListTrustAnchorsRequest = ListTrustAnchorsRequest {}): ListTrustAnchorsResponse

    /**
     * Attaches a list of *notification settings* to a trust anchor.
     *
     * A notification setting includes information such as event name, threshold, status of the notification setting, and the channel to notify.
     *
     * **Required permissions: **`rolesanywhere:PutNotificationSettings`.
     */
    public suspend fun putNotificationSettings(input: PutNotificationSettingsRequest): PutNotificationSettingsResponse

    /**
     * Resets the *custom notification setting* to IAM Roles Anywhere default setting.
     *
     * **Required permissions: **`rolesanywhere:ResetNotificationSettings`.
     */
    public suspend fun resetNotificationSettings(input: ResetNotificationSettingsRequest): ResetNotificationSettingsResponse

    /**
     * Attaches tags to a resource.
     *
     * **Required permissions: **`rolesanywhere:TagResource`.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the resource.
     *
     * **Required permissions: **`rolesanywhere:UntagResource`.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the certificate revocation list (CRL). A CRL is a list of certificates that have been revoked by the issuing certificate authority (CA). IAM Roles Anywhere validates against the CRL before issuing credentials.
     *
     * **Required permissions: **`rolesanywhere:UpdateCrl`.
     */
    public suspend fun updateCrl(input: UpdateCrlRequest): UpdateCrlResponse

    /**
     * Updates a *profile*, a list of the roles that IAM Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.
     *
     * **Required permissions: **`rolesanywhere:UpdateProfile`.
     */
    public suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse

    /**
     * Updates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. You can define a trust anchor as a reference to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads can authenticate with the trust anchor using certificates issued by the CA in exchange for temporary Amazon Web Services credentials.
     *
     * **Required permissions: **`rolesanywhere:UpdateTrustAnchor`.
     */
    public suspend fun updateTrustAnchor(input: UpdateTrustAnchorRequest): UpdateTrustAnchorResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun RolesAnywhereClient.withConfig(block: RolesAnywhereClient.Config.Builder.() -> Unit): RolesAnywhereClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRolesAnywhereClient(newConfig)
}

/**
 * Creates a *profile*, a list of the roles that Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.
 *
 * **Required permissions: **`rolesanywhere:CreateProfile`.
 */
public suspend inline fun RolesAnywhereClient.createProfile(crossinline block: CreateProfileRequest.Builder.() -> Unit): CreateProfileResponse = createProfile(CreateProfileRequest.Builder().apply(block).build())

/**
 * Creates a trust anchor to establish trust between IAM Roles Anywhere and your certificate authority (CA). You can define a trust anchor as a reference to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads can authenticate with the trust anchor using certificates issued by the CA in exchange for temporary Amazon Web Services credentials.
 *
 * **Required permissions: **`rolesanywhere:CreateTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.createTrustAnchor(crossinline block: CreateTrustAnchorRequest.Builder.() -> Unit): CreateTrustAnchorResponse = createTrustAnchor(CreateTrustAnchorRequest.Builder().apply(block).build())

/**
 * Deletes a certificate revocation list (CRL).
 *
 * **Required permissions: **`rolesanywhere:DeleteCrl`.
 */
public suspend inline fun RolesAnywhereClient.deleteCrl(crossinline block: DeleteCrlRequest.Builder.() -> Unit): DeleteCrlResponse = deleteCrl(DeleteCrlRequest.Builder().apply(block).build())

/**
 * Deletes a profile.
 *
 * **Required permissions: **`rolesanywhere:DeleteProfile`.
 */
public suspend inline fun RolesAnywhereClient.deleteProfile(crossinline block: DeleteProfileRequest.Builder.() -> Unit): DeleteProfileResponse = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

/**
 * Deletes a trust anchor.
 *
 * **Required permissions: **`rolesanywhere:DeleteTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.deleteTrustAnchor(crossinline block: DeleteTrustAnchorRequest.Builder.() -> Unit): DeleteTrustAnchorResponse = deleteTrustAnchor(DeleteTrustAnchorRequest.Builder().apply(block).build())

/**
 * Disables a certificate revocation list (CRL).
 *
 * **Required permissions: **`rolesanywhere:DisableCrl`.
 */
public suspend inline fun RolesAnywhereClient.disableCrl(crossinline block: DisableCrlRequest.Builder.() -> Unit): DisableCrlResponse = disableCrl(DisableCrlRequest.Builder().apply(block).build())

/**
 * Disables a profile. When disabled, temporary credential requests with this profile fail.
 *
 * **Required permissions: **`rolesanywhere:DisableProfile`.
 */
public suspend inline fun RolesAnywhereClient.disableProfile(crossinline block: DisableProfileRequest.Builder.() -> Unit): DisableProfileResponse = disableProfile(DisableProfileRequest.Builder().apply(block).build())

/**
 * Disables a trust anchor. When disabled, temporary credential requests specifying this trust anchor are unauthorized.
 *
 * **Required permissions: **`rolesanywhere:DisableTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.disableTrustAnchor(crossinline block: DisableTrustAnchorRequest.Builder.() -> Unit): DisableTrustAnchorResponse = disableTrustAnchor(DisableTrustAnchorRequest.Builder().apply(block).build())

/**
 * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.
 *
 * **Required permissions: **`rolesanywhere:EnableCrl`.
 */
public suspend inline fun RolesAnywhereClient.enableCrl(crossinline block: EnableCrlRequest.Builder.() -> Unit): EnableCrlResponse = enableCrl(EnableCrlRequest.Builder().apply(block).build())

/**
 * Enables temporary credential requests for a profile.
 *
 * **Required permissions: **`rolesanywhere:EnableProfile`.
 */
public suspend inline fun RolesAnywhereClient.enableProfile(crossinline block: EnableProfileRequest.Builder.() -> Unit): EnableProfileResponse = enableProfile(EnableProfileRequest.Builder().apply(block).build())

/**
 * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
 *
 * **Required permissions: **`rolesanywhere:EnableTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.enableTrustAnchor(crossinline block: EnableTrustAnchorRequest.Builder.() -> Unit): EnableTrustAnchorResponse = enableTrustAnchor(EnableTrustAnchorRequest.Builder().apply(block).build())

/**
 * Gets a certificate revocation list (CRL).
 *
 * **Required permissions: **`rolesanywhere:GetCrl`.
 */
public suspend inline fun RolesAnywhereClient.getCrl(crossinline block: GetCrlRequest.Builder.() -> Unit): GetCrlResponse = getCrl(GetCrlRequest.Builder().apply(block).build())

/**
 * Gets a profile.
 *
 * **Required permissions: **`rolesanywhere:GetProfile`.
 */
public suspend inline fun RolesAnywhereClient.getProfile(crossinline block: GetProfileRequest.Builder.() -> Unit): GetProfileResponse = getProfile(GetProfileRequest.Builder().apply(block).build())

/**
 * Gets a *subject*, which associates a certificate identity with authentication attempts. The subject stores auditing information such as the status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication.
 *
 * **Required permissions: **`rolesanywhere:GetSubject`.
 */
public suspend inline fun RolesAnywhereClient.getSubject(crossinline block: GetSubjectRequest.Builder.() -> Unit): GetSubjectResponse = getSubject(GetSubjectRequest.Builder().apply(block).build())

/**
 * Gets a trust anchor.
 *
 * **Required permissions: **`rolesanywhere:GetTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.getTrustAnchor(crossinline block: GetTrustAnchorRequest.Builder.() -> Unit): GetTrustAnchorResponse = getTrustAnchor(GetTrustAnchorRequest.Builder().apply(block).build())

/**
 * Imports the certificate revocation list (CRL). A CRL is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the CRL before issuing credentials.
 *
 * **Required permissions: **`rolesanywhere:ImportCrl`.
 */
public suspend inline fun RolesAnywhereClient.importCrl(crossinline block: ImportCrlRequest.Builder.() -> Unit): ImportCrlResponse = importCrl(ImportCrlRequest.Builder().apply(block).build())

/**
 * Lists all certificate revocation lists (CRL) in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListCrls`.
 */
public suspend inline fun RolesAnywhereClient.listCrls(crossinline block: ListCrlsRequest.Builder.() -> Unit): ListCrlsResponse = listCrls(ListCrlsRequest.Builder().apply(block).build())

/**
 * Lists all profiles in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListProfiles`.
 */
public suspend inline fun RolesAnywhereClient.listProfiles(crossinline block: ListProfilesRequest.Builder.() -> Unit): ListProfilesResponse = listProfiles(ListProfilesRequest.Builder().apply(block).build())

/**
 * Lists the subjects in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListSubjects`.
 */
public suspend inline fun RolesAnywhereClient.listSubjects(crossinline block: ListSubjectsRequest.Builder.() -> Unit): ListSubjectsResponse = listSubjects(ListSubjectsRequest.Builder().apply(block).build())

/**
 * Lists the tags attached to the resource.
 *
 * **Required permissions: **`rolesanywhere:ListTagsForResource`.
 */
public suspend inline fun RolesAnywhereClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListTrustAnchors`.
 */
public suspend inline fun RolesAnywhereClient.listTrustAnchors(crossinline block: ListTrustAnchorsRequest.Builder.() -> Unit): ListTrustAnchorsResponse = listTrustAnchors(ListTrustAnchorsRequest.Builder().apply(block).build())

/**
 * Attaches a list of *notification settings* to a trust anchor.
 *
 * A notification setting includes information such as event name, threshold, status of the notification setting, and the channel to notify.
 *
 * **Required permissions: **`rolesanywhere:PutNotificationSettings`.
 */
public suspend inline fun RolesAnywhereClient.putNotificationSettings(crossinline block: PutNotificationSettingsRequest.Builder.() -> Unit): PutNotificationSettingsResponse = putNotificationSettings(PutNotificationSettingsRequest.Builder().apply(block).build())

/**
 * Resets the *custom notification setting* to IAM Roles Anywhere default setting.
 *
 * **Required permissions: **`rolesanywhere:ResetNotificationSettings`.
 */
public suspend inline fun RolesAnywhereClient.resetNotificationSettings(crossinline block: ResetNotificationSettingsRequest.Builder.() -> Unit): ResetNotificationSettingsResponse = resetNotificationSettings(ResetNotificationSettingsRequest.Builder().apply(block).build())

/**
 * Attaches tags to a resource.
 *
 * **Required permissions: **`rolesanywhere:TagResource`.
 */
public suspend inline fun RolesAnywhereClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource.
 *
 * **Required permissions: **`rolesanywhere:UntagResource`.
 */
public suspend inline fun RolesAnywhereClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the certificate revocation list (CRL). A CRL is a list of certificates that have been revoked by the issuing certificate authority (CA). IAM Roles Anywhere validates against the CRL before issuing credentials.
 *
 * **Required permissions: **`rolesanywhere:UpdateCrl`.
 */
public suspend inline fun RolesAnywhereClient.updateCrl(crossinline block: UpdateCrlRequest.Builder.() -> Unit): UpdateCrlResponse = updateCrl(UpdateCrlRequest.Builder().apply(block).build())

/**
 * Updates a *profile*, a list of the roles that IAM Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.
 *
 * **Required permissions: **`rolesanywhere:UpdateProfile`.
 */
public suspend inline fun RolesAnywhereClient.updateProfile(crossinline block: UpdateProfileRequest.Builder.() -> Unit): UpdateProfileResponse = updateProfile(UpdateProfileRequest.Builder().apply(block).build())

/**
 * Updates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. You can define a trust anchor as a reference to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads can authenticate with the trust anchor using certificates issued by the CA in exchange for temporary Amazon Web Services credentials.
 *
 * **Required permissions: **`rolesanywhere:UpdateTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.updateTrustAnchor(crossinline block: UpdateTrustAnchorRequest.Builder.() -> Unit): UpdateTrustAnchorResponse = updateTrustAnchor(UpdateTrustAnchorRequest.Builder().apply(block).build())
