// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The state of the certificate revocation list (CRL) after a read or write operation.
 */
public class CrlDetail private constructor(builder: Builder) {
    /**
     * The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ARN of the certificate revocation list (CRL).
     */
    public val crlArn: kotlin.String? = builder.crlArn
    /**
     * The state of the certificate revocation list (CRL) after a read or write operation.
     */
    public val crlData: kotlin.ByteArray? = builder.crlData
    /**
     * The unique identifier of the certificate revocation list (CRL).
     */
    public val crlId: kotlin.String? = builder.crlId
    /**
     * Indicates whether the certificate revocation list (CRL) is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The name of the certificate revocation list (CRL).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
     */
    public val trustAnchorArn: kotlin.String? = builder.trustAnchorArn
    /**
     * The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rolesanywhere.model.CrlDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CrlDetail(")
        append("createdAt=$createdAt,")
        append("crlArn=$crlArn,")
        append("crlData=$crlData,")
        append("crlId=$crlId,")
        append("enabled=$enabled,")
        append("name=$name,")
        append("trustAnchorArn=$trustAnchorArn,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (crlArn?.hashCode() ?: 0)
        result = 31 * result + (crlData?.contentHashCode() ?: 0)
        result = 31 * result + (crlId?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (trustAnchorArn?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CrlDetail

        if (createdAt != other.createdAt) return false
        if (crlArn != other.crlArn) return false
        if (crlData != null) {
            if (other.crlData == null) return false
            if (!crlData.contentEquals(other.crlData)) return false
        } else if (other.crlData != null) return false
        if (crlId != other.crlId) return false
        if (enabled != other.enabled) return false
        if (name != other.name) return false
        if (trustAnchorArn != other.trustAnchorArn) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rolesanywhere.model.CrlDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the certificate revocation list (CRL).
         */
        public var crlArn: kotlin.String? = null
        /**
         * The state of the certificate revocation list (CRL) after a read or write operation.
         */
        public var crlData: kotlin.ByteArray? = null
        /**
         * The unique identifier of the certificate revocation list (CRL).
         */
        public var crlId: kotlin.String? = null
        /**
         * Indicates whether the certificate revocation list (CRL) is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The name of the certificate revocation list (CRL).
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
         */
        public var trustAnchorArn: kotlin.String? = null
        /**
         * The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rolesanywhere.model.CrlDetail) : this() {
            this.createdAt = x.createdAt
            this.crlArn = x.crlArn
            this.crlData = x.crlData
            this.crlId = x.crlId
            this.enabled = x.enabled
            this.name = x.name
            this.trustAnchorArn = x.trustAnchorArn
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rolesanywhere.model.CrlDetail = CrlDetail(this)
    }
}
