// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A record of a presented X509 credential to [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html).
 */
public class CredentialSummary private constructor(builder: Builder) {
    /**
     * Indicates whether the credential is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Indicates whether the [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) operation was successful.
     */
    public val failed: kotlin.Boolean? = builder.failed
    /**
     * The fully qualified domain name of the issuing certificate for the presented end-entity certificate.
     */
    public val issuer: kotlin.String? = builder.issuer
    /**
     * The ISO-8601 time stamp of when the certificate was last used in a [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) operation.
     */
    public val seenAt: aws.smithy.kotlin.runtime.time.Instant? = builder.seenAt
    /**
     * The serial number of the certificate.
     */
    public val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The PEM-encoded data of the certificate.
     */
    public val x509CertificateData: kotlin.String? = builder.x509CertificateData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rolesanywhere.model.CredentialSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CredentialSummary(")
        append("enabled=$enabled,")
        append("failed=$failed,")
        append("issuer=$issuer,")
        append("seenAt=$seenAt,")
        append("serialNumber=$serialNumber,")
        append("x509CertificateData=$x509CertificateData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (failed?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (seenAt?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (x509CertificateData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CredentialSummary

        if (enabled != other.enabled) return false
        if (failed != other.failed) return false
        if (issuer != other.issuer) return false
        if (seenAt != other.seenAt) return false
        if (serialNumber != other.serialNumber) return false
        if (x509CertificateData != other.x509CertificateData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rolesanywhere.model.CredentialSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the credential is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Indicates whether the [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) operation was successful.
         */
        public var failed: kotlin.Boolean? = null
        /**
         * The fully qualified domain name of the issuing certificate for the presented end-entity certificate.
         */
        public var issuer: kotlin.String? = null
        /**
         * The ISO-8601 time stamp of when the certificate was last used in a [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) operation.
         */
        public var seenAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number of the certificate.
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The PEM-encoded data of the certificate.
         */
        public var x509CertificateData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rolesanywhere.model.CredentialSummary) : this() {
            this.enabled = x.enabled
            this.failed = x.failed
            this.issuer = x.issuer
            this.seenAt = x.seenAt
            this.serialNumber = x.serialNumber
            this.x509CertificateData = x.x509CertificateData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rolesanywhere.model.CredentialSummary = CredentialSummary(this)
    }
}
