// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.rolesanywhere.model.CrlDetail
import aws.sdk.kotlin.services.rolesanywhere.model.DisableCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.RolesAnywhereException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DisableCrlOperationDeserializer: HttpDeserialize<DisableCrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisableCrlResponse {
        if (!response.status.isSuccess()) {
            throwDisableCrlError(context, response)
        }
        val builder = DisableCrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisableCrlOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDisableCrlError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RolesAnywhereException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RolesAnywhereException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisableCrlOperationBody(builder: DisableCrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CRL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("crl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CRL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CRL_DESCRIPTOR.index -> builder.crl = deserializeCrlDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
