// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The state of the profile after a read or write operation.
 */
public class ProfileDetail private constructor(builder: Builder) {
    /**
     * The ISO-8601 timestamp when the profile was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Web Services account that created the profile.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The number of seconds the vended session credentials are valid for.
     */
    public val durationSeconds: kotlin.Int? = builder.durationSeconds
    /**
     * Indicates whether the profile is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A list of managed policy ARNs that apply to the vended session credentials.
     */
    public val managedPolicyArns: List<String>? = builder.managedPolicyArns
    /**
     * The name of the profile.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the profile.
     */
    public val profileArn: kotlin.String? = builder.profileArn
    /**
     * The unique identifier of the profile.
     */
    public val profileId: kotlin.String? = builder.profileId
    /**
     * Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
     */
    public val requireInstanceProperties: kotlin.Boolean? = builder.requireInstanceProperties
    /**
     * A list of IAM roles that this profile can assume in a [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) operation.
     */
    public val roleArns: List<String>? = builder.roleArns
    /**
     * A session policy that applies to the trust boundary of the vended session credentials.
     */
    public val sessionPolicy: kotlin.String? = builder.sessionPolicy
    /**
     * The ISO-8601 timestamp when the profile was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rolesanywhere.model.ProfileDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProfileDetail(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("durationSeconds=$durationSeconds,")
        append("enabled=$enabled,")
        append("managedPolicyArns=$managedPolicyArns,")
        append("name=$name,")
        append("profileArn=$profileArn,")
        append("profileId=$profileId,")
        append("requireInstanceProperties=$requireInstanceProperties,")
        append("roleArns=$roleArns,")
        append("sessionPolicy=$sessionPolicy,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (durationSeconds ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (managedPolicyArns?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (profileArn?.hashCode() ?: 0)
        result = 31 * result + (profileId?.hashCode() ?: 0)
        result = 31 * result + (requireInstanceProperties?.hashCode() ?: 0)
        result = 31 * result + (roleArns?.hashCode() ?: 0)
        result = 31 * result + (sessionPolicy?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProfileDetail

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (durationSeconds != other.durationSeconds) return false
        if (enabled != other.enabled) return false
        if (managedPolicyArns != other.managedPolicyArns) return false
        if (name != other.name) return false
        if (profileArn != other.profileArn) return false
        if (profileId != other.profileId) return false
        if (requireInstanceProperties != other.requireInstanceProperties) return false
        if (roleArns != other.roleArns) return false
        if (sessionPolicy != other.sessionPolicy) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rolesanywhere.model.ProfileDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ISO-8601 timestamp when the profile was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services account that created the profile.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The number of seconds the vended session credentials are valid for.
         */
        public var durationSeconds: kotlin.Int? = null
        /**
         * Indicates whether the profile is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A list of managed policy ARNs that apply to the vended session credentials.
         */
        public var managedPolicyArns: List<String>? = null
        /**
         * The name of the profile.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the profile.
         */
        public var profileArn: kotlin.String? = null
        /**
         * The unique identifier of the profile.
         */
        public var profileId: kotlin.String? = null
        /**
         * Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
         */
        public var requireInstanceProperties: kotlin.Boolean? = null
        /**
         * A list of IAM roles that this profile can assume in a [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) operation.
         */
        public var roleArns: List<String>? = null
        /**
         * A session policy that applies to the trust boundary of the vended session credentials.
         */
        public var sessionPolicy: kotlin.String? = null
        /**
         * The ISO-8601 timestamp when the profile was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rolesanywhere.model.ProfileDetail) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.durationSeconds = x.durationSeconds
            this.enabled = x.enabled
            this.managedPolicyArns = x.managedPolicyArns
            this.name = x.name
            this.profileArn = x.profileArn
            this.profileId = x.profileId
            this.requireInstanceProperties = x.requireInstanceProperties
            this.roleArns = x.roleArns
            this.sessionPolicy = x.sessionPolicy
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rolesanywhere.model.ProfileDetail = ProfileDetail(this)
    }
}
