// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.rolesanywhere.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.rolesanywhere.model.*
import aws.sdk.kotlin.services.rolesanywhere.model.CreateProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.CreateProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.CreateTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.CreateTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DeleteTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DisableCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DisableCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DisableProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DisableProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.DisableTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.DisableTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.EnableCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.EnableCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.EnableProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.EnableProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.EnableTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.EnableTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetSubjectRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetSubjectResponse
import aws.sdk.kotlin.services.rolesanywhere.model.GetTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.GetTrustAnchorResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ImportCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ImportCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListCrlsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListCrlsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListProfilesRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListProfilesResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListSubjectsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListSubjectsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.rolesanywhere.model.ListTrustAnchorsRequest
import aws.sdk.kotlin.services.rolesanywhere.model.ListTrustAnchorsResponse
import aws.sdk.kotlin.services.rolesanywhere.model.TagResourceRequest
import aws.sdk.kotlin.services.rolesanywhere.model.TagResourceResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UntagResourceRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UntagResourceResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateCrlRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateCrlResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateProfileRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateProfileResponse
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateTrustAnchorRequest
import aws.sdk.kotlin.services.rolesanywhere.model.UpdateTrustAnchorResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Identity and Access Management Roles Anywhere provides a secure way for your workloads such as servers, containers, and applications running outside of AWS to obtain Temporary AWS credentials. Your workloads can use the same IAM policies and roles that you have configured with native AWS applications to access AWS resources. Using IAM Roles Anywhere will eliminate the need to manage long term credentials for workloads running outside of AWS.
 *
 * To use IAM Roles Anywhere customer workloads will need to use X.509 certificates issued by their Certificate Authority (CA) . The Certificate Authority (CA) needs to be registered with IAM Roles Anywhere as a trust anchor to establish trust between customer PKI and IAM Roles Anywhere. Customers who do not manage their own PKI system can use AWS Certificate Manager Private Certificate Authority (ACM PCA) to create a Certificate Authority and use that to establish trust with IAM Roles Anywhere
 *
 * This guide describes the IAM rolesanywhere operations that you can call programmatically. For general information about IAM Roles Anywhere see [https://docs.aws.amazon.com/](https://docs.aws.amazon.com/)
 */
public interface RolesAnywhereClient : SdkClient {

    override val serviceName: String
        get() = "RolesAnywhere"
    /**
     * RolesAnywhereClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): RolesAnywhereClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRolesAnywhereClient(config)
        }

        public operator fun invoke(config: Config): RolesAnywhereClient = DefaultRolesAnywhereClient(config)

        /**
         * Construct a [RolesAnywhereClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RolesAnywhereClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultRolesAnywhereClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.
     *
     * **Required permissions: **`rolesanywhere:CreateProfile`.
     */
    public suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Creates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
     *
     * **Required permissions: **`rolesanywhere:CreateTrustAnchor`.
     */
    public suspend fun createTrustAnchor(input: CreateTrustAnchorRequest): CreateTrustAnchorResponse

    /**
     * Deletes a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:DeleteCrl`.
     */
    public suspend fun deleteCrl(input: DeleteCrlRequest): DeleteCrlResponse

    /**
     * Deletes a profile.
     *
     * **Required permissions: **`rolesanywhere:DeleteProfile`.
     */
    public suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Deletes a trust anchor.
     *
     * **Required permissions: **`rolesanywhere:DeleteTrustAnchor`.
     */
    public suspend fun deleteTrustAnchor(input: DeleteTrustAnchorRequest): DeleteTrustAnchorResponse

    /**
     * Disables a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:DisableCrl`.
     */
    public suspend fun disableCrl(input: DisableCrlRequest): DisableCrlResponse

    /**
     * Disables a profile. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile fail.
     *
     * **Required permissions: **`rolesanywhere:DisableProfile`.
     */
    public suspend fun disableProfile(input: DisableProfileRequest): DisableProfileResponse

    /**
     * Disables a trust anchor. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests specifying this trust anchor are unauthorized.
     *
     * **Required permissions: **`rolesanywhere:DisableTrustAnchor`.
     */
    public suspend fun disableTrustAnchor(input: DisableTrustAnchorRequest): DisableTrustAnchorResponse

    /**
     * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.
     *
     * **Required permissions: **`rolesanywhere:EnableCrl`.
     */
    public suspend fun enableCrl(input: EnableCrlRequest): EnableCrlResponse

    /**
     * Enables the roles in a profile to receive session credentials in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html).
     *
     * **Required permissions: **`rolesanywhere:EnableProfile`.
     */
    public suspend fun enableProfile(input: EnableProfileRequest): EnableProfileResponse

    /**
     * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
     *
     * **Required permissions: **`rolesanywhere:EnableTrustAnchor`.
     */
    public suspend fun enableTrustAnchor(input: EnableTrustAnchorRequest): EnableTrustAnchorResponse

    /**
     * Gets a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:GetCrl`.
     */
    public suspend fun getCrl(input: GetCrlRequest): GetCrlResponse

    /**
     * Gets a profile.
     *
     * **Required permissions: **`rolesanywhere:GetProfile`.
     */
    public suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Gets a Subject. A Subject associates a certificate identity with authentication attempts by CreateSession. The Subject resources stores audit information such as status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication.
     *
     * **Required permissions: **`rolesanywhere:GetSubject`.
     */
    public suspend fun getSubject(input: GetSubjectRequest): GetSubjectResponse

    /**
     * Gets a trust anchor.
     *
     * **Required permissions: **`rolesanywhere:GetTrustAnchor`.
     */
    public suspend fun getTrustAnchor(input: GetTrustAnchorRequest): GetTrustAnchorResponse

    /**
     * Imports the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     *
     * **Required permissions: **`rolesanywhere:ImportCrl`.
     */
    public suspend fun importCrl(input: ImportCrlRequest): ImportCrlResponse

    /**
     * Lists all Crls in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListCrls`.
     */
    public suspend fun listCrls(input: ListCrlsRequest = ListCrlsRequest {}): ListCrlsResponse

    /**
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListProfiles`.
     */
    public suspend fun listProfiles(input: ListProfilesRequest = ListProfilesRequest {}): ListProfilesResponse

    /**
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListSubjects`.
     */
    public suspend fun listSubjects(input: ListSubjectsRequest = ListSubjectsRequest {}): ListSubjectsResponse

    /**
     * Lists the tags attached to the resource.
     *
     * **Required permissions: **`rolesanywhere:ListTagsForResource`.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListTrustAnchors`.
     */
    public suspend fun listTrustAnchors(input: ListTrustAnchorsRequest = ListTrustAnchorsRequest {}): ListTrustAnchorsResponse

    /**
     * Attaches tags to a resource.
     *
     * **Required permissions: **`rolesanywhere:TagResource`.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the resource.
     *
     * **Required permissions: **`rolesanywhere:UntagResource`.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     *
     * **Required permissions: **`rolesanywhere:UpdateCrl`.
     */
    public suspend fun updateCrl(input: UpdateCrlRequest): UpdateCrlResponse

    /**
     * Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.
     *
     * **Required permissions: **`rolesanywhere:UpdateProfile`.
     */
    public suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse

    /**
     * Updates the trust anchor.You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
     *
     * **Required permissions: **`rolesanywhere:UpdateTrustAnchor`.
     */
    public suspend fun updateTrustAnchor(input: UpdateTrustAnchorRequest): UpdateTrustAnchorResponse
}

/**
 * Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.
 *
 * **Required permissions: **`rolesanywhere:CreateProfile`.
 */
public suspend inline fun RolesAnywhereClient.createProfile(crossinline block: CreateProfileRequest.Builder.() -> Unit): CreateProfileResponse = createProfile(CreateProfileRequest.Builder().apply(block).build())

/**
 * Creates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
 *
 * **Required permissions: **`rolesanywhere:CreateTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.createTrustAnchor(crossinline block: CreateTrustAnchorRequest.Builder.() -> Unit): CreateTrustAnchorResponse = createTrustAnchor(CreateTrustAnchorRequest.Builder().apply(block).build())

/**
 * Deletes a certificate revocation list (CRL).
 *
 * **Required permissions: **`rolesanywhere:DeleteCrl`.
 */
public suspend inline fun RolesAnywhereClient.deleteCrl(crossinline block: DeleteCrlRequest.Builder.() -> Unit): DeleteCrlResponse = deleteCrl(DeleteCrlRequest.Builder().apply(block).build())

/**
 * Deletes a profile.
 *
 * **Required permissions: **`rolesanywhere:DeleteProfile`.
 */
public suspend inline fun RolesAnywhereClient.deleteProfile(crossinline block: DeleteProfileRequest.Builder.() -> Unit): DeleteProfileResponse = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

/**
 * Deletes a trust anchor.
 *
 * **Required permissions: **`rolesanywhere:DeleteTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.deleteTrustAnchor(crossinline block: DeleteTrustAnchorRequest.Builder.() -> Unit): DeleteTrustAnchorResponse = deleteTrustAnchor(DeleteTrustAnchorRequest.Builder().apply(block).build())

/**
 * Disables a certificate revocation list (CRL).
 *
 * **Required permissions: **`rolesanywhere:DisableCrl`.
 */
public suspend inline fun RolesAnywhereClient.disableCrl(crossinline block: DisableCrlRequest.Builder.() -> Unit): DisableCrlResponse = disableCrl(DisableCrlRequest.Builder().apply(block).build())

/**
 * Disables a profile. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile fail.
 *
 * **Required permissions: **`rolesanywhere:DisableProfile`.
 */
public suspend inline fun RolesAnywhereClient.disableProfile(crossinline block: DisableProfileRequest.Builder.() -> Unit): DisableProfileResponse = disableProfile(DisableProfileRequest.Builder().apply(block).build())

/**
 * Disables a trust anchor. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests specifying this trust anchor are unauthorized.
 *
 * **Required permissions: **`rolesanywhere:DisableTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.disableTrustAnchor(crossinline block: DisableTrustAnchorRequest.Builder.() -> Unit): DisableTrustAnchorResponse = disableTrustAnchor(DisableTrustAnchorRequest.Builder().apply(block).build())

/**
 * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.
 *
 * **Required permissions: **`rolesanywhere:EnableCrl`.
 */
public suspend inline fun RolesAnywhereClient.enableCrl(crossinline block: EnableCrlRequest.Builder.() -> Unit): EnableCrlResponse = enableCrl(EnableCrlRequest.Builder().apply(block).build())

/**
 * Enables the roles in a profile to receive session credentials in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html).
 *
 * **Required permissions: **`rolesanywhere:EnableProfile`.
 */
public suspend inline fun RolesAnywhereClient.enableProfile(crossinline block: EnableProfileRequest.Builder.() -> Unit): EnableProfileResponse = enableProfile(EnableProfileRequest.Builder().apply(block).build())

/**
 * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
 *
 * **Required permissions: **`rolesanywhere:EnableTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.enableTrustAnchor(crossinline block: EnableTrustAnchorRequest.Builder.() -> Unit): EnableTrustAnchorResponse = enableTrustAnchor(EnableTrustAnchorRequest.Builder().apply(block).build())

/**
 * Gets a certificate revocation list (CRL).
 *
 * **Required permissions: **`rolesanywhere:GetCrl`.
 */
public suspend inline fun RolesAnywhereClient.getCrl(crossinline block: GetCrlRequest.Builder.() -> Unit): GetCrlResponse = getCrl(GetCrlRequest.Builder().apply(block).build())

/**
 * Gets a profile.
 *
 * **Required permissions: **`rolesanywhere:GetProfile`.
 */
public suspend inline fun RolesAnywhereClient.getProfile(crossinline block: GetProfileRequest.Builder.() -> Unit): GetProfileResponse = getProfile(GetProfileRequest.Builder().apply(block).build())

/**
 * Gets a Subject. A Subject associates a certificate identity with authentication attempts by CreateSession. The Subject resources stores audit information such as status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication.
 *
 * **Required permissions: **`rolesanywhere:GetSubject`.
 */
public suspend inline fun RolesAnywhereClient.getSubject(crossinline block: GetSubjectRequest.Builder.() -> Unit): GetSubjectResponse = getSubject(GetSubjectRequest.Builder().apply(block).build())

/**
 * Gets a trust anchor.
 *
 * **Required permissions: **`rolesanywhere:GetTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.getTrustAnchor(crossinline block: GetTrustAnchorRequest.Builder.() -> Unit): GetTrustAnchorResponse = getTrustAnchor(GetTrustAnchorRequest.Builder().apply(block).build())

/**
 * Imports the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
 *
 * **Required permissions: **`rolesanywhere:ImportCrl`.
 */
public suspend inline fun RolesAnywhereClient.importCrl(crossinline block: ImportCrlRequest.Builder.() -> Unit): ImportCrlResponse = importCrl(ImportCrlRequest.Builder().apply(block).build())

/**
 * Lists all Crls in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListCrls`.
 */
public suspend inline fun RolesAnywhereClient.listCrls(crossinline block: ListCrlsRequest.Builder.() -> Unit): ListCrlsResponse = listCrls(ListCrlsRequest.Builder().apply(block).build())

/**
 * Lists all profiles in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListProfiles`.
 */
public suspend inline fun RolesAnywhereClient.listProfiles(crossinline block: ListProfilesRequest.Builder.() -> Unit): ListProfilesResponse = listProfiles(ListProfilesRequest.Builder().apply(block).build())

/**
 * Lists the subjects in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListSubjects`.
 */
public suspend inline fun RolesAnywhereClient.listSubjects(crossinline block: ListSubjectsRequest.Builder.() -> Unit): ListSubjectsResponse = listSubjects(ListSubjectsRequest.Builder().apply(block).build())

/**
 * Lists the tags attached to the resource.
 *
 * **Required permissions: **`rolesanywhere:ListTagsForResource`.
 */
public suspend inline fun RolesAnywhereClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
 *
 * **Required permissions: **`rolesanywhere:ListTrustAnchors`.
 */
public suspend inline fun RolesAnywhereClient.listTrustAnchors(crossinline block: ListTrustAnchorsRequest.Builder.() -> Unit): ListTrustAnchorsResponse = listTrustAnchors(ListTrustAnchorsRequest.Builder().apply(block).build())

/**
 * Attaches tags to a resource.
 *
 * **Required permissions: **`rolesanywhere:TagResource`.
 */
public suspend inline fun RolesAnywhereClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource.
 *
 * **Required permissions: **`rolesanywhere:UntagResource`.
 */
public suspend inline fun RolesAnywhereClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
 *
 * **Required permissions: **`rolesanywhere:UpdateCrl`.
 */
public suspend inline fun RolesAnywhereClient.updateCrl(crossinline block: UpdateCrlRequest.Builder.() -> Unit): UpdateCrlResponse = updateCrl(UpdateCrlRequest.Builder().apply(block).build())

/**
 * Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.
 *
 * **Required permissions: **`rolesanywhere:UpdateProfile`.
 */
public suspend inline fun RolesAnywhereClient.updateProfile(crossinline block: UpdateProfileRequest.Builder.() -> Unit): UpdateProfileResponse = updateProfile(UpdateProfileRequest.Builder().apply(block).build())

/**
 * Updates the trust anchor.You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
 *
 * **Required permissions: **`rolesanywhere:UpdateTrustAnchor`.
 */
public suspend inline fun RolesAnywhereClient.updateTrustAnchor(crossinline block: UpdateTrustAnchorRequest.Builder.() -> Unit): UpdateTrustAnchorResponse = updateTrustAnchor(UpdateTrustAnchorRequest.Builder().apply(block).build())
