// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rolesanywhere

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.rolesanywhere.model.*
import aws.sdk.kotlin.services.rolesanywhere.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "RolesAnywhere"
public const val ServiceApiVersion: String = "2018-05-10"
public const val SdkVersion: String = "0.17.11-beta"

internal class DefaultRolesAnywhereClient(override val config: RolesAnywhereClient.Config) : RolesAnywhereClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.
     *
     * **Required permissions: **`rolesanywhere:CreateProfile`.
     */
    override suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse {
        val op = SdkHttpOperation.build<CreateProfileRequest, CreateProfileResponse> {
            serializer = CreateProfileOperationSerializer()
            deserializer = CreateProfileOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
     *
     * **Required permissions: **`rolesanywhere:CreateTrustAnchor`.
     */
    override suspend fun createTrustAnchor(input: CreateTrustAnchorRequest): CreateTrustAnchorResponse {
        val op = SdkHttpOperation.build<CreateTrustAnchorRequest, CreateTrustAnchorResponse> {
            serializer = CreateTrustAnchorOperationSerializer()
            deserializer = CreateTrustAnchorOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateTrustAnchor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:DeleteCrl`.
     */
    override suspend fun deleteCrl(input: DeleteCrlRequest): DeleteCrlResponse {
        val op = SdkHttpOperation.build<DeleteCrlRequest, DeleteCrlResponse> {
            serializer = DeleteCrlOperationSerializer()
            deserializer = DeleteCrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a profile.
     *
     * **Required permissions: **`rolesanywhere:DeleteProfile`.
     */
    override suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse {
        val op = SdkHttpOperation.build<DeleteProfileRequest, DeleteProfileResponse> {
            serializer = DeleteProfileOperationSerializer()
            deserializer = DeleteProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a trust anchor.
     *
     * **Required permissions: **`rolesanywhere:DeleteTrustAnchor`.
     */
    override suspend fun deleteTrustAnchor(input: DeleteTrustAnchorRequest): DeleteTrustAnchorResponse {
        val op = SdkHttpOperation.build<DeleteTrustAnchorRequest, DeleteTrustAnchorResponse> {
            serializer = DeleteTrustAnchorOperationSerializer()
            deserializer = DeleteTrustAnchorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrustAnchor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:DisableCrl`.
     */
    override suspend fun disableCrl(input: DisableCrlRequest): DisableCrlResponse {
        val op = SdkHttpOperation.build<DisableCrlRequest, DisableCrlResponse> {
            serializer = DisableCrlOperationSerializer()
            deserializer = DisableCrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableCrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables a profile. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile fail.
     *
     * **Required permissions: **`rolesanywhere:DisableProfile`.
     */
    override suspend fun disableProfile(input: DisableProfileRequest): DisableProfileResponse {
        val op = SdkHttpOperation.build<DisableProfileRequest, DisableProfileResponse> {
            serializer = DisableProfileOperationSerializer()
            deserializer = DisableProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables a trust anchor. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests specifying this trust anchor are unauthorized.
     *
     * **Required permissions: **`rolesanywhere:DisableTrustAnchor`.
     */
    override suspend fun disableTrustAnchor(input: DisableTrustAnchorRequest): DisableTrustAnchorResponse {
        val op = SdkHttpOperation.build<DisableTrustAnchorRequest, DisableTrustAnchorResponse> {
            serializer = DisableTrustAnchorOperationSerializer()
            deserializer = DisableTrustAnchorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableTrustAnchor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.
     *
     * **Required permissions: **`rolesanywhere:EnableCrl`.
     */
    override suspend fun enableCrl(input: EnableCrlRequest): EnableCrlResponse {
        val op = SdkHttpOperation.build<EnableCrlRequest, EnableCrlResponse> {
            serializer = EnableCrlOperationSerializer()
            deserializer = EnableCrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableCrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the roles in a profile to receive session credentials in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html).
     *
     * **Required permissions: **`rolesanywhere:EnableProfile`.
     */
    override suspend fun enableProfile(input: EnableProfileRequest): EnableProfileResponse {
        val op = SdkHttpOperation.build<EnableProfileRequest, EnableProfileResponse> {
            serializer = EnableProfileOperationSerializer()
            deserializer = EnableProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
     *
     * **Required permissions: **`rolesanywhere:EnableTrustAnchor`.
     */
    override suspend fun enableTrustAnchor(input: EnableTrustAnchorRequest): EnableTrustAnchorResponse {
        val op = SdkHttpOperation.build<EnableTrustAnchorRequest, EnableTrustAnchorResponse> {
            serializer = EnableTrustAnchorOperationSerializer()
            deserializer = EnableTrustAnchorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableTrustAnchor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a certificate revocation list (CRL).
     *
     * **Required permissions: **`rolesanywhere:GetCrl`.
     */
    override suspend fun getCrl(input: GetCrlRequest): GetCrlResponse {
        val op = SdkHttpOperation.build<GetCrlRequest, GetCrlResponse> {
            serializer = GetCrlOperationSerializer()
            deserializer = GetCrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a profile.
     *
     * **Required permissions: **`rolesanywhere:GetProfile`.
     */
    override suspend fun getProfile(input: GetProfileRequest): GetProfileResponse {
        val op = SdkHttpOperation.build<GetProfileRequest, GetProfileResponse> {
            serializer = GetProfileOperationSerializer()
            deserializer = GetProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a Subject. A Subject associates a certificate identity with authentication attempts by CreateSession. The Subject resources stores audit information such as status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication.
     *
     * **Required permissions: **`rolesanywhere:GetSubject`.
     */
    override suspend fun getSubject(input: GetSubjectRequest): GetSubjectResponse {
        val op = SdkHttpOperation.build<GetSubjectRequest, GetSubjectResponse> {
            serializer = GetSubjectOperationSerializer()
            deserializer = GetSubjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSubject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a trust anchor.
     *
     * **Required permissions: **`rolesanywhere:GetTrustAnchor`.
     */
    override suspend fun getTrustAnchor(input: GetTrustAnchorRequest): GetTrustAnchorResponse {
        val op = SdkHttpOperation.build<GetTrustAnchorRequest, GetTrustAnchorResponse> {
            serializer = GetTrustAnchorOperationSerializer()
            deserializer = GetTrustAnchorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTrustAnchor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     *
     * **Required permissions: **`rolesanywhere:ImportCrl`.
     */
    override suspend fun importCrl(input: ImportCrlRequest): ImportCrlResponse {
        val op = SdkHttpOperation.build<ImportCrlRequest, ImportCrlResponse> {
            serializer = ImportCrlOperationSerializer()
            deserializer = ImportCrlOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "ImportCrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Crls in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListCrls`.
     */
    override suspend fun listCrls(input: ListCrlsRequest): ListCrlsResponse {
        val op = SdkHttpOperation.build<ListCrlsRequest, ListCrlsResponse> {
            serializer = ListCrlsOperationSerializer()
            deserializer = ListCrlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCrls"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all profiles in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListProfiles`.
     */
    override suspend fun listProfiles(input: ListProfilesRequest): ListProfilesResponse {
        val op = SdkHttpOperation.build<ListProfilesRequest, ListProfilesResponse> {
            serializer = ListProfilesOperationSerializer()
            deserializer = ListProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the subjects in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListSubjects`.
     */
    override suspend fun listSubjects(input: ListSubjectsRequest): ListSubjectsResponse {
        val op = SdkHttpOperation.build<ListSubjectsRequest, ListSubjectsResponse> {
            serializer = ListSubjectsOperationSerializer()
            deserializer = ListSubjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSubjects"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags attached to the resource.
     *
     * **Required permissions: **`rolesanywhere:ListTagsForResource`.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the trust anchors in the authenticated account and Amazon Web Services Region.
     *
     * **Required permissions: **`rolesanywhere:ListTrustAnchors`.
     */
    override suspend fun listTrustAnchors(input: ListTrustAnchorsRequest): ListTrustAnchorsResponse {
        val op = SdkHttpOperation.build<ListTrustAnchorsRequest, ListTrustAnchorsResponse> {
            serializer = ListTrustAnchorsOperationSerializer()
            deserializer = ListTrustAnchorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrustAnchors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches tags to a resource.
     *
     * **Required permissions: **`rolesanywhere:TagResource`.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from the resource.
     *
     * **Required permissions: **`rolesanywhere:UntagResource`.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
     *
     * **Required permissions: **`rolesanywhere:UpdateCrl`.
     */
    override suspend fun updateCrl(input: UpdateCrlRequest): UpdateCrlResponse {
        val op = SdkHttpOperation.build<UpdateCrlRequest, UpdateCrlResponse> {
            serializer = UpdateCrlOperationSerializer()
            deserializer = UpdateCrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.
     *
     * **Required permissions: **`rolesanywhere:UpdateProfile`.
     */
    override suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse {
        val op = SdkHttpOperation.build<UpdateProfileRequest, UpdateProfileResponse> {
            serializer = UpdateProfileOperationSerializer()
            deserializer = UpdateProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the trust anchor.You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
     *
     * **Required permissions: **`rolesanywhere:UpdateTrustAnchor`.
     */
    override suspend fun updateTrustAnchor(input: UpdateTrustAnchorRequest): UpdateTrustAnchorResponse {
        val op = SdkHttpOperation.build<UpdateTrustAnchorRequest, UpdateTrustAnchorResponse> {
            serializer = UpdateTrustAnchorOperationSerializer()
            deserializer = UpdateTrustAnchorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTrustAnchor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rolesanywhere"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "rolesanywhere")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
