// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.serde

import aws.sdk.kotlin.services.robomaker.model.BatchPolicy
import aws.sdk.kotlin.services.robomaker.model.FailedCreateSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.RoboMakerException
import aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchErrorCode
import aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchStatus
import aws.sdk.kotlin.services.robomaker.model.SimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.SimulationJobSummary
import aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class StartSimulationJobBatchOperationDeserializer: HttpDeserializer.NonStreaming<StartSimulationJobBatchResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartSimulationJobBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartSimulationJobBatchError(context, call, payload)
        }
        val builder = StartSimulationJobBatchResponse.Builder()

        if (payload != null) {
            deserializeStartSimulationJobBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartSimulationJobBatchError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RoboMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotentParameterMismatchException" -> IdempotentParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RoboMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartSimulationJobBatchOperationBody(builder: StartSimulationJobBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val BATCHPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("batchPolicy"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("createdRequests"))
    val FAILEDREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedRequests"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("failureCode"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val PENDINGREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pendingRequests"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(BATCHPOLICY_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDREQUESTS_DESCRIPTOR)
        field(FAILEDREQUESTS_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(PENDINGREQUESTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                BATCHPOLICY_DESCRIPTOR.index -> builder.batchPolicy = deserializeBatchPolicyDocument(deserializer)
                CLIENTREQUESTTOKEN_DESCRIPTOR.index -> builder.clientRequestToken = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATEDREQUESTS_DESCRIPTOR.index -> builder.createdRequests =
                    deserializer.deserializeList(CREATEDREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SimulationJobSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSimulationJobSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILEDREQUESTS_DESCRIPTOR.index -> builder.failedRequests =
                    deserializer.deserializeList(FAILEDREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedCreateSimulationJobRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedCreateSimulationJobRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString().let { SimulationJobBatchErrorCode.fromValue(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                PENDINGREQUESTS_DESCRIPTOR.index -> builder.pendingRequests =
                    deserializer.deserializeList(PENDINGREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SimulationJobRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSimulationJobRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SimulationJobBatchStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
