// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.serde

import aws.sdk.kotlin.services.robomaker.model.ComputeResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.DataSource
import aws.sdk.kotlin.services.robomaker.model.FailureBehavior
import aws.sdk.kotlin.services.robomaker.model.LoggingConfig
import aws.sdk.kotlin.services.robomaker.model.OutputLocation
import aws.sdk.kotlin.services.robomaker.model.RoboMakerException
import aws.sdk.kotlin.services.robomaker.model.RobotApplicationConfig
import aws.sdk.kotlin.services.robomaker.model.SimulationApplicationConfig
import aws.sdk.kotlin.services.robomaker.model.SimulationJobErrorCode
import aws.sdk.kotlin.services.robomaker.model.SimulationJobStatus
import aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class CreateSimulationJobOperationDeserializer: HttpDeserializer.NonStreaming<CreateSimulationJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateSimulationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateSimulationJobError(context, call, payload)
        }
        val builder = CreateSimulationJobResponse.Builder()

        if (payload != null) {
            deserializeCreateSimulationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateSimulationJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RoboMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotentParameterMismatchException" -> IdempotentParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RoboMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSimulationJobOperationBody(builder: CreateSimulationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val COMPUTE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("compute"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataSources"))
    val FAILUREBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("failureBehavior"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("failureCode"))
    val IAMROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iamRole"))
    val LASTSTARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStartedAt"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val LOGGINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loggingConfig"))
    val MAXJOBDURATIONINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("maxJobDurationInSeconds"))
    val OUTPUTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputLocation"))
    val ROBOTAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("robotApplications"))
    val SIMULATIONAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("simulationApplications"))
    val SIMULATIONTIMEMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("simulationTimeMillis"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(COMPUTE_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
        field(FAILUREBEHAVIOR_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(IAMROLE_DESCRIPTOR)
        field(LASTSTARTEDAT_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(LOGGINGCONFIG_DESCRIPTOR)
        field(MAXJOBDURATIONINSECONDS_DESCRIPTOR)
        field(OUTPUTLOCATION_DESCRIPTOR)
        field(ROBOTAPPLICATIONS_DESCRIPTOR)
        field(SIMULATIONAPPLICATIONS_DESCRIPTOR)
        field(SIMULATIONTIMEMILLIS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CLIENTREQUESTTOKEN_DESCRIPTOR.index -> builder.clientRequestToken = deserializeString()
                COMPUTE_DESCRIPTOR.index -> builder.compute = deserializeComputeResponseDocument(deserializer)
                DATASOURCES_DESCRIPTOR.index -> builder.dataSources =
                    deserializer.deserializeList(DATASOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<DataSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILUREBEHAVIOR_DESCRIPTOR.index -> builder.failureBehavior = deserializeString().let { FailureBehavior.fromValue(it) }
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString().let { SimulationJobErrorCode.fromValue(it) }
                IAMROLE_DESCRIPTOR.index -> builder.iamRole = deserializeString()
                LASTSTARTEDAT_DESCRIPTOR.index -> builder.lastStartedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOGGINGCONFIG_DESCRIPTOR.index -> builder.loggingConfig = deserializeLoggingConfigDocument(deserializer)
                MAXJOBDURATIONINSECONDS_DESCRIPTOR.index -> builder.maxJobDurationInSeconds = deserializeLong()
                OUTPUTLOCATION_DESCRIPTOR.index -> builder.outputLocation = deserializeOutputLocationDocument(deserializer)
                ROBOTAPPLICATIONS_DESCRIPTOR.index -> builder.robotApplications =
                    deserializer.deserializeList(ROBOTAPPLICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RobotApplicationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRobotApplicationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SIMULATIONAPPLICATIONS_DESCRIPTOR.index -> builder.simulationApplications =
                    deserializer.deserializeList(SIMULATIONAPPLICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<SimulationApplicationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSimulationApplicationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SIMULATIONTIMEMILLIS_DESCRIPTOR.index -> builder.simulationTimeMillis = deserializeLong()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SimulationJobStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
