// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides upload configuration information. Files are uploaded from the simulation job to a location you specify.
 */
public class UploadConfiguration private constructor(builder: Builder) {
    /**
     * A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output location to determine the final path.
     *
     *  For example, if your simulation output location is `s3://my-bucket` and your upload configuration name is `robot-test`, your files will be uploaded to `s3://my-bucket/<simid>/<runid>/robot-test`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of `**` as a *super asterisk*. For example, specifying `/var/log&#47;**.log` causes all .log files in the `/var/log` directory tree to be collected. For more examples, see [Glob Library](https://github.com/gobwas/glob).
     */
    public val path: kotlin.String = requireNotNull(builder.path) { "A non-null value must be provided for path" }
    /**
     * Specifies when to upload the files:
     *
     * ## UPLOAD_ON_TERMINATE
     * Matching files are uploaded once the simulation enters the `TERMINATING` state. Matching files are not uploaded until all of your code (including tools) have stopped.
     *
     * If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts will be made.
     *
     * ## UPLOAD_ROLLING_AUTO_REMOVE
     * Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped.
     */
    public val uploadBehavior: aws.sdk.kotlin.services.robomaker.model.UploadBehavior = requireNotNull(builder.uploadBehavior) { "A non-null value must be provided for uploadBehavior" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.UploadConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadConfiguration(")
        append("name=$name,")
        append("path=$path,")
        append("uploadBehavior=$uploadBehavior")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (path.hashCode())
        result = 31 * result + (uploadBehavior.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadConfiguration

        if (name != other.name) return false
        if (path != other.path) return false
        if (uploadBehavior != other.uploadBehavior) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.UploadConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output location to determine the final path.
         *
         *  For example, if your simulation output location is `s3://my-bucket` and your upload configuration name is `robot-test`, your files will be uploaded to `s3://my-bucket/<simid>/<runid>/robot-test`.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of `**` as a *super asterisk*. For example, specifying `/var/log&#47;**.log` causes all .log files in the `/var/log` directory tree to be collected. For more examples, see [Glob Library](https://github.com/gobwas/glob).
         */
        public var path: kotlin.String? = null
        /**
         * Specifies when to upload the files:
         *
         * ## UPLOAD_ON_TERMINATE
         * Matching files are uploaded once the simulation enters the `TERMINATING` state. Matching files are not uploaded until all of your code (including tools) have stopped.
         *
         * If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts will be made.
         *
         * ## UPLOAD_ROLLING_AUTO_REMOVE
         * Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped.
         */
        public var uploadBehavior: aws.sdk.kotlin.services.robomaker.model.UploadBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.UploadConfiguration) : this() {
            this.name = x.name
            this.path = x.path
            this.uploadBehavior = x.uploadBehavior
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.UploadConfiguration = UploadConfiguration(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (path == null) path = ""
            if (uploadBehavior == null) uploadBehavior = UploadBehavior.SdkUnknown("no value provided")
            return this
        }
    }
}
