// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a simulation job request.
 */
public class SimulationJobRequest private constructor(builder: Builder) {
    /**
     * Compute information for the simulation job
     */
    public val compute: aws.sdk.kotlin.services.robomaker.model.Compute? = builder.compute
    /**
     * Specify data sources to mount read-only files from S3 into your simulation. These files are available under `/opt/robomaker/datasources/data_source_name`.
     *
     * There is a limit of 100 files and a combined size of 25GB for all `DataSourceConfig` objects.
     */
    public val dataSources: List<DataSourceConfig>? = builder.dataSources
    /**
     * The failure behavior the simulation job.
     *
     * ## Continue
     * Leaves the host running for its maximum timeout duration after a `4XX` error code.
     *
     * ## Fail
     * Stop the simulation job and terminate the instance.
     */
    public val failureBehavior: aws.sdk.kotlin.services.robomaker.model.FailureBehavior? = builder.failureBehavior
    /**
     * The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * The logging configuration.
     */
    public val loggingConfig: aws.sdk.kotlin.services.robomaker.model.LoggingConfig? = builder.loggingConfig
    /**
     * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     */
    public val maxJobDurationInSeconds: kotlin.Long = builder.maxJobDurationInSeconds
    /**
     * The output location.
     */
    public val outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = builder.outputLocation
    /**
     * The robot applications to use in the simulation job.
     */
    public val robotApplications: List<RobotApplicationConfig>? = builder.robotApplications
    /**
     * The simulation applications to use in the simulation job.
     */
    public val simulationApplications: List<SimulationApplicationConfig>? = builder.simulationApplications
    /**
     * A map that contains tag keys and tag values that are attached to the simulation job request.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A Boolean indicating whether to use default applications in the simulation job. Default applications include Gazebo, rqt, rviz and terminal access.
     */
    public val useDefaultApplications: kotlin.Boolean? = builder.useDefaultApplications
    /**
     * If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.
     */
    public val vpcConfig: aws.sdk.kotlin.services.robomaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.SimulationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimulationJobRequest(")
        append("compute=$compute,")
        append("dataSources=$dataSources,")
        append("failureBehavior=$failureBehavior,")
        append("iamRole=$iamRole,")
        append("loggingConfig=$loggingConfig,")
        append("maxJobDurationInSeconds=$maxJobDurationInSeconds,")
        append("outputLocation=$outputLocation,")
        append("robotApplications=$robotApplications,")
        append("simulationApplications=$simulationApplications,")
        append("tags=$tags,")
        append("useDefaultApplications=$useDefaultApplications,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compute?.hashCode() ?: 0
        result = 31 * result + (dataSources?.hashCode() ?: 0)
        result = 31 * result + (failureBehavior?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (maxJobDurationInSeconds.hashCode())
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (robotApplications?.hashCode() ?: 0)
        result = 31 * result + (simulationApplications?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useDefaultApplications?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimulationJobRequest

        if (compute != other.compute) return false
        if (dataSources != other.dataSources) return false
        if (failureBehavior != other.failureBehavior) return false
        if (iamRole != other.iamRole) return false
        if (loggingConfig != other.loggingConfig) return false
        if (maxJobDurationInSeconds != other.maxJobDurationInSeconds) return false
        if (outputLocation != other.outputLocation) return false
        if (robotApplications != other.robotApplications) return false
        if (simulationApplications != other.simulationApplications) return false
        if (tags != other.tags) return false
        if (useDefaultApplications != other.useDefaultApplications) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.SimulationJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Compute information for the simulation job
         */
        public var compute: aws.sdk.kotlin.services.robomaker.model.Compute? = null
        /**
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under `/opt/robomaker/datasources/data_source_name`.
         *
         * There is a limit of 100 files and a combined size of 25GB for all `DataSourceConfig` objects.
         */
        public var dataSources: List<DataSourceConfig>? = null
        /**
         * The failure behavior the simulation job.
         *
         * ## Continue
         * Leaves the host running for its maximum timeout duration after a `4XX` error code.
         *
         * ## Fail
         * Stop the simulation job and terminate the instance.
         */
        public var failureBehavior: aws.sdk.kotlin.services.robomaker.model.FailureBehavior? = null
        /**
         * The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job.
         */
        public var iamRole: kotlin.String? = null
        /**
         * The logging configuration.
         */
        public var loggingConfig: aws.sdk.kotlin.services.robomaker.model.LoggingConfig? = null
        /**
         * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
         */
        public var maxJobDurationInSeconds: kotlin.Long = 0L
        /**
         * The output location.
         */
        public var outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = null
        /**
         * The robot applications to use in the simulation job.
         */
        public var robotApplications: List<RobotApplicationConfig>? = null
        /**
         * The simulation applications to use in the simulation job.
         */
        public var simulationApplications: List<SimulationApplicationConfig>? = null
        /**
         * A map that contains tag keys and tag values that are attached to the simulation job request.
         */
        public var tags: Map<String, String>? = null
        /**
         * A Boolean indicating whether to use default applications in the simulation job. Default applications include Gazebo, rqt, rviz and terminal access.
         */
        public var useDefaultApplications: kotlin.Boolean? = null
        /**
         * If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.
         */
        public var vpcConfig: aws.sdk.kotlin.services.robomaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.SimulationJobRequest) : this() {
            this.compute = x.compute
            this.dataSources = x.dataSources
            this.failureBehavior = x.failureBehavior
            this.iamRole = x.iamRole
            this.loggingConfig = x.loggingConfig
            this.maxJobDurationInSeconds = x.maxJobDurationInSeconds
            this.outputLocation = x.outputLocation
            this.robotApplications = x.robotApplications
            this.simulationApplications = x.simulationApplications
            this.tags = x.tags
            this.useDefaultApplications = x.useDefaultApplications
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.SimulationJobRequest = SimulationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.Compute] inside the given [block]
         */
        public fun compute(block: aws.sdk.kotlin.services.robomaker.model.Compute.Builder.() -> kotlin.Unit) {
            this.compute = aws.sdk.kotlin.services.robomaker.model.Compute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.LoggingConfig] inside the given [block]
         */
        public fun loggingConfig(block: aws.sdk.kotlin.services.robomaker.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.robomaker.model.LoggingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.OutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.robomaker.model.OutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.robomaker.model.OutputLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.robomaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.robomaker.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
