// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeRobotApplicationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the robot application.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The object that contains the Docker image URI used to create the robot application.
     */
    public val environment: aws.sdk.kotlin.services.robomaker.model.Environment? = builder.environment
    /**
     * A SHA256 identifier for the Docker image that you use for your robot application.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The time, in milliseconds since the epoch, when the robot application was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the robot application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The revision id of the robot application.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The robot software suite (ROS distribution) used by the robot application.
     */
    public val robotSoftwareSuite: aws.sdk.kotlin.services.robomaker.model.RobotSoftwareSuite? = builder.robotSoftwareSuite
    /**
     * The sources of the robot application.
     */
    public val sources: List<Source>? = builder.sources
    /**
     * The list of all tags added to the specified robot application.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The version of the robot application.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRobotApplicationResponse(")
        append("arn=$arn,")
        append("environment=$environment,")
        append("imageDigest=$imageDigest,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=$name,")
        append("revisionId=$revisionId,")
        append("robotSoftwareSuite=$robotSoftwareSuite,")
        append("sources=$sources,")
        append("tags=$tags,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (robotSoftwareSuite?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRobotApplicationResponse

        if (arn != other.arn) return false
        if (environment != other.environment) return false
        if (imageDigest != other.imageDigest) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false
        if (revisionId != other.revisionId) return false
        if (robotSoftwareSuite != other.robotSoftwareSuite) return false
        if (sources != other.sources) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the robot application.
         */
        public var arn: kotlin.String? = null
        /**
         * The object that contains the Docker image URI used to create the robot application.
         */
        public var environment: aws.sdk.kotlin.services.robomaker.model.Environment? = null
        /**
         * A SHA256 identifier for the Docker image that you use for your robot application.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the robot application was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the robot application.
         */
        public var name: kotlin.String? = null
        /**
         * The revision id of the robot application.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The robot software suite (ROS distribution) used by the robot application.
         */
        public var robotSoftwareSuite: aws.sdk.kotlin.services.robomaker.model.RobotSoftwareSuite? = null
        /**
         * The sources of the robot application.
         */
        public var sources: List<Source>? = null
        /**
         * The list of all tags added to the specified robot application.
         */
        public var tags: Map<String, String>? = null
        /**
         * The version of the robot application.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationResponse) : this() {
            this.arn = x.arn
            this.environment = x.environment
            this.imageDigest = x.imageDigest
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
            this.revisionId = x.revisionId
            this.robotSoftwareSuite = x.robotSoftwareSuite
            this.sources = x.sources
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationResponse = DescribeRobotApplicationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.Environment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.robomaker.model.Environment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.robomaker.model.Environment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.RobotSoftwareSuite] inside the given [block]
         */
        public fun robotSoftwareSuite(block: aws.sdk.kotlin.services.robomaker.model.RobotSoftwareSuite.Builder.() -> kotlin.Unit) {
            this.robotSoftwareSuite = aws.sdk.kotlin.services.robomaker.model.RobotSoftwareSuite.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
