// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.serde

import aws.sdk.kotlin.services.robomaker.model.DeploymentApplicationConfig
import aws.sdk.kotlin.services.robomaker.model.DeploymentConfig
import aws.sdk.kotlin.services.robomaker.model.DeploymentJobErrorCode
import aws.sdk.kotlin.services.robomaker.model.DeploymentStatus
import aws.sdk.kotlin.services.robomaker.model.RoboMakerException
import aws.sdk.kotlin.services.robomaker.model.SyncDeploymentJobResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class SyncDeploymentJobOperationDeserializer: HttpDeserializer.NonStreaming<SyncDeploymentJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SyncDeploymentJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSyncDeploymentJobError(context, call, payload)
        }
        val builder = SyncDeploymentJobResponse.Builder()

        if (payload != null) {
            deserializeSyncDeploymentJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSyncDeploymentJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RoboMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotentParameterMismatchException" -> IdempotentParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentDeploymentException" -> ConcurrentDeploymentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RoboMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSyncDeploymentJobOperationBody(builder: SyncDeploymentJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deploymentApplicationConfigs"))
    val DEPLOYMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentConfig"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("failureCode"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val FLEET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fleet"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR)
        field(DEPLOYMENTCONFIG_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FLEET_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR.index -> builder.deploymentApplicationConfigs =
                    deserializer.deserializeList(DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentApplicationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentApplicationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEPLOYMENTCONFIG_DESCRIPTOR.index -> builder.deploymentConfig = deserializeDeploymentConfigDocument(deserializer)
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString().let { DeploymentJobErrorCode.fromValue(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FLEET_DESCRIPTOR.index -> builder.fleet = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DeploymentStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
