// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.paginators

import aws.sdk.kotlin.services.robomaker.RoboMakerClient
import aws.sdk.kotlin.services.robomaker.model.DeploymentJob
import aws.sdk.kotlin.services.robomaker.model.Fleet
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListFleetsRequest
import aws.sdk.kotlin.services.robomaker.model.ListFleetsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldsResponse
import aws.sdk.kotlin.services.robomaker.model.Robot
import aws.sdk.kotlin.services.robomaker.model.RobotApplicationSummary
import aws.sdk.kotlin.services.robomaker.model.SimulationApplicationSummary
import aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchSummary
import aws.sdk.kotlin.services.robomaker.model.SimulationJobSummary
import aws.sdk.kotlin.services.robomaker.model.TemplateSummary
import aws.sdk.kotlin.services.robomaker.model.WorldExportJobSummary
import aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobSummary
import aws.sdk.kotlin.services.robomaker.model.WorldSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDeploymentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentJobsResponse]
 */
public fun RoboMakerClient.listDeploymentJobsPaginated(initialRequest: ListDeploymentJobsRequest = ListDeploymentJobsRequest { }): Flow<ListDeploymentJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentJobsPaginated.listDeploymentJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentJobsResponse]
 */
public fun RoboMakerClient.listDeploymentJobsPaginated(block: ListDeploymentJobsRequest.Builder.() -> Unit): Flow<ListDeploymentJobsResponse> =
    listDeploymentJobsPaginated(ListDeploymentJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentJobsPaginated]
 * to access the nested member [DeploymentJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentJob]
 */
@JvmName("listDeploymentJobsResponseDeploymentJob")
public fun Flow<ListDeploymentJobsResponse>.deploymentJobs(): Flow<DeploymentJob> =
    transform() { response ->
        response.deploymentJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFleetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun RoboMakerClient.listFleetsPaginated(initialRequest: ListFleetsRequest = ListFleetsRequest { }): Flow<ListFleetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFleetsPaginated.listFleets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun RoboMakerClient.listFleetsPaginated(block: ListFleetsRequest.Builder.() -> Unit): Flow<ListFleetsResponse> =
    listFleetsPaginated(ListFleetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFleetsPaginated]
 * to access the nested member [Fleet]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Fleet]
 */
@JvmName("listFleetsResponseFleet")
public fun Flow<ListFleetsResponse>.fleetDetails(): Flow<Fleet> =
    transform() { response ->
        response.fleetDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRobotApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRobotApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotApplicationsResponse]
 */
public fun RoboMakerClient.listRobotApplicationsPaginated(initialRequest: ListRobotApplicationsRequest = ListRobotApplicationsRequest { }): Flow<ListRobotApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRobotApplicationsPaginated.listRobotApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRobotApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotApplicationsResponse]
 */
public fun RoboMakerClient.listRobotApplicationsPaginated(block: ListRobotApplicationsRequest.Builder.() -> Unit): Flow<ListRobotApplicationsResponse> =
    listRobotApplicationsPaginated(ListRobotApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRobotApplicationsPaginated]
 * to access the nested member [RobotApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RobotApplicationSummary]
 */
@JvmName("listRobotApplicationsResponseRobotApplicationSummary")
public fun Flow<ListRobotApplicationsResponse>.robotApplicationSummaries(): Flow<RobotApplicationSummary> =
    transform() { response ->
        response.robotApplicationSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRobotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRobotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotsResponse]
 */
public fun RoboMakerClient.listRobotsPaginated(initialRequest: ListRobotsRequest = ListRobotsRequest { }): Flow<ListRobotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRobotsPaginated.listRobots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRobotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotsResponse]
 */
public fun RoboMakerClient.listRobotsPaginated(block: ListRobotsRequest.Builder.() -> Unit): Flow<ListRobotsResponse> =
    listRobotsPaginated(ListRobotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRobotsPaginated]
 * to access the nested member [Robot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Robot]
 */
@JvmName("listRobotsResponseRobot")
public fun Flow<ListRobotsResponse>.robots(): Flow<Robot> =
    transform() { response ->
        response.robots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSimulationApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationApplicationsResponse]
 */
public fun RoboMakerClient.listSimulationApplicationsPaginated(initialRequest: ListSimulationApplicationsRequest = ListSimulationApplicationsRequest { }): Flow<ListSimulationApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationApplicationsPaginated.listSimulationApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationApplicationsResponse]
 */
public fun RoboMakerClient.listSimulationApplicationsPaginated(block: ListSimulationApplicationsRequest.Builder.() -> Unit): Flow<ListSimulationApplicationsResponse> =
    listSimulationApplicationsPaginated(ListSimulationApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSimulationApplicationsPaginated]
 * to access the nested member [SimulationApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulationApplicationSummary]
 */
@JvmName("listSimulationApplicationsResponseSimulationApplicationSummary")
public fun Flow<ListSimulationApplicationsResponse>.simulationApplicationSummaries(): Flow<SimulationApplicationSummary> =
    transform() { response ->
        response.simulationApplicationSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSimulationJobBatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationJobBatchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobBatchesResponse]
 */
public fun RoboMakerClient.listSimulationJobBatchesPaginated(initialRequest: ListSimulationJobBatchesRequest = ListSimulationJobBatchesRequest { }): Flow<ListSimulationJobBatchesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationJobBatchesPaginated.listSimulationJobBatches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationJobBatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobBatchesResponse]
 */
public fun RoboMakerClient.listSimulationJobBatchesPaginated(block: ListSimulationJobBatchesRequest.Builder.() -> Unit): Flow<ListSimulationJobBatchesResponse> =
    listSimulationJobBatchesPaginated(ListSimulationJobBatchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSimulationJobBatchesPaginated]
 * to access the nested member [SimulationJobBatchSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulationJobBatchSummary]
 */
@JvmName("listSimulationJobBatchesResponseSimulationJobBatchSummary")
public fun Flow<ListSimulationJobBatchesResponse>.simulationJobBatchSummaries(): Flow<SimulationJobBatchSummary> =
    transform() { response ->
        response.simulationJobBatchSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSimulationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobsResponse]
 */
public fun RoboMakerClient.listSimulationJobsPaginated(initialRequest: ListSimulationJobsRequest = ListSimulationJobsRequest { }): Flow<ListSimulationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationJobsPaginated.listSimulationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobsResponse]
 */
public fun RoboMakerClient.listSimulationJobsPaginated(block: ListSimulationJobsRequest.Builder.() -> Unit): Flow<ListSimulationJobsResponse> =
    listSimulationJobsPaginated(ListSimulationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSimulationJobsPaginated]
 * to access the nested member [SimulationJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulationJobSummary]
 */
@JvmName("listSimulationJobsResponseSimulationJobSummary")
public fun Flow<ListSimulationJobsResponse>.simulationJobSummaries(): Flow<SimulationJobSummary> =
    transform() { response ->
        response.simulationJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorldExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldExportJobsResponse]
 */
public fun RoboMakerClient.listWorldExportJobsPaginated(initialRequest: ListWorldExportJobsRequest = ListWorldExportJobsRequest { }): Flow<ListWorldExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldExportJobsPaginated.listWorldExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldExportJobsResponse]
 */
public fun RoboMakerClient.listWorldExportJobsPaginated(block: ListWorldExportJobsRequest.Builder.() -> Unit): Flow<ListWorldExportJobsResponse> =
    listWorldExportJobsPaginated(ListWorldExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorldExportJobsPaginated]
 * to access the nested member [WorldExportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorldExportJobSummary]
 */
@JvmName("listWorldExportJobsResponseWorldExportJobSummary")
public fun Flow<ListWorldExportJobsResponse>.worldExportJobSummaries(): Flow<WorldExportJobSummary> =
    transform() { response ->
        response.worldExportJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorldGenerationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldGenerationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldGenerationJobsResponse]
 */
public fun RoboMakerClient.listWorldGenerationJobsPaginated(initialRequest: ListWorldGenerationJobsRequest = ListWorldGenerationJobsRequest { }): Flow<ListWorldGenerationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldGenerationJobsPaginated.listWorldGenerationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldGenerationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldGenerationJobsResponse]
 */
public fun RoboMakerClient.listWorldGenerationJobsPaginated(block: ListWorldGenerationJobsRequest.Builder.() -> Unit): Flow<ListWorldGenerationJobsResponse> =
    listWorldGenerationJobsPaginated(ListWorldGenerationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorldGenerationJobsPaginated]
 * to access the nested member [WorldGenerationJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorldGenerationJobSummary]
 */
@JvmName("listWorldGenerationJobsResponseWorldGenerationJobSummary")
public fun Flow<ListWorldGenerationJobsResponse>.worldGenerationJobSummaries(): Flow<WorldGenerationJobSummary> =
    transform() { response ->
        response.worldGenerationJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorldsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldsResponse]
 */
public fun RoboMakerClient.listWorldsPaginated(initialRequest: ListWorldsRequest = ListWorldsRequest { }): Flow<ListWorldsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldsPaginated.listWorlds(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldsResponse]
 */
public fun RoboMakerClient.listWorldsPaginated(block: ListWorldsRequest.Builder.() -> Unit): Flow<ListWorldsResponse> =
    listWorldsPaginated(ListWorldsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorldsPaginated]
 * to access the nested member [WorldSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorldSummary]
 */
@JvmName("listWorldsResponseWorldSummary")
public fun Flow<ListWorldsResponse>.worldSummaries(): Flow<WorldSummary> =
    transform() { response ->
        response.worldSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorldTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldTemplatesResponse]
 */
public fun RoboMakerClient.listWorldTemplatesPaginated(initialRequest: ListWorldTemplatesRequest = ListWorldTemplatesRequest { }): Flow<ListWorldTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldTemplatesPaginated.listWorldTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldTemplatesResponse]
 */
public fun RoboMakerClient.listWorldTemplatesPaginated(block: ListWorldTemplatesRequest.Builder.() -> Unit): Flow<ListWorldTemplatesResponse> =
    listWorldTemplatesPaginated(ListWorldTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorldTemplatesPaginated]
 * to access the nested member [TemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateSummary]
 */
@JvmName("listWorldTemplatesResponseTemplateSummary")
public fun Flow<ListWorldTemplatesResponse>.templateSummaries(): Flow<TemplateSummary> =
    transform() { response ->
        response.templateSummaries?.forEach {
            emit(it)
        }
    }
