// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a world export job.
 */
public class WorldExportJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the world export job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time, in milliseconds since the epoch, when the world export job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The output location.
     */
    public val outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = builder.outputLocation
    /**
     * The status of the world export job.
     *
     * ## Pending
     * The world export job request is pending.
     *
     * ## Running
     * The world export job is running.
     *
     * ## Completed
     * The world export job completed.
     *
     * ## Failed
     * The world export job failed. See `failureCode` for more information.
     *
     * ## Canceled
     * The world export job was cancelled.
     *
     * ## Canceling
     * The world export job is being cancelled.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.WorldExportJobStatus? = builder.status
    /**
     * A list of worlds.
     */
    public val worlds: List<String>? = builder.worlds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.WorldExportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorldExportJobSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("outputLocation=$outputLocation,")
        append("status=$status,")
        append("worlds=$worlds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (worlds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorldExportJobSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (outputLocation != other.outputLocation) return false
        if (status != other.status) return false
        if (worlds != other.worlds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.WorldExportJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the world export job.
         */
        public var arn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the world export job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The output location.
         */
        public var outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = null
        /**
         * The status of the world export job.
         *
         * ## Pending
         * The world export job request is pending.
         *
         * ## Running
         * The world export job is running.
         *
         * ## Completed
         * The world export job completed.
         *
         * ## Failed
         * The world export job failed. See `failureCode` for more information.
         *
         * ## Canceled
         * The world export job was cancelled.
         *
         * ## Canceling
         * The world export job is being cancelled.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.WorldExportJobStatus? = null
        /**
         * A list of worlds.
         */
        public var worlds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.WorldExportJobSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.outputLocation = x.outputLocation
            this.status = x.status
            this.worlds = x.worlds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.WorldExportJobSummary = WorldExportJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.OutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.robomaker.model.OutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.robomaker.model.OutputLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
