// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a simulation job batch.
 */
public class SimulationJobBatchSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the batch.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time, in milliseconds since the epoch, when the simulation job batch was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The number of created simulation job requests.
     */
    public val createdRequestCount: kotlin.Int = builder.createdRequestCount
    /**
     * The number of failed simulation job requests.
     */
    public val failedRequestCount: kotlin.Int = builder.failedRequestCount
    /**
     * The time, in milliseconds since the epoch, when the simulation job batch was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The number of pending simulation job requests.
     */
    public val pendingRequestCount: kotlin.Int = builder.pendingRequestCount
    /**
     * The status of the simulation job batch.
     *
     * ## Pending
     * The simulation job batch request is pending.
     *
     * ## InProgress
     * The simulation job batch is in progress.
     *
     * ## Failed
     * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like `InternalServiceError`). See `failureCode` and `failureReason` for more information.
     *
     * ## Completed
     * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to `InternalServiceError` and (2) when all created simulation jobs have reached a terminal state (for example, `Completed` or `Failed`).
     *
     * ## Canceled
     * The simulation batch job was cancelled.
     *
     * ## Canceling
     * The simulation batch job is being cancelled.
     *
     * ## Completing
     * The simulation batch job is completing.
     *
     * ## TimingOut
     * The simulation job batch is timing out.
     *
     * If a batch timing out, and there are pending requests that were failing due to an internal failure (like `InternalServiceError`), the batch status will be `Failed`. If there are no such failing request, the batch status will be `TimedOut`.
     *
     * ## TimedOut
     * The simulation batch job timed out.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimulationJobBatchSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("createdRequestCount=$createdRequestCount,")
        append("failedRequestCount=$failedRequestCount,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("pendingRequestCount=$pendingRequestCount,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdRequestCount)
        result = 31 * result + (failedRequestCount)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (pendingRequestCount)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimulationJobBatchSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (createdRequestCount != other.createdRequestCount) return false
        if (failedRequestCount != other.failedRequestCount) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (pendingRequestCount != other.pendingRequestCount) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the batch.
         */
        public var arn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the simulation job batch was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of created simulation job requests.
         */
        public var createdRequestCount: kotlin.Int = 0
        /**
         * The number of failed simulation job requests.
         */
        public var failedRequestCount: kotlin.Int = 0
        /**
         * The time, in milliseconds since the epoch, when the simulation job batch was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of pending simulation job requests.
         */
        public var pendingRequestCount: kotlin.Int = 0
        /**
         * The status of the simulation job batch.
         *
         * ## Pending
         * The simulation job batch request is pending.
         *
         * ## InProgress
         * The simulation job batch is in progress.
         *
         * ## Failed
         * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like `InternalServiceError`). See `failureCode` and `failureReason` for more information.
         *
         * ## Completed
         * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to `InternalServiceError` and (2) when all created simulation jobs have reached a terminal state (for example, `Completed` or `Failed`).
         *
         * ## Canceled
         * The simulation batch job was cancelled.
         *
         * ## Canceling
         * The simulation batch job is being cancelled.
         *
         * ## Completing
         * The simulation batch job is completing.
         *
         * ## TimingOut
         * The simulation job batch is timing out.
         *
         * If a batch timing out, and there are pending requests that were failing due to an internal failure (like `InternalServiceError`), the batch status will be `Failed`. If there are no such failing request, the batch status will be `TimedOut`.
         *
         * ## TimedOut
         * The simulation batch job timed out.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.createdRequestCount = x.createdRequestCount
            this.failedRequestCount = x.failedRequestCount
            this.lastUpdatedAt = x.lastUpdatedAt
            this.pendingRequestCount = x.pendingRequestCount
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchSummary = SimulationJobBatchSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
