// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a launch configuration.
 */
public class LaunchConfig private constructor(builder: Builder) {
    /**
     * If you've specified `General` as the value for your `RobotSoftwareSuite`, you can use this field to specify a list of commands for your container image.
     *
     * If you've specified `SimulationRuntime` as the value for your `SimulationSoftwareSuite`, you can use this field to specify a list of commands for your container image.
     */
    public val command: List<String>? = builder.command
    /**
     * The environment variables for the application launch.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The launch file name.
     */
    public val launchFile: kotlin.String? = builder.launchFile
    /**
     * The package name.
     */
    public val packageName: kotlin.String? = builder.packageName
    /**
     * The port forwarding configuration.
     */
    public val portForwardingConfig: aws.sdk.kotlin.services.robomaker.model.PortForwardingConfig? = builder.portForwardingConfig
    /**
     * Boolean indicating whether a streaming session will be configured for the application. If `True`, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and launch the component. It must have a graphical user interface.
     */
    public val streamUi: kotlin.Boolean = builder.streamUi

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.LaunchConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchConfig(")
        append("command=$command,")
        append("environmentVariables=$environmentVariables,")
        append("launchFile=$launchFile,")
        append("packageName=$packageName,")
        append("portForwardingConfig=$portForwardingConfig,")
        append("streamUi=$streamUi")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (launchFile?.hashCode() ?: 0)
        result = 31 * result + (packageName?.hashCode() ?: 0)
        result = 31 * result + (portForwardingConfig?.hashCode() ?: 0)
        result = 31 * result + (streamUi.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchConfig

        if (command != other.command) return false
        if (environmentVariables != other.environmentVariables) return false
        if (launchFile != other.launchFile) return false
        if (packageName != other.packageName) return false
        if (portForwardingConfig != other.portForwardingConfig) return false
        if (streamUi != other.streamUi) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.LaunchConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If you've specified `General` as the value for your `RobotSoftwareSuite`, you can use this field to specify a list of commands for your container image.
         *
         * If you've specified `SimulationRuntime` as the value for your `SimulationSoftwareSuite`, you can use this field to specify a list of commands for your container image.
         */
        public var command: List<String>? = null
        /**
         * The environment variables for the application launch.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The launch file name.
         */
        public var launchFile: kotlin.String? = null
        /**
         * The package name.
         */
        public var packageName: kotlin.String? = null
        /**
         * The port forwarding configuration.
         */
        public var portForwardingConfig: aws.sdk.kotlin.services.robomaker.model.PortForwardingConfig? = null
        /**
         * Boolean indicating whether a streaming session will be configured for the application. If `True`, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and launch the component. It must have a graphical user interface.
         */
        public var streamUi: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.LaunchConfig) : this() {
            this.command = x.command
            this.environmentVariables = x.environmentVariables
            this.launchFile = x.launchFile
            this.packageName = x.packageName
            this.portForwardingConfig = x.portForwardingConfig
            this.streamUi = x.streamUi
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.LaunchConfig = LaunchConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.PortForwardingConfig] inside the given [block]
         */
        public fun portForwardingConfig(block: aws.sdk.kotlin.services.robomaker.model.PortForwardingConfig.Builder.() -> kotlin.Unit) {
            this.portForwardingConfig = aws.sdk.kotlin.services.robomaker.model.PortForwardingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
