// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeSimulationJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the simulation job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Compute information for the simulation job.
     */
    public val compute: aws.sdk.kotlin.services.robomaker.model.ComputeResponse? = builder.compute
    /**
     * The data sources for the simulation job.
     */
    public val dataSources: List<DataSource>? = builder.dataSources
    /**
     * The failure behavior for the simulation job.
     */
    public val failureBehavior: aws.sdk.kotlin.services.robomaker.model.FailureBehavior? = builder.failureBehavior
    /**
     * The failure code of the simulation job if it failed:
     *
     * ## InternalServiceError
     * Internal service error.
     *
     * ## RobotApplicationCrash
     * Robot application exited abnormally.
     *
     * ## SimulationApplicationCrash
     *  Simulation application exited abnormally.
     *
     * ## BadPermissionsRobotApplication
     * Robot application bundle could not be downloaded.
     *
     * ## BadPermissionsSimulationApplication
     * Simulation application bundle could not be downloaded.
     *
     * ## BadPermissionsS3Output
     * Unable to publish outputs to customer-provided S3 bucket.
     *
     * ## BadPermissionsCloudwatchLogs
     * Unable to publish logs to customer-provided CloudWatch Logs resource.
     *
     * ## SubnetIpLimitExceeded
     * Subnet IP limit exceeded.
     *
     * ## ENILimitExceeded
     * ENI limit exceeded.
     *
     * ## BadPermissionsUserCredentials
     * Unable to use the Role provided.
     *
     * ## InvalidBundleRobotApplication
     * Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
     *
     * ## InvalidBundleSimulationApplication
     * Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
     *
     * ## RobotApplicationVersionMismatchedEtag
     * Etag for RobotApplication does not match value during version creation.
     *
     * ## SimulationApplicationVersionMismatchedEtag
     * Etag for SimulationApplication does not match value during version creation.
     */
    public val failureCode: aws.sdk.kotlin.services.robomaker.model.SimulationJobErrorCode? = builder.failureCode
    /**
     * Details about why the simulation job failed. For more information about troubleshooting, see [Troubleshooting](https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * The time, in milliseconds since the epoch, when the simulation job was last started.
     */
    public val lastStartedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStartedAt
    /**
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The logging configuration.
     */
    public val loggingConfig: aws.sdk.kotlin.services.robomaker.model.LoggingConfig? = builder.loggingConfig
    /**
     * The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     */
    public val maxJobDurationInSeconds: kotlin.Long = builder.maxJobDurationInSeconds
    /**
     * The name of the simulation job.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network interface information for the simulation job.
     */
    public val networkInterface: aws.sdk.kotlin.services.robomaker.model.NetworkInterface? = builder.networkInterface
    /**
     * Location for output files generated by the simulation job.
     */
    public val outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = builder.outputLocation
    /**
     * A list of robot applications.
     */
    public val robotApplications: List<RobotApplicationConfig>? = builder.robotApplications
    /**
     * A list of simulation applications.
     */
    public val simulationApplications: List<SimulationApplicationConfig>? = builder.simulationApplications
    /**
     * The simulation job execution duration in milliseconds.
     */
    public val simulationTimeMillis: kotlin.Long = builder.simulationTimeMillis
    /**
     * The status of the simulation job.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.SimulationJobStatus? = builder.status
    /**
     * The list of all tags added to the specified simulation job.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The VPC configuration.
     */
    public val vpcConfig: aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSimulationJobResponse(")
        append("arn=$arn,")
        append("clientRequestToken=$clientRequestToken,")
        append("compute=$compute,")
        append("dataSources=$dataSources,")
        append("failureBehavior=$failureBehavior,")
        append("failureCode=$failureCode,")
        append("failureReason=$failureReason,")
        append("iamRole=$iamRole,")
        append("lastStartedAt=$lastStartedAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("loggingConfig=$loggingConfig,")
        append("maxJobDurationInSeconds=$maxJobDurationInSeconds,")
        append("name=$name,")
        append("networkInterface=$networkInterface,")
        append("outputLocation=$outputLocation,")
        append("robotApplications=$robotApplications,")
        append("simulationApplications=$simulationApplications,")
        append("simulationTimeMillis=$simulationTimeMillis,")
        append("status=$status,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (compute?.hashCode() ?: 0)
        result = 31 * result + (dataSources?.hashCode() ?: 0)
        result = 31 * result + (failureBehavior?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (lastStartedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (maxJobDurationInSeconds.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkInterface?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (robotApplications?.hashCode() ?: 0)
        result = 31 * result + (simulationApplications?.hashCode() ?: 0)
        result = 31 * result + (simulationTimeMillis.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSimulationJobResponse

        if (arn != other.arn) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (compute != other.compute) return false
        if (dataSources != other.dataSources) return false
        if (failureBehavior != other.failureBehavior) return false
        if (failureCode != other.failureCode) return false
        if (failureReason != other.failureReason) return false
        if (iamRole != other.iamRole) return false
        if (lastStartedAt != other.lastStartedAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (loggingConfig != other.loggingConfig) return false
        if (maxJobDurationInSeconds != other.maxJobDurationInSeconds) return false
        if (name != other.name) return false
        if (networkInterface != other.networkInterface) return false
        if (outputLocation != other.outputLocation) return false
        if (robotApplications != other.robotApplications) return false
        if (simulationApplications != other.simulationApplications) return false
        if (simulationTimeMillis != other.simulationTimeMillis) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the simulation job.
         */
        public var arn: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Compute information for the simulation job.
         */
        public var compute: aws.sdk.kotlin.services.robomaker.model.ComputeResponse? = null
        /**
         * The data sources for the simulation job.
         */
        public var dataSources: List<DataSource>? = null
        /**
         * The failure behavior for the simulation job.
         */
        public var failureBehavior: aws.sdk.kotlin.services.robomaker.model.FailureBehavior? = null
        /**
         * The failure code of the simulation job if it failed:
         *
         * ## InternalServiceError
         * Internal service error.
         *
         * ## RobotApplicationCrash
         * Robot application exited abnormally.
         *
         * ## SimulationApplicationCrash
         *  Simulation application exited abnormally.
         *
         * ## BadPermissionsRobotApplication
         * Robot application bundle could not be downloaded.
         *
         * ## BadPermissionsSimulationApplication
         * Simulation application bundle could not be downloaded.
         *
         * ## BadPermissionsS3Output
         * Unable to publish outputs to customer-provided S3 bucket.
         *
         * ## BadPermissionsCloudwatchLogs
         * Unable to publish logs to customer-provided CloudWatch Logs resource.
         *
         * ## SubnetIpLimitExceeded
         * Subnet IP limit exceeded.
         *
         * ## ENILimitExceeded
         * ENI limit exceeded.
         *
         * ## BadPermissionsUserCredentials
         * Unable to use the Role provided.
         *
         * ## InvalidBundleRobotApplication
         * Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
         *
         * ## InvalidBundleSimulationApplication
         * Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
         *
         * ## RobotApplicationVersionMismatchedEtag
         * Etag for RobotApplication does not match value during version creation.
         *
         * ## SimulationApplicationVersionMismatchedEtag
         * Etag for SimulationApplication does not match value during version creation.
         */
        public var failureCode: aws.sdk.kotlin.services.robomaker.model.SimulationJobErrorCode? = null
        /**
         * Details about why the simulation job failed. For more information about troubleshooting, see [Troubleshooting](https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf.
         */
        public var iamRole: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the simulation job was last started.
         */
        public var lastStartedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in milliseconds since the epoch, when the simulation job was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The logging configuration.
         */
        public var loggingConfig: aws.sdk.kotlin.services.robomaker.model.LoggingConfig? = null
        /**
         * The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.
         */
        public var maxJobDurationInSeconds: kotlin.Long = 0L
        /**
         * The name of the simulation job.
         */
        public var name: kotlin.String? = null
        /**
         * The network interface information for the simulation job.
         */
        public var networkInterface: aws.sdk.kotlin.services.robomaker.model.NetworkInterface? = null
        /**
         * Location for output files generated by the simulation job.
         */
        public var outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = null
        /**
         * A list of robot applications.
         */
        public var robotApplications: List<RobotApplicationConfig>? = null
        /**
         * A list of simulation applications.
         */
        public var simulationApplications: List<SimulationApplicationConfig>? = null
        /**
         * The simulation job execution duration in milliseconds.
         */
        public var simulationTimeMillis: kotlin.Long = 0L
        /**
         * The status of the simulation job.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.SimulationJobStatus? = null
        /**
         * The list of all tags added to the specified simulation job.
         */
        public var tags: Map<String, String>? = null
        /**
         * The VPC configuration.
         */
        public var vpcConfig: aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse) : this() {
            this.arn = x.arn
            this.clientRequestToken = x.clientRequestToken
            this.compute = x.compute
            this.dataSources = x.dataSources
            this.failureBehavior = x.failureBehavior
            this.failureCode = x.failureCode
            this.failureReason = x.failureReason
            this.iamRole = x.iamRole
            this.lastStartedAt = x.lastStartedAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.loggingConfig = x.loggingConfig
            this.maxJobDurationInSeconds = x.maxJobDurationInSeconds
            this.name = x.name
            this.networkInterface = x.networkInterface
            this.outputLocation = x.outputLocation
            this.robotApplications = x.robotApplications
            this.simulationApplications = x.simulationApplications
            this.simulationTimeMillis = x.simulationTimeMillis
            this.status = x.status
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse = DescribeSimulationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.ComputeResponse] inside the given [block]
         */
        public fun compute(block: aws.sdk.kotlin.services.robomaker.model.ComputeResponse.Builder.() -> kotlin.Unit) {
            this.compute = aws.sdk.kotlin.services.robomaker.model.ComputeResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.LoggingConfig] inside the given [block]
         */
        public fun loggingConfig(block: aws.sdk.kotlin.services.robomaker.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.robomaker.model.LoggingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.NetworkInterface] inside the given [block]
         */
        public fun networkInterface(block: aws.sdk.kotlin.services.robomaker.model.NetworkInterface.Builder.() -> kotlin.Unit) {
            this.networkInterface = aws.sdk.kotlin.services.robomaker.model.NetworkInterface.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.OutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.robomaker.model.OutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.robomaker.model.OutputLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
