// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateWorldExportJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the world export job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The time, in milliseconds since the epoch, when the world export job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The failure code of the world export job if it failed:
     *
     * ## InternalServiceError
     * Internal service error.
     *
     * ## LimitExceeded
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.
     *
     * ## ResourceNotFound
     * The specified resource could not be found.
     *
     * ## RequestThrottled
     * The request was throttled.
     *
     * ## InvalidInput
     * An input parameter in the request is not valid.
     *
     * ## AllWorldGenerationFailed
     * All of the worlds in the world generation job failed. This can happen if your `worldCount` is greater than 50 or less than 1.
     *
     * For more information about troubleshooting WorldForge, see [Troubleshooting Simulation WorldForge](https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html).
     */
    public val failureCode: aws.sdk.kotlin.services.robomaker.model.WorldExportJobErrorCode? = builder.failureCode
    /**
     * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * The output location.
     */
    public val outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = builder.outputLocation
    /**
     * The status of the world export job.
     *
     * ## Pending
     * The world export job request is pending.
     *
     * ## Running
     * The world export job is running.
     *
     * ## Completed
     * The world export job completed.
     *
     * ## Failed
     * The world export job failed. See `failureCode` for more information.
     *
     * ## Canceled
     * The world export job was cancelled.
     *
     * ## Canceling
     * The world export job is being cancelled.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.WorldExportJobStatus? = builder.status
    /**
     * A map that contains tag keys and tag values that are attached to the world export job.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorldExportJobResponse(")
        append("arn=$arn,")
        append("clientRequestToken=$clientRequestToken,")
        append("createdAt=$createdAt,")
        append("failureCode=$failureCode,")
        append("iamRole=$iamRole,")
        append("outputLocation=$outputLocation,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorldExportJobResponse

        if (arn != other.arn) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (createdAt != other.createdAt) return false
        if (failureCode != other.failureCode) return false
        if (iamRole != other.iamRole) return false
        if (outputLocation != other.outputLocation) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the world export job.
         */
        public var arn: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the world export job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The failure code of the world export job if it failed:
         *
         * ## InternalServiceError
         * Internal service error.
         *
         * ## LimitExceeded
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.
         *
         * ## ResourceNotFound
         * The specified resource could not be found.
         *
         * ## RequestThrottled
         * The request was throttled.
         *
         * ## InvalidInput
         * An input parameter in the request is not valid.
         *
         * ## AllWorldGenerationFailed
         * All of the worlds in the world generation job failed. This can happen if your `worldCount` is greater than 50 or less than 1.
         *
         * For more information about troubleshooting WorldForge, see [Troubleshooting Simulation WorldForge](https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html).
         */
        public var failureCode: aws.sdk.kotlin.services.robomaker.model.WorldExportJobErrorCode? = null
        /**
         * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
         */
        public var iamRole: kotlin.String? = null
        /**
         * The output location.
         */
        public var outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = null
        /**
         * The status of the world export job.
         *
         * ## Pending
         * The world export job request is pending.
         *
         * ## Running
         * The world export job is running.
         *
         * ## Completed
         * The world export job completed.
         *
         * ## Failed
         * The world export job failed. See `failureCode` for more information.
         *
         * ## Canceled
         * The world export job was cancelled.
         *
         * ## Canceling
         * The world export job is being cancelled.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.WorldExportJobStatus? = null
        /**
         * A map that contains tag keys and tag values that are attached to the world export job.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobResponse) : this() {
            this.arn = x.arn
            this.clientRequestToken = x.clientRequestToken
            this.createdAt = x.createdAt
            this.failureCode = x.failureCode
            this.iamRole = x.iamRole
            this.outputLocation = x.outputLocation
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobResponse = CreateWorldExportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.OutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.robomaker.model.OutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.robomaker.model.OutputLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
