// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the batch policy.
 */
public class BatchPolicy private constructor(builder: Builder) {
    /**
     * The number of active simulation jobs create as part of the batch that can be in an active state at the same time.
     *
     * Active states include: `Pending`,`Preparing`, `Running`, `Restarting`, `RunningFailed` and `Terminating`. All other states are terminal states.
     */
    public val maxConcurrency: kotlin.Int? = builder.maxConcurrency
    /**
     * The amount of time, in seconds, to wait for the batch to complete.
     *
     * If a batch times out, and there are pending requests that were failing due to an internal failure (like `InternalServiceError`), they will be moved to the failed list and the batch status will be `Failed`. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be `TimedOut`.
     */
    public val timeoutInSeconds: kotlin.Long? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.BatchPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchPolicy(")
        append("maxConcurrency=$maxConcurrency,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxConcurrency ?: 0
        result = 31 * result + (timeoutInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchPolicy

        if (maxConcurrency != other.maxConcurrency) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.BatchPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of active simulation jobs create as part of the batch that can be in an active state at the same time.
         *
         * Active states include: `Pending`,`Preparing`, `Running`, `Restarting`, `RunningFailed` and `Terminating`. All other states are terminal states.
         */
        public var maxConcurrency: kotlin.Int? = null
        /**
         * The amount of time, in seconds, to wait for the batch to complete.
         *
         * If a batch times out, and there are pending requests that were failing due to an internal failure (like `InternalServiceError`), they will be moved to the failed list and the batch status will be `Failed`. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be `TimedOut`.
         */
        public var timeoutInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.BatchPolicy) : this() {
            this.maxConcurrency = x.maxConcurrency
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.BatchPolicy = BatchPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
