// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.robomaker.auth.DefaultRoboMakerAuthSchemeProvider
import aws.sdk.kotlin.services.robomaker.auth.RoboMakerAuthSchemeProvider
import aws.sdk.kotlin.services.robomaker.endpoints.DefaultRoboMakerEndpointProvider
import aws.sdk.kotlin.services.robomaker.endpoints.RoboMakerEndpointParameters
import aws.sdk.kotlin.services.robomaker.endpoints.RoboMakerEndpointProvider
import aws.sdk.kotlin.services.robomaker.model.BatchDeleteWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.BatchDeleteWorldsResponse
import aws.sdk.kotlin.services.robomaker.model.BatchDescribeSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.BatchDescribeSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobBatchResponse
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelWorldExportJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelWorldGenerationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateFleetRequest
import aws.sdk.kotlin.services.robomaker.model.CreateFleetResponse
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationVersionRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationVersionResponse
import aws.sdk.kotlin.services.robomaker.model.CreateRobotRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationVersionRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationVersionResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldTemplateResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteFleetRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteFleetResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteWorldTemplateResponse
import aws.sdk.kotlin.services.robomaker.model.DeregisterRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DeregisterRobotResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeFleetRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeFleetResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobBatchResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldGenerationJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldTemplateResponse
import aws.sdk.kotlin.services.robomaker.model.GetWorldTemplateBodyRequest
import aws.sdk.kotlin.services.robomaker.model.GetWorldTemplateBodyResponse
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListFleetsRequest
import aws.sdk.kotlin.services.robomaker.model.ListFleetsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.robomaker.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldsResponse
import aws.sdk.kotlin.services.robomaker.model.RegisterRobotRequest
import aws.sdk.kotlin.services.robomaker.model.RegisterRobotResponse
import aws.sdk.kotlin.services.robomaker.model.RestartSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.RestartSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse
import aws.sdk.kotlin.services.robomaker.model.SyncDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.SyncDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.TagResourceRequest
import aws.sdk.kotlin.services.robomaker.model.TagResourceResponse
import aws.sdk.kotlin.services.robomaker.model.UntagResourceRequest
import aws.sdk.kotlin.services.robomaker.model.UntagResourceResponse
import aws.sdk.kotlin.services.robomaker.model.UpdateRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.UpdateSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.UpdateWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateWorldTemplateResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "RoboMaker"
public const val SdkVersion: String = "1.2.48"
public const val ServiceApiVersion: String = "2018-06-29"

/**
 * This section provides documentation for the AWS RoboMaker API operations.
 */
public interface RoboMakerClient : SdkClient {
    /**
     * RoboMakerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, RoboMakerClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "RoboMaker",
                "ROBOMAKER",
                "robomaker",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, RoboMakerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): RoboMakerClient = DefaultRoboMakerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: RoboMakerEndpointProvider = builder.endpointProvider ?: DefaultRoboMakerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: RoboMakerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultRoboMakerAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "RoboMaker"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: RoboMakerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: RoboMakerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes one or more worlds in a batch operation.
     */
    public suspend fun batchDeleteWorlds(input: BatchDeleteWorldsRequest): BatchDeleteWorldsResponse

    /**
     * Describes one or more simulation jobs.
     */
    public suspend fun batchDescribeSimulationJob(input: BatchDescribeSimulationJobRequest): BatchDescribeSimulationJobResponse

    /**
     * Cancels the specified deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun cancelDeploymentJob(input: CancelDeploymentJobRequest): CancelDeploymentJobResponse

    /**
     * Cancels the specified simulation job.
     */
    public suspend fun cancelSimulationJob(input: CancelSimulationJobRequest): CancelSimulationJobResponse

    /**
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.
     */
    public suspend fun cancelSimulationJobBatch(input: CancelSimulationJobBatchRequest): CancelSimulationJobBatchResponse

    /**
     * Cancels the specified export job.
     */
    public suspend fun cancelWorldExportJob(input: CancelWorldExportJobRequest): CancelWorldExportJobResponse

    /**
     * Cancels the specified world generator job.
     */
    public suspend fun cancelWorldGenerationJob(input: CancelWorldGenerationJobRequest): CancelWorldGenerationJobResponse

    /**
     * Deploys a specific version of a robot application to robots in a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     *
     * The robot application must have a numbered `applicationVersion` for consistency reasons. To create a new version, use `CreateRobotApplicationVersion` or see [Creating a Robot Application Version](https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
     *
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     */
    @Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun createDeploymentJob(input: CreateDeploymentJobRequest): CreateDeploymentJobResponse

    /**
     * Creates a fleet, a logical group of robots running the same robot application.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Creates a robot.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun createRobot(input: CreateRobotRequest): CreateRobotResponse

    /**
     * Creates a robot application.
     */
    public suspend fun createRobotApplication(input: CreateRobotApplicationRequest): CreateRobotApplicationResponse

    /**
     * Creates a version of a robot application.
     */
    public suspend fun createRobotApplicationVersion(input: CreateRobotApplicationVersionRequest): CreateRobotApplicationVersionResponse

    /**
     * Creates a simulation application.
     */
    public suspend fun createSimulationApplication(input: CreateSimulationApplicationRequest): CreateSimulationApplicationResponse

    /**
     * Creates a simulation application with a specific revision id.
     */
    public suspend fun createSimulationApplicationVersion(input: CreateSimulationApplicationVersionRequest): CreateSimulationApplicationVersionResponse

    /**
     * Creates a simulation job.
     *
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     */
    public suspend fun createSimulationJob(input: CreateSimulationJobRequest): CreateSimulationJobResponse

    /**
     * Creates a world export job.
     */
    public suspend fun createWorldExportJob(input: CreateWorldExportJobRequest): CreateWorldExportJobResponse

    /**
     * Creates worlds using the specified template.
     */
    public suspend fun createWorldGenerationJob(input: CreateWorldGenerationJobRequest): CreateWorldGenerationJobResponse

    /**
     * Creates a world template.
     */
    public suspend fun createWorldTemplate(input: CreateWorldTemplateRequest = CreateWorldTemplateRequest { }): CreateWorldTemplateResponse

    /**
     * Deletes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Deletes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun deleteRobot(input: DeleteRobotRequest): DeleteRobotResponse

    /**
     * Deletes a robot application.
     */
    public suspend fun deleteRobotApplication(input: DeleteRobotApplicationRequest): DeleteRobotApplicationResponse

    /**
     * Deletes a simulation application.
     */
    public suspend fun deleteSimulationApplication(input: DeleteSimulationApplicationRequest): DeleteSimulationApplicationResponse

    /**
     * Deletes a world template.
     */
    public suspend fun deleteWorldTemplate(input: DeleteWorldTemplateRequest): DeleteWorldTemplateResponse

    /**
     * Deregisters a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun deregisterRobot(input: DeregisterRobotRequest): DeregisterRobotResponse

    /**
     * Describes a deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun describeDeploymentJob(input: DescribeDeploymentJobRequest): DescribeDeploymentJobResponse

    /**
     * Describes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun describeFleet(input: DescribeFleetRequest): DescribeFleetResponse

    /**
     * Describes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun describeRobot(input: DescribeRobotRequest): DescribeRobotResponse

    /**
     * Describes a robot application.
     */
    public suspend fun describeRobotApplication(input: DescribeRobotApplicationRequest): DescribeRobotApplicationResponse

    /**
     * Describes a simulation application.
     */
    public suspend fun describeSimulationApplication(input: DescribeSimulationApplicationRequest): DescribeSimulationApplicationResponse

    /**
     * Describes a simulation job.
     */
    public suspend fun describeSimulationJob(input: DescribeSimulationJobRequest): DescribeSimulationJobResponse

    /**
     * Describes a simulation job batch.
     */
    public suspend fun describeSimulationJobBatch(input: DescribeSimulationJobBatchRequest): DescribeSimulationJobBatchResponse

    /**
     * Describes a world.
     */
    public suspend fun describeWorld(input: DescribeWorldRequest): DescribeWorldResponse

    /**
     * Describes a world export job.
     */
    public suspend fun describeWorldExportJob(input: DescribeWorldExportJobRequest): DescribeWorldExportJobResponse

    /**
     * Describes a world generation job.
     */
    public suspend fun describeWorldGenerationJob(input: DescribeWorldGenerationJobRequest): DescribeWorldGenerationJobResponse

    /**
     * Describes a world template.
     */
    public suspend fun describeWorldTemplate(input: DescribeWorldTemplateRequest): DescribeWorldTemplateResponse

    /**
     * Gets the world template body.
     */
    public suspend fun getWorldTemplateBody(input: GetWorldTemplateBodyRequest = GetWorldTemplateBodyRequest { }): GetWorldTemplateBodyResponse

    /**
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun listDeploymentJobs(input: ListDeploymentJobsRequest = ListDeploymentJobsRequest { }): ListDeploymentJobsResponse

    /**
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest { }): ListFleetsResponse

    /**
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     */
    public suspend fun listRobotApplications(input: ListRobotApplicationsRequest = ListRobotApplicationsRequest { }): ListRobotApplicationsResponse

    /**
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun listRobots(input: ListRobotsRequest = ListRobotsRequest { }): ListRobotsResponse

    /**
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.
     */
    public suspend fun listSimulationApplications(input: ListSimulationApplicationsRequest = ListSimulationApplicationsRequest { }): ListSimulationApplicationsResponse

    /**
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.
     */
    public suspend fun listSimulationJobBatches(input: ListSimulationJobBatchesRequest = ListSimulationJobBatchesRequest { }): ListSimulationJobBatchesResponse

    /**
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     */
    public suspend fun listSimulationJobs(input: ListSimulationJobsRequest = ListSimulationJobsRequest { }): ListSimulationJobsResponse

    /**
     * Lists all tags on a AWS RoboMaker resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists world export jobs.
     */
    public suspend fun listWorldExportJobs(input: ListWorldExportJobsRequest = ListWorldExportJobsRequest { }): ListWorldExportJobsResponse

    /**
     * Lists world generator jobs.
     */
    public suspend fun listWorldGenerationJobs(input: ListWorldGenerationJobsRequest = ListWorldGenerationJobsRequest { }): ListWorldGenerationJobsResponse

    /**
     * Lists world templates.
     */
    public suspend fun listWorldTemplates(input: ListWorldTemplatesRequest = ListWorldTemplatesRequest { }): ListWorldTemplatesResponse

    /**
     * Lists worlds.
     */
    public suspend fun listWorlds(input: ListWorldsRequest = ListWorldsRequest { }): ListWorldsResponse

    /**
     * Registers a robot with a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun registerRobot(input: RegisterRobotRequest): RegisterRobotResponse

    /**
     * Restarts a running simulation job.
     */
    public suspend fun restartSimulationJob(input: RestartSimulationJobRequest): RestartSimulationJobResponse

    /**
     * Starts a new simulation job batch. The batch is defined using one or more `SimulationJobRequest` objects.
     */
    public suspend fun startSimulationJobBatch(input: StartSimulationJobBatchRequest): StartSimulationJobBatchResponse

    /**
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
    public suspend fun syncDeploymentJob(input: SyncDeploymentJobRequest): SyncDeploymentJobResponse

    /**
     * Adds or edits tags for a AWS RoboMaker resource.
     *
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings.
     *
     * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *AWS Billing and Cost Management User Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified AWS RoboMaker resource.
     *
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use `TagResource`[](https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a robot application.
     */
    public suspend fun updateRobotApplication(input: UpdateRobotApplicationRequest): UpdateRobotApplicationResponse

    /**
     * Updates a simulation application.
     */
    public suspend fun updateSimulationApplication(input: UpdateSimulationApplicationRequest): UpdateSimulationApplicationResponse

    /**
     * Updates a world template.
     */
    public suspend fun updateWorldTemplate(input: UpdateWorldTemplateRequest): UpdateWorldTemplateResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun RoboMakerClient.withConfig(block: RoboMakerClient.Config.Builder.() -> Unit): RoboMakerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRoboMakerClient(newConfig)
}

/**
 * Deletes one or more worlds in a batch operation.
 */
public suspend inline fun RoboMakerClient.batchDeleteWorlds(crossinline block: BatchDeleteWorldsRequest.Builder.() -> Unit): BatchDeleteWorldsResponse = batchDeleteWorlds(BatchDeleteWorldsRequest.Builder().apply(block).build())

/**
 * Describes one or more simulation jobs.
 */
public suspend inline fun RoboMakerClient.batchDescribeSimulationJob(crossinline block: BatchDescribeSimulationJobRequest.Builder.() -> Unit): BatchDescribeSimulationJobResponse = batchDescribeSimulationJob(BatchDescribeSimulationJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified deployment job.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.cancelDeploymentJob(crossinline block: CancelDeploymentJobRequest.Builder.() -> Unit): CancelDeploymentJobResponse = cancelDeploymentJob(CancelDeploymentJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified simulation job.
 */
public suspend inline fun RoboMakerClient.cancelSimulationJob(crossinline block: CancelSimulationJobRequest.Builder.() -> Unit): CancelSimulationJobResponse = cancelSimulationJob(CancelSimulationJobRequest.Builder().apply(block).build())

/**
 * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.
 */
public suspend inline fun RoboMakerClient.cancelSimulationJobBatch(crossinline block: CancelSimulationJobBatchRequest.Builder.() -> Unit): CancelSimulationJobBatchResponse = cancelSimulationJobBatch(CancelSimulationJobBatchRequest.Builder().apply(block).build())

/**
 * Cancels the specified export job.
 */
public suspend inline fun RoboMakerClient.cancelWorldExportJob(crossinline block: CancelWorldExportJobRequest.Builder.() -> Unit): CancelWorldExportJobResponse = cancelWorldExportJob(CancelWorldExportJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified world generator job.
 */
public suspend inline fun RoboMakerClient.cancelWorldGenerationJob(crossinline block: CancelWorldGenerationJobRequest.Builder.() -> Unit): CancelWorldGenerationJobResponse = cancelWorldGenerationJob(CancelWorldGenerationJobRequest.Builder().apply(block).build())

/**
 * Deploys a specific version of a robot application to robots in a fleet.
 *
 * This API is no longer supported and will throw an error if used.
 *
 * The robot application must have a numbered `applicationVersion` for consistency reasons. To create a new version, use `CreateRobotApplicationVersion` or see [Creating a Robot Application Version](https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
 *
 * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
 */
@Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.createDeploymentJob(crossinline block: CreateDeploymentJobRequest.Builder.() -> Unit): CreateDeploymentJobResponse = createDeploymentJob(CreateDeploymentJobRequest.Builder().apply(block).build())

/**
 * Creates a fleet, a logical group of robots running the same robot application.
 *
 * This API is no longer supported and will throw an error if used.
 */
@Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Creates a robot.
 *
 * This API is no longer supported and will throw an error if used.
 */
@Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.createRobot(crossinline block: CreateRobotRequest.Builder.() -> Unit): CreateRobotResponse = createRobot(CreateRobotRequest.Builder().apply(block).build())

/**
 * Creates a robot application.
 */
public suspend inline fun RoboMakerClient.createRobotApplication(crossinline block: CreateRobotApplicationRequest.Builder.() -> Unit): CreateRobotApplicationResponse = createRobotApplication(CreateRobotApplicationRequest.Builder().apply(block).build())

/**
 * Creates a version of a robot application.
 */
public suspend inline fun RoboMakerClient.createRobotApplicationVersion(crossinline block: CreateRobotApplicationVersionRequest.Builder.() -> Unit): CreateRobotApplicationVersionResponse = createRobotApplicationVersion(CreateRobotApplicationVersionRequest.Builder().apply(block).build())

/**
 * Creates a simulation application.
 */
public suspend inline fun RoboMakerClient.createSimulationApplication(crossinline block: CreateSimulationApplicationRequest.Builder.() -> Unit): CreateSimulationApplicationResponse = createSimulationApplication(CreateSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Creates a simulation application with a specific revision id.
 */
public suspend inline fun RoboMakerClient.createSimulationApplicationVersion(crossinline block: CreateSimulationApplicationVersionRequest.Builder.() -> Unit): CreateSimulationApplicationVersionResponse = createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest.Builder().apply(block).build())

/**
 * Creates a simulation job.
 *
 * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
 */
public suspend inline fun RoboMakerClient.createSimulationJob(crossinline block: CreateSimulationJobRequest.Builder.() -> Unit): CreateSimulationJobResponse = createSimulationJob(CreateSimulationJobRequest.Builder().apply(block).build())

/**
 * Creates a world export job.
 */
public suspend inline fun RoboMakerClient.createWorldExportJob(crossinline block: CreateWorldExportJobRequest.Builder.() -> Unit): CreateWorldExportJobResponse = createWorldExportJob(CreateWorldExportJobRequest.Builder().apply(block).build())

/**
 * Creates worlds using the specified template.
 */
public suspend inline fun RoboMakerClient.createWorldGenerationJob(crossinline block: CreateWorldGenerationJobRequest.Builder.() -> Unit): CreateWorldGenerationJobResponse = createWorldGenerationJob(CreateWorldGenerationJobRequest.Builder().apply(block).build())

/**
 * Creates a world template.
 */
public suspend inline fun RoboMakerClient.createWorldTemplate(crossinline block: CreateWorldTemplateRequest.Builder.() -> Unit): CreateWorldTemplateResponse = createWorldTemplate(CreateWorldTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a fleet.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Deletes a robot.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.deleteRobot(crossinline block: DeleteRobotRequest.Builder.() -> Unit): DeleteRobotResponse = deleteRobot(DeleteRobotRequest.Builder().apply(block).build())

/**
 * Deletes a robot application.
 */
public suspend inline fun RoboMakerClient.deleteRobotApplication(crossinline block: DeleteRobotApplicationRequest.Builder.() -> Unit): DeleteRobotApplicationResponse = deleteRobotApplication(DeleteRobotApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a simulation application.
 */
public suspend inline fun RoboMakerClient.deleteSimulationApplication(crossinline block: DeleteSimulationApplicationRequest.Builder.() -> Unit): DeleteSimulationApplicationResponse = deleteSimulationApplication(DeleteSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a world template.
 */
public suspend inline fun RoboMakerClient.deleteWorldTemplate(crossinline block: DeleteWorldTemplateRequest.Builder.() -> Unit): DeleteWorldTemplateResponse = deleteWorldTemplate(DeleteWorldTemplateRequest.Builder().apply(block).build())

/**
 * Deregisters a robot.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.deregisterRobot(crossinline block: DeregisterRobotRequest.Builder.() -> Unit): DeregisterRobotResponse = deregisterRobot(DeregisterRobotRequest.Builder().apply(block).build())

/**
 * Describes a deployment job.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.describeDeploymentJob(crossinline block: DescribeDeploymentJobRequest.Builder.() -> Unit): DescribeDeploymentJobResponse = describeDeploymentJob(DescribeDeploymentJobRequest.Builder().apply(block).build())

/**
 * Describes a fleet.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.describeFleet(crossinline block: DescribeFleetRequest.Builder.() -> Unit): DescribeFleetResponse = describeFleet(DescribeFleetRequest.Builder().apply(block).build())

/**
 * Describes a robot.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.describeRobot(crossinline block: DescribeRobotRequest.Builder.() -> Unit): DescribeRobotResponse = describeRobot(DescribeRobotRequest.Builder().apply(block).build())

/**
 * Describes a robot application.
 */
public suspend inline fun RoboMakerClient.describeRobotApplication(crossinline block: DescribeRobotApplicationRequest.Builder.() -> Unit): DescribeRobotApplicationResponse = describeRobotApplication(DescribeRobotApplicationRequest.Builder().apply(block).build())

/**
 * Describes a simulation application.
 */
public suspend inline fun RoboMakerClient.describeSimulationApplication(crossinline block: DescribeSimulationApplicationRequest.Builder.() -> Unit): DescribeSimulationApplicationResponse = describeSimulationApplication(DescribeSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Describes a simulation job.
 */
public suspend inline fun RoboMakerClient.describeSimulationJob(crossinline block: DescribeSimulationJobRequest.Builder.() -> Unit): DescribeSimulationJobResponse = describeSimulationJob(DescribeSimulationJobRequest.Builder().apply(block).build())

/**
 * Describes a simulation job batch.
 */
public suspend inline fun RoboMakerClient.describeSimulationJobBatch(crossinline block: DescribeSimulationJobBatchRequest.Builder.() -> Unit): DescribeSimulationJobBatchResponse = describeSimulationJobBatch(DescribeSimulationJobBatchRequest.Builder().apply(block).build())

/**
 * Describes a world.
 */
public suspend inline fun RoboMakerClient.describeWorld(crossinline block: DescribeWorldRequest.Builder.() -> Unit): DescribeWorldResponse = describeWorld(DescribeWorldRequest.Builder().apply(block).build())

/**
 * Describes a world export job.
 */
public suspend inline fun RoboMakerClient.describeWorldExportJob(crossinline block: DescribeWorldExportJobRequest.Builder.() -> Unit): DescribeWorldExportJobResponse = describeWorldExportJob(DescribeWorldExportJobRequest.Builder().apply(block).build())

/**
 * Describes a world generation job.
 */
public suspend inline fun RoboMakerClient.describeWorldGenerationJob(crossinline block: DescribeWorldGenerationJobRequest.Builder.() -> Unit): DescribeWorldGenerationJobResponse = describeWorldGenerationJob(DescribeWorldGenerationJobRequest.Builder().apply(block).build())

/**
 * Describes a world template.
 */
public suspend inline fun RoboMakerClient.describeWorldTemplate(crossinline block: DescribeWorldTemplateRequest.Builder.() -> Unit): DescribeWorldTemplateResponse = describeWorldTemplate(DescribeWorldTemplateRequest.Builder().apply(block).build())

/**
 * Gets the world template body.
 */
public suspend inline fun RoboMakerClient.getWorldTemplateBody(crossinline block: GetWorldTemplateBodyRequest.Builder.() -> Unit): GetWorldTemplateBodyResponse = getWorldTemplateBody(GetWorldTemplateBodyRequest.Builder().apply(block).build())

/**
 * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.listDeploymentJobs(crossinline block: ListDeploymentJobsRequest.Builder.() -> Unit): ListDeploymentJobsResponse = listDeploymentJobs(ListDeploymentJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.listFleets(crossinline block: ListFleetsRequest.Builder.() -> Unit): ListFleetsResponse = listFleets(ListFleetsRequest.Builder().apply(block).build())

/**
 * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
 */
public suspend inline fun RoboMakerClient.listRobotApplications(crossinline block: ListRobotApplicationsRequest.Builder.() -> Unit): ListRobotApplicationsResponse = listRobotApplications(ListRobotApplicationsRequest.Builder().apply(block).build())

/**
 * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.listRobots(crossinline block: ListRobotsRequest.Builder.() -> Unit): ListRobotsResponse = listRobots(ListRobotsRequest.Builder().apply(block).build())

/**
 * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.
 */
public suspend inline fun RoboMakerClient.listSimulationApplications(crossinline block: ListSimulationApplicationsRequest.Builder.() -> Unit): ListSimulationApplicationsResponse = listSimulationApplications(ListSimulationApplicationsRequest.Builder().apply(block).build())

/**
 * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.
 */
public suspend inline fun RoboMakerClient.listSimulationJobBatches(crossinline block: ListSimulationJobBatchesRequest.Builder.() -> Unit): ListSimulationJobBatchesResponse = listSimulationJobBatches(ListSimulationJobBatchesRequest.Builder().apply(block).build())

/**
 * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
 */
public suspend inline fun RoboMakerClient.listSimulationJobs(crossinline block: ListSimulationJobsRequest.Builder.() -> Unit): ListSimulationJobsResponse = listSimulationJobs(ListSimulationJobsRequest.Builder().apply(block).build())

/**
 * Lists all tags on a AWS RoboMaker resource.
 */
public suspend inline fun RoboMakerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists world export jobs.
 */
public suspend inline fun RoboMakerClient.listWorldExportJobs(crossinline block: ListWorldExportJobsRequest.Builder.() -> Unit): ListWorldExportJobsResponse = listWorldExportJobs(ListWorldExportJobsRequest.Builder().apply(block).build())

/**
 * Lists world generator jobs.
 */
public suspend inline fun RoboMakerClient.listWorldGenerationJobs(crossinline block: ListWorldGenerationJobsRequest.Builder.() -> Unit): ListWorldGenerationJobsResponse = listWorldGenerationJobs(ListWorldGenerationJobsRequest.Builder().apply(block).build())

/**
 * Lists world templates.
 */
public suspend inline fun RoboMakerClient.listWorldTemplates(crossinline block: ListWorldTemplatesRequest.Builder.() -> Unit): ListWorldTemplatesResponse = listWorldTemplates(ListWorldTemplatesRequest.Builder().apply(block).build())

/**
 * Lists worlds.
 */
public suspend inline fun RoboMakerClient.listWorlds(crossinline block: ListWorldsRequest.Builder.() -> Unit): ListWorldsResponse = listWorlds(ListWorldsRequest.Builder().apply(block).build())

/**
 * Registers a robot with a fleet.
 *
 * This API is no longer supported and will throw an error if used.
 */
@Deprecated("AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.registerRobot(crossinline block: RegisterRobotRequest.Builder.() -> Unit): RegisterRobotResponse = registerRobot(RegisterRobotRequest.Builder().apply(block).build())

/**
 * Restarts a running simulation job.
 */
public suspend inline fun RoboMakerClient.restartSimulationJob(crossinline block: RestartSimulationJobRequest.Builder.() -> Unit): RestartSimulationJobResponse = restartSimulationJob(RestartSimulationJobRequest.Builder().apply(block).build())

/**
 * Starts a new simulation job batch. The batch is defined using one or more `SimulationJobRequest` objects.
 */
public suspend inline fun RoboMakerClient.startSimulationJobBatch(crossinline block: StartSimulationJobBatchRequest.Builder.() -> Unit): StartSimulationJobBatchResponse = startSimulationJobBatch(StartSimulationJobBatchRequest.Builder().apply(block).build())

/**
 * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("Support for the AWS RoboMaker application deployment feature has ended. For additional information, see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.")
public suspend inline fun RoboMakerClient.syncDeploymentJob(crossinline block: SyncDeploymentJobRequest.Builder.() -> Unit): SyncDeploymentJobResponse = syncDeploymentJob(SyncDeploymentJobRequest.Builder().apply(block).build())

/**
 * Adds or edits tags for a AWS RoboMaker resource.
 *
 * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings.
 *
 * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *AWS Billing and Cost Management User Guide*.
 */
public suspend inline fun RoboMakerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified AWS RoboMaker resource.
 *
 * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use `TagResource`[](https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
 */
public suspend inline fun RoboMakerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a robot application.
 */
public suspend inline fun RoboMakerClient.updateRobotApplication(crossinline block: UpdateRobotApplicationRequest.Builder.() -> Unit): UpdateRobotApplicationResponse = updateRobotApplication(UpdateRobotApplicationRequest.Builder().apply(block).build())

/**
 * Updates a simulation application.
 */
public suspend inline fun RoboMakerClient.updateSimulationApplication(crossinline block: UpdateSimulationApplicationRequest.Builder.() -> Unit): UpdateSimulationApplicationResponse = updateSimulationApplication(UpdateSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Updates a world template.
 */
public suspend inline fun RoboMakerClient.updateWorldTemplate(crossinline block: UpdateWorldTemplateRequest.Builder.() -> Unit): UpdateWorldTemplateResponse = updateWorldTemplate(UpdateWorldTemplateRequest.Builder().apply(block).build())
